/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.item_pointer;

import java.io.File;
import java.net.URI;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.ast.codecompletion.revisited.modules.IAbstractJavaClassModule;
import org.python.pydev.ast.codecompletion.revisited.modules.IJavaDefinition;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.core.PropertiesHelper;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.locator.BaseItemPointer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Location;

public class ItemPointer
extends BaseItemPointer {
    public final Definition definition;
    public final String zipFilePath;
    private URI uri;

    public ItemPointer(Object file) {
        this(file, new Location(), new Location());
    }

    public ItemPointer(Object file, SimpleNode n) {
        super(file, new Location(n.beginLine - 1, n.beginColumn - 1), new Location(n.beginLine - 1, n.beginColumn - 1));
        this.definition = null;
        this.zipFilePath = null;
    }

    public ItemPointer(Object file, Location start, Location end) {
        this(file, start, end, null, null);
    }

    public ItemPointer(Object file, Location start, Location end, Definition definition, String zipFilePath) {
        super(file, start, end);
        this.definition = definition;
        this.zipFilePath = zipFilePath;
    }

    public ItemPointer(Object file, Location start, Location end, Definition definition, String zipFilePath, URI uri) {
        this(file, start, end, definition, zipFilePath);
        this.uri = uri;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ItemPointer i = (ItemPointer)((Object)obj);
        if (!i.file.equals(this.file)) {
            return false;
        }
        if (!i.start.equals((Object)this.start)) {
            return false;
        }
        if (!i.end.equals((Object)this.end)) {
            return false;
        }
        if (i.zipFilePath != null && this.zipFilePath == null) {
            return false;
        }
        return this.zipFilePath == null || this.zipFilePath.equals(i.zipFilePath);
    }

    public URI getFileAsURI() {
        File f;
        String filename;
        if (this.uri != null) {
            return this.uri;
        }
        Object file = this.file;
        if (!(!(file instanceof File) || PythonPathHelper.isValidSourceFile(filename = (f = (File)file).getName()) || filename.indexOf(46) == -1 || this.zipFilePath != null && PythonPathHelper.isValidSourceFile(this.zipFilePath))) {
            if (this.definition instanceof IJavaDefinition) {
                Log.log((Throwable)new RuntimeException("Not currently able to convert JavaDefinition to URI."));
                return null;
            }
            boolean giveError = true;
            if (this.definition != null && this.definition.module instanceof IAbstractJavaClassModule) {
                Log.log((Throwable)new RuntimeException("Not currently able to convert AbstractJavaClassModule to URI."));
                return null;
            }
            if (FileTypesPreferences.isValidDll((String)filename) && f.exists()) {
                File parentFile = f.getParentFile();
                File newFile = new File(parentFile, String.valueOf(StringUtils.stripExtension((String)f.getName())) + "." + "pyx");
                if (!newFile.exists()) {
                    newFile = new File(parentFile, String.valueOf(StringUtils.stripExtension((String)f.getName())) + "." + "pxd");
                }
                if (!newFile.exists()) {
                    newFile = new File(parentFile, String.valueOf(StringUtils.stripExtension((String)f.getName())) + "." + "pxi");
                }
                if (newFile.exists()) {
                    giveError = false;
                    file = newFile;
                }
            }
            if (giveError) {
                return null;
            }
        }
        if (this.zipFilePath != null) {
            Log.log((String)StringUtils.format((String)"Not currently able to convert file with zip path to URI.\nFile: %s\nStart: %s\nEnd: %s\nZip path: %s\n", (Object[])new Object[]{file, this.start, this.end, this.zipFilePath}));
            return null;
        }
        if (file instanceof IFile) {
            f = (IFile)file;
            return f.getRawLocationURI();
        }
        if (file instanceof IPath) {
            IPath path = (IPath)file;
            return path.toFile().toURI();
        }
        if (file instanceof File) {
            return ((File)file).toURI();
        }
        if (file instanceof URI) {
            return (URI)file;
        }
        return null;
    }

    public String asPortableString() {
        IPath path;
        if (this.file instanceof IFile) {
            IFile f = (IFile)this.file;
            path = f.getLocation();
        } else if (this.file instanceof IPath) {
            path = (IPath)this.file;
        } else if (this.file instanceof File) {
            String absPath = FileUtils.getFileAbsolutePath((File)((File)this.file));
            path = Path.fromOSString((String)absPath);
        } else if (this.file instanceof String) {
            path = Path.fromOSString((String)((String)this.file));
        } else if (this.file == null) {
            path = null;
        } else {
            throw new RuntimeException("Don't know how to handle: " + this.file.getClass());
        }
        if (path == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.put("FILE_PATH", path.toPortableString());
        if (this.start != null) {
            properties.put("START_LINE", String.valueOf(this.start.line));
            properties.put("START_COL", String.valueOf(this.start.column));
        }
        if (this.end != null) {
            properties.put("END_LINE", String.valueOf(this.end.line));
            properties.put("END_COL", String.valueOf(this.end.column));
        }
        if (this.zipFilePath != null) {
            properties.put("ZIP", this.zipFilePath);
        }
        return PropertiesHelper.createStringFromProperties((Properties)properties);
    }

    public static ItemPointer fromPortableString(String asPortableString) {
        Properties properties = PropertiesHelper.createPropertiesFromString((String)asPortableString);
        String filePath = (String)properties.get("FILE_PATH");
        if (filePath == null) {
            return null;
        }
        String startLine = (String)properties.get("START_LINE");
        String startCol = (String)properties.get("START_COL");
        Location start = startLine != null && startCol != null ? new Location(Integer.parseInt(startLine), Integer.parseInt(startCol)) : new Location();
        String endLine = (String)properties.get("END_LINE");
        String endCol = (String)properties.get("END_COL");
        Location end = endLine != null && endCol != null ? new Location(Integer.parseInt(endLine), Integer.parseInt(endCol)) : new Location();
        String zip = (String)properties.get("ZIP");
        return new ItemPointer(Path.fromPortableString((String)filePath), start, end, null, zip);
    }
}

