/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.location;

import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.locator.GetContainers;
import org.python.pydev.shared_core.locator.GetFiles;

public class FindWorkspaceFiles {
    public static final GetFiles getFiles = new GetFiles(){

        protected IFile getFileInProject(IPath location, IProject project) {
            IFile file = super.getFileInProject(location, project);
            if (file != null) {
                return file;
            }
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null) {
                IPythonPathNature pythonPathNature = nature.getPythonPathNature();
                try {
                    Set projectSourcePathSet = pythonPathNature.getProjectSourcePathFolderSet();
                    for (IResource iResource : projectSourcePathSet) {
                        IContainer iContainer;
                        if (!(iResource instanceof IContainer) || (file = 1.getFileInContainer((IPath)location, (IContainer)(iContainer = (IContainer)iResource), (boolean)true)) == null) continue;
                        return file;
                    }
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
            return null;
        }
    };
    public static final GetContainers getContainers = new GetContainers(){

        protected IContainer getContainerInProject(IPath location, IProject project) {
            IContainer file = super.getContainerInProject(location, project);
            if (file != null) {
                return file;
            }
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null) {
                IPythonPathNature pythonPathNature = nature.getPythonPathNature();
                try {
                    Set projectSourcePathSet = pythonPathNature.getProjectSourcePathFolderSet();
                    for (IResource iResource : projectSourcePathSet) {
                        IContainer iContainer;
                        if (!(iResource instanceof IContainer) || (file = 2.getContainerInContainer((IPath)location, (IContainer)(iContainer = (IContainer)iResource), (boolean)true)) == null) continue;
                        return file;
                    }
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
            return null;
        }
    };

    public static IFile getWorkspaceFile(File file, IProject project) {
        return FindWorkspaceFiles.getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()), project);
    }

    public static IFile[] getWorkspaceFiles(File file) {
        boolean stopOnFirst = false;
        IFile[] files = FindWorkspaceFiles.getFilesForLocation(Path.fromOSString((String)file.getAbsolutePath()), null, stopOnFirst);
        if (files == null || files.length == 0) {
            return null;
        }
        return files;
    }

    public static IContainer getContainerForLocation(IPath location, IProject project) {
        return getContainers.getContainerForLocation(location, project);
    }

    public static IContainer[] getContainersForLocation(IPath location) {
        boolean stopOnFirst = false;
        return getContainers.getContainersForLocation(location, null, stopOnFirst);
    }

    public static IFile getFileForLocation(IPath location, IProject project) {
        return getFiles.getFileForLocation(location, project);
    }

    public static IFile[] getFilesForLocation(IPath location, IProject project, boolean stopOnFirst) {
        return getFiles.getFilesForLocation(location, project, stopOnFirst);
    }
}

