/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.refactoring;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.codecompletion.revisited.CompletionParticipantsHelper;
import org.python.pydev.ast.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.ast.codecompletion.revisited.visitors.Definition;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.ast.item_pointer.ItemPointer;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.structure.Location;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;

public class PyRefactoringFindDefinition {
    public static String[] findActualDefinition(RefactoringRequest request, ICompletionState completionCache, List<IDefinition> selected) throws CompletionRecursionException, BadLocationException {
        String[] tokenAndQual;
        request.getMonitor().beginTask("Find actual definition", 5);
        try {
            request.communicateWork("Finding Definition");
            IModule mod = PyRefactoringFindDefinition.prepareRequestForFindDefinition(request);
            if (mod == null) {
                return null;
            }
            String modName = request.moduleName;
            request.communicateWork("Module name found:" + modName);
            tokenAndQual = PySelection.getActivationTokenAndQualifier((IDocument)request.getDoc(), (int)request.ps.getAbsoluteCursorOffset(), (boolean)true);
            String tok = String.valueOf(tokenAndQual[0]) + tokenAndQual[1];
            try {
                int beginLine = request.getBeginLine();
                int beginCol = request.getBeginCol() + 1;
                IPythonNature pythonNature = request.nature;
                PyRefactoringFindDefinition.findActualDefinition(request.getMonitor(), request.acceptTypeshed, mod, tok, selected, beginLine, beginCol, pythonNature, (ICompletionCache)completionCache);
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (CompletionRecursionException e) {
                throw e;
            }
            catch (BadLocationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            request.getMonitor().done();
        }
        return tokenAndQual;
    }

    private static IModule prepareRequestForFindDefinition(RefactoringRequest request) {
        String modName = null;
        if (request.nature == null) {
            Tuple<IPythonNature, String> infoForFile = InterpreterManagersAPI.getInfoForFile(request.file);
            if (infoForFile != null) {
                modName = (String)infoForFile.o2;
                request.nature = (IPythonNature)infoForFile.o1;
                request.inputName = modName;
            } else {
                return null;
            }
        }
        if (modName == null) {
            modName = request.resolveModule();
        }
        if (request.nature == null) {
            Log.logInfo((String)"Unable to resolve nature for find definition request (python or jython interpreter may not be configured).");
            return null;
        }
        IModule mod = request.getModule();
        if (mod == null) {
            Log.logInfo((String)"Unable to resolve module for find definition request.");
            return null;
        }
        if (modName == null) {
            if (mod.getName() == null && mod instanceof SourceModule) {
                SourceModule m = (SourceModule)mod;
                modName = "__module_not_in_the_pythonpath__";
                m.setName(modName);
            }
            if (modName == null) {
                Log.logInfo((String)"Unable to resolve module for find definition request (modName == null).");
                return null;
            }
        }
        request.moduleName = modName;
        return mod;
    }

    public static void findActualDefinition(IProgressMonitor monitor, boolean acceptTypeshed, IModule mod, String tok, List<IDefinition> selected, int beginLine, int beginCol, IPythonNature pythonNature, ICompletionCache completionCache) throws CompletionRecursionException, Exception {
        PyRefactoringFindDefinition.findActualDefinition(monitor, acceptTypeshed, mod, tok, selected, beginLine, beginCol, pythonNature, completionCache, true);
    }

    public static List<IDefinition> findActualDefinition(IProgressMonitor monitor, boolean acceptTypeshed, IModule mod, String tok, List<IDefinition> foundDefinitions, int beginLine, int beginCol, IPythonNature pythonNature, ICompletionCache completionCache, boolean searchForMethodParameterFromParticipants) throws Exception, CompletionRecursionException {
        if (foundDefinitions == null) {
            foundDefinitions = new ArrayList<IDefinition>();
        }
        ICompletionState completionState = CompletionStateFactory.getEmptyCompletionState(tok, pythonNature, beginLine - 1, beginCol - 1, completionCache);
        completionState.setAcceptTypeshed(acceptTypeshed);
        IDefinition[] definitions = mod.findDefinition(completionState, beginLine, beginCol, pythonNature);
        if (monitor != null) {
            monitor.setTaskName("Found:" + definitions.length + " definitions");
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return foundDefinitions;
            }
        }
        int len = definitions.length;
        int i = 0;
        while (i < len) {
            IDefinition definition = definitions[i];
            boolean doAdd = true;
            if (definition instanceof Definition) {
                Definition d = (Definition)definition;
                boolean bl = doAdd = !PyRefactoringFindDefinition.findActualTokenFromImportFromDefinition(pythonNature, tok, foundDefinitions, d, completionState, searchForMethodParameterFromParticipants);
            }
            if (monitor != null && monitor.isCanceled()) {
                return foundDefinitions;
            }
            if (doAdd) {
                foundDefinitions.add(definition);
            }
            ++i;
        }
        return foundDefinitions;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean findActualTokenFromImportFromDefinition(IPythonNature nature, String tok, List<IDefinition> selected, Definition d, ICompletionState completionCache, boolean searchForMethodParameterFromParticipants) throws Exception {
        didFindNewDef = false;
        whereWePassed = new HashSet<Tuple3<String, Integer, Integer>>();
        tok = FullRepIterable.getLastPart((String)tok);
        if (!searchForMethodParameterFromParticipants || !(d.ast instanceof Name)) ** GOTO lbl13
        name = (Name)d.ast;
        if (name.ctx != 6 || d.scope == null || d.scope.getScopeStack().empty() || !((peek = d.scope.getScopeStack().peek()) instanceof FunctionDef) || (found = CompletionParticipantsHelper.findDefinitionForMethodParameterFromParticipants(d, nature, completionCache)) == null) ** GOTO lbl13
        selected.add(found);
        return true;
        while ((found = PyRefactoringFindDefinition.followDefinition(d, whereWePassed, tok, nature, (ICompletionCache)completionCache)) != null && found.length == 1 && (tupFromDefinition = PyRefactoringFindDefinition.getTupFromDefinition((Definition)found[0])) != null) {
            didFindNewDef = true;
            d = (Definition)found[0];
lbl13:
            // 3 sources

            if (d.ast instanceof ImportFrom) continue;
        }
        if (didFindNewDef) {
            selected.add(d);
        }
        return didFindNewDef;
    }

    public static IDefinition[] followDefinition(Definition d, Set<Tuple3<String, Integer, Integer>> whereWePassed, String tok, IPythonNature nature, ICompletionCache completionCache) throws Exception {
        Tuple3<String, Integer, Integer> t1 = PyRefactoringFindDefinition.getTupFromDefinition(d);
        if (t1 == null) {
            return null;
        }
        if (whereWePassed.contains(t1)) {
            return null;
        }
        whereWePassed.add(t1);
        IDefinition[] found = d.module.findDefinition(CompletionStateFactory.getEmptyCompletionState(tok, nature, completionCache), d.line, d.col, nature);
        return found;
    }

    public static Tuple3<String, Integer, Integer> getTupFromDefinition(Definition d) {
        if (d == null) {
            return null;
        }
        File file = d.module.getFile();
        if (file == null) {
            return null;
        }
        return new Tuple3((Object)FileUtils.getFileAbsolutePath((File)file), (Object)d.line, (Object)d.col);
    }

    public static void getAsPointers(List<ItemPointer> pointers, IDefinition[] definitions) {
        IDefinition[] iDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            IDefinition definition = iDefinitionArray[n2];
            ItemPointer itemPointer = PyRefactoringFindDefinition.createItemPointer(definition);
            pointers.add(itemPointer);
            ++n2;
        }
    }

    public static ItemPointer createItemPointer(IDefinition definition) {
        File file = definition.getModule().getFile();
        int line = definition.getLine();
        int col = definition.getCol();
        ItemPointer itemPointer = new ItemPointer(file, new Location(line - 1, col - 1), new Location(line - 1, col - 1), (Definition)definition, definition.getModule().getZipFilePath());
        return itemPointer;
    }
}

