/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ast.runners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.StringSubstitution;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.process.ProcessUtils;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.PlatformUtils;

public class SimpleRunner {
    public static Process createProcess(String[] cmdarray, String[] envp, File workingDir) throws IOException {
        return ProcessUtils.createProcess((String[])cmdarray, (String[])envp, (File)workingDir);
    }

    public static String[] getEnvironment(IPythonNature pythonNature, IInterpreterInfo interpreter, IInterpreterManager manager) throws CoreException {
        String[] env;
        String pythonPathEnvStr = "";
        try {
            if (interpreter != null) {
                pythonPathEnvStr = SimpleRunner.makePythonPathEnvString(pythonNature, interpreter, manager);
            }
            env = SimpleRunner.createEnvWithPythonpath(pythonPathEnvStr, pythonNature, manager);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            env = SimpleRunner.getDefaultSystemEnvAsArray(pythonNature);
        }
        if (interpreter != null) {
            env = interpreter.updateEnv(env);
        }
        return env;
    }

    public static String[] createEnvWithPythonpath(String pythonPathEnvStr, String interpreter, IInterpreterManager manager, IPythonNature nature) throws CoreException, MisconfigurationException {
        String[] env = SimpleRunner.createEnvWithPythonpath(pythonPathEnvStr, nature, manager);
        IInterpreterInfo info = manager.getInterpreterInfo(interpreter, (IProgressMonitor)new NullProgressMonitor());
        env = info.updateEnv(env);
        return env;
    }

    private static String[] createEnvWithPythonpath(String pythonPathEnvStr, IPythonNature nature, IInterpreterManager manager) throws CoreException {
        if (SharedCorePlugin.inTestMode()) {
            return null;
        }
        DebugPlugin defaultPlugin = DebugPlugin.getDefault();
        Map<String, String> env = SimpleRunner.getDefaultSystemEnv(defaultPlugin, nature);
        env.put("PYTHONPATH", pythonPathEnvStr);
        switch (manager.getInterpreterType()) {
            case 1: {
                env.put("CLASSPATH", pythonPathEnvStr);
                env.put("JYTHONPATH", pythonPathEnvStr);
                break;
            }
            case 2: {
                env.put("IRONPYTHONPATH", pythonPathEnvStr);
            }
        }
        return SimpleRunner.getMapEnvAsArray(env);
    }

    public static String[] getDefaultSystemEnvAsArray(IPythonNature nature) throws CoreException {
        Map<String, String> defaultSystemEnv = SimpleRunner.getDefaultSystemEnv(nature);
        if (defaultSystemEnv != null) {
            return SimpleRunner.getMapEnvAsArray(defaultSystemEnv);
        }
        return null;
    }

    public static Map<String, String> getDefaultSystemEnv(IPythonNature nature) throws CoreException {
        if (SharedCorePlugin.inTestMode()) {
            return new HashMap<String, String>(System.getenv());
        }
        DebugPlugin defaultPlugin = DebugPlugin.getDefault();
        return SimpleRunner.getDefaultSystemEnv(defaultPlugin, nature);
    }

    private static Map<String, String> getDefaultSystemEnv(DebugPlugin defaultPlugin, IPythonNature nature) throws CoreException {
        ILaunchManager launchManager = defaultPlugin.getLaunchManager();
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(launchManager.getNativeEnvironment());
        boolean win32 = PlatformUtils.isWindowsPlatform();
        for (Map.Entry entry : env.entrySet()) {
            String value;
            String key = (String)entry.getKey();
            if (win32) {
                key = key.toUpperCase();
            }
            String translated = value = (String)entry.getValue();
            if (nature != null) {
                try {
                    StringSubstitution stringSubstitution = new StringSubstitution(nature);
                    translated = stringSubstitution.performStringSubstitution(value, false);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            env.put(key, translated);
        }
        env.remove("PYTHONHOME");
        env.remove("VIRTUAL_ENV");
        return env;
    }

    public static String getArgumentsAsStr(String[] commandLine, String ... args) {
        return ProcessUtils.getArgumentsAsStr((String[])commandLine, (String[])args);
    }

    public static String makePythonPathEnvString(IPythonNature pythonNature, IInterpreterInfo interpreter, IInterpreterManager manager) {
        if (pythonNature == null) {
            if (interpreter == null) {
                return SimpleRunner.makePythonPathEnvFromPaths(new ArrayList<String>());
            }
            List pythonPath = interpreter.getPythonPath();
            return SimpleRunner.makePythonPathEnvFromPaths(pythonPath);
        }
        IPythonPathNature pythonPathNature = pythonNature.getPythonPathNature();
        if (pythonPathNature == null) {
            IProject project = pythonNature.getProject();
            String projectName = project == null ? "null?" : project.getName();
            throw new RuntimeException("The project " + projectName + " does not have the pythonpath configured, \n" + "please configure it correcly (please check the pydev getting started guide at \n" + "http://pydev.org/manual_101_root.html for better information on how to do it).");
        }
        List paths = pythonPathNature.getCompleteProjectPythonPath(interpreter, manager);
        return SimpleRunner.makePythonPathEnvFromPaths(paths);
    }

    public static String makePythonPathEnvFromPaths(Collection<String> inPaths) {
        ArrayList<String> paths = new ArrayList<String>(inPaths);
        try {
            paths.add(0, FileUtils.getFileAbsolutePath((File)CorePlugin.getScriptWithinPySrc((String)"pydev_sitecustomize")));
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        String separator = SimpleRunner.getPythonPathSeparator();
        return StringUtils.join((String)separator, paths);
    }

    public static String getPythonPathSeparator() {
        return File.pathSeparator;
    }

    public static String[] getMapEnvAsArray(Map<String, String> env) {
        return ProcessUtils.getMapEnvAsArray(env);
    }

    public Tuple<Process, String> run(String[] cmdarray, File workingDir, IPythonNature nature, IProgressMonitor monitor) {
        return this.run(cmdarray, workingDir, nature, monitor, null);
    }

    public Tuple<Process, String> run(String[] cmdarray, File workingDir, IPythonNature nature, IProgressMonitor monitor, ICallback<String[], String[]> updateEnv) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String executionString = SimpleRunner.getArgumentsAsStr(cmdarray, new String[0]);
        monitor.setTaskName("Executing: " + executionString);
        monitor.worked(5);
        Process process = null;
        try {
            monitor.setTaskName("Making pythonpath environment..." + executionString);
            String[] envp = null;
            if (nature != null) {
                envp = SimpleRunner.getEnvironment(nature, nature.getProjectInterpreter(), nature.getRelatedInterpreterManager());
            }
            monitor.setTaskName("Making exec..." + executionString);
            if (workingDir != null && !workingDir.isDirectory()) {
                throw new RuntimeException(StringUtils.format((String)"Working dir must be an existing directory (received: %s)", (Object[])new Object[]{workingDir}));
            }
            if (updateEnv != null) {
                envp = (String[])updateEnv.call((Object)envp);
            }
            process = SimpleRunner.createProcess(cmdarray, envp, workingDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Tuple((Object)process, (Object)executionString);
    }

    public Tuple<String, String> runAndGetOutput(String[] cmdarray, File workingDir, IPythonNature nature, IProgressMonitor monitor, String encoding) {
        Tuple<Process, String> r = this.run(cmdarray, workingDir, nature, monitor);
        return SimpleRunner.getProcessOutput((Process)r.o1, (String)r.o2, monitor, encoding);
    }

    public static Tuple<String, String> getProcessOutput(Process process, String executionString, IProgressMonitor monitor, String encoding) {
        return ProcessUtils.getProcessOutput((Process)process, (String)executionString, (IProgressMonitor)monitor, (String)encoding);
    }

    public static List<String> splitPythonpath(String pythonpath) {
        ArrayList<String> splitted = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(pythonpath, SimpleRunner.getPythonPathSeparator());
        while (tokenizer.hasMoreTokens()) {
            splitted.add(tokenizer.nextToken());
        }
        return splitted;
    }
}

