/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;

public class PyStructureConfigHelpers {
    public static IProject getProjectHandle(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public static void createPydevProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor, String projectType, String projectInterpreter, ICallback<List<IContainer>, IProject> getSourceFolderHandlesCallback, ICallback<List<String>, IProject> getExternalSourceFolderHandlesCallback, ICallback<List<IPath>, IProject> getExistingSourceFolderHandlesCallback) throws OperationCanceledException, CoreException {
        PyStructureConfigHelpers.createPydevProject(description, projectHandle, monitor, projectType, projectInterpreter, getSourceFolderHandlesCallback, getExternalSourceFolderHandlesCallback, getExistingSourceFolderHandlesCallback, null);
    }

    public static void createPydevProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor, String projectType, String projectInterpreter, ICallback<List<IContainer>, IProject> getSourceFolderHandlesCallback, ICallback<List<String>, IProject> getExternalSourceFolderHandlesCallback, ICallback<List<IPath>, IProject> getExistingSourceFolderHandlesCallback, ICallback<Map<String, String>, IProject> getVariableSubstitutionCallback) throws CoreException, OperationCanceledException {
        try {
            List externalPaths;
            List existingPaths;
            StringBuffer buf;
            String projectHandleName;
            List sourceFolders;
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            String projectPythonpath = null;
            if (getSourceFolderHandlesCallback != null && (sourceFolders = (List)getSourceFolderHandlesCallback.call((Object)projectHandle)) != null && sourceFolders.size() > 0) {
                projectHandleName = projectHandle.getFullPath().toString();
                buf = new StringBuffer();
                for (IContainer container : sourceFolders) {
                    if (container instanceof IFolder) {
                        IFolder iFolder = (IFolder)container;
                        iFolder.create(true, true, monitor);
                    } else if (!(container instanceof IProject)) {
                        throw new RuntimeException("Expected container to be an IFolder or IProject. Was: " + container);
                    }
                    if (buf.length() > 0) {
                        buf.append("|");
                    }
                    String containerPath = PyStructureConfigHelpers.convertToProjectRelativePath(projectHandleName, container.getFullPath().toString());
                    buf.append(containerPath);
                }
                projectPythonpath = buf.toString();
            }
            if (getExistingSourceFolderHandlesCallback != null && (existingPaths = (List)getExistingSourceFolderHandlesCallback.call((Object)projectHandle)) != null && existingPaths.size() > 0) {
                projectHandleName = projectHandle.getFullPath().toString();
                buf = new StringBuffer();
                for (IPath iPath : existingPaths) {
                    if (!iPath.toFile().exists()) {
                        Log.log((String)("Unable to create link to " + iPath.toString()));
                        continue;
                    }
                    String pathName = iPath.toString();
                    IFolder iFolder = projectHandle.getFolder(pathName.substring(pathName.lastIndexOf("/") + 1));
                    iFolder.createLink(iPath, 128, monitor);
                    if (buf.length() > 0 || projectPythonpath != null) {
                        buf.append("|");
                    }
                    String containerPath = PyStructureConfigHelpers.convertToProjectRelativePath(projectHandleName, iFolder.getFullPath().toString());
                    buf.append(containerPath);
                }
                projectPythonpath = projectPythonpath != null ? projectPythonpath.concat(buf.toString()) : buf.toString();
            }
            String externalProjectPythonpath = null;
            if (getExternalSourceFolderHandlesCallback != null && (externalPaths = (List)getExternalSourceFolderHandlesCallback.call((Object)projectHandle)) != null && externalPaths.size() > 0) {
                buf = new StringBuffer();
                for (String path : externalPaths) {
                    if (buf.length() > 0) {
                        buf.append("|");
                    }
                    buf.append(path);
                }
                externalProjectPythonpath = buf.toString();
            }
            Map variableSubstitution = null;
            if (getVariableSubstitutionCallback != null) {
                variableSubstitution = (Map)getVariableSubstitutionCallback.call((Object)projectHandle);
            }
            PythonNature.addNature(projectHandle, null, projectType, projectPythonpath, externalProjectPythonpath, projectInterpreter, variableSubstitution);
        }
        finally {
            monitor.done();
        }
    }

    public static String convertToProjectRelativePath(IProject project, IContainer container) {
        String projectHandleName = project.getFullPath().toString();
        return PyStructureConfigHelpers.convertToProjectRelativePath(projectHandleName, container.getFullPath().toString());
    }

    public static String convertToProjectRelativePath(String projectHandleName, String containerPath) {
        if (containerPath.startsWith(projectHandleName)) {
            containerPath = containerPath.substring(projectHandleName.length());
            containerPath = "/${PROJECT_DIR_NAME}" + containerPath;
        }
        return containerPath;
    }

    public static IProject createPydevProject(String projectName, IPath projectLocationPath, IProject[] references, IProgressMonitor monitor, String projectType, String projectInterpreter, ICallback<List<IContainer>, IProject> getSourceFolderHandlesCallback, ICallback<List<String>, IProject> getExternalSourceFolderHandlesCallback, ICallback<List<IPath>, IProject> getExistingSourceFolderHandlesCallback, ICallback<Map<String, String>, IProject> getVariableSubstitutionCallback) throws OperationCanceledException, CoreException {
        IProject projectHandle = PyStructureConfigHelpers.getProjectHandle(projectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(projectHandle.getName());
        description.setLocation(projectLocationPath);
        if (references != null && references.length > 0) {
            description.setReferencedProjects(references);
        }
        PyStructureConfigHelpers.createPydevProject(description, projectHandle, monitor, projectType, projectInterpreter, getSourceFolderHandlesCallback, getExternalSourceFolderHandlesCallback, getExistingSourceFolderHandlesCallback, getVariableSubstitutionCallback);
        return projectHandle;
    }
}

