/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PropertiesHelper;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.docutils.StringSubstitution;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.IPythonPathContributor;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.OrderedMap;

public class PythonPathNature
implements IPythonPathNature {
    private volatile IProject fProject;
    private volatile PythonNature fNature;
    private static QualifiedName projectSourcePathQualifiedName = null;
    private static QualifiedName projectExternalSourcePathQualifiedName = null;
    private static QualifiedName projectVariableSubstitutionQualifiedName = null;
    private boolean waited = false;
    private static final int RETURN_STRING_WITH_SEPARATOR = 1;
    private static final int RETURN_MAP_RESOLVED_TO_UNRESOLVED = 2;

    public static QualifiedName getProjectSourcePathQualifiedName() {
        if (projectSourcePathQualifiedName == null) {
            projectSourcePathQualifiedName = new QualifiedName("org.python.pydev", "PROJECT_SOURCE_PATH");
        }
        return projectSourcePathQualifiedName;
    }

    public static QualifiedName getProjectExternalSourcePathQualifiedName() {
        if (projectExternalSourcePathQualifiedName == null) {
            projectExternalSourcePathQualifiedName = new QualifiedName("org.python.pydev", "PROJECT_EXTERNAL_SOURCE_PATH");
        }
        return projectExternalSourcePathQualifiedName;
    }

    public static QualifiedName getProjectVariableSubstitutionQualifiedName() {
        if (projectVariableSubstitutionQualifiedName == null) {
            projectVariableSubstitutionQualifiedName = new QualifiedName("org.python.pydev", "PROJECT_VARIABLE_SUBSTITUTION");
        }
        return projectVariableSubstitutionQualifiedName;
    }

    public void setProject(IProject project, IPythonNature nature) {
        this.fProject = project;
        this.fNature = (PythonNature)nature;
    }

    public IPythonNature getNature() {
        return this.fNature;
    }

    public List<String> getCompleteProjectPythonPath(IInterpreterInfo interpreter, IInterpreterManager manager) {
        IModulesManager projectModulesManager = this.getProjectModulesManager();
        if (projectModulesManager == null && !this.waited) {
            this.waited = true;
            int i = 0;
            while (i < 10 && projectModulesManager == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                projectModulesManager = this.getProjectModulesManager();
                ++i;
            }
        }
        if (projectModulesManager == null) {
            return null;
        }
        return projectModulesManager.getCompletePythonPath(interpreter, manager);
    }

    private IModulesManager getProjectModulesManager() {
        PythonNature nature = this.fNature;
        if (nature == null) {
            return null;
        }
        ICodeCompletionASTManager astManager = nature.getAstManager();
        if (astManager == null) {
            return null;
        }
        return astManager.getModulesManager();
    }

    public String getOnlyProjectPythonPathStr(boolean addExternal) throws CoreException {
        String source = null;
        String external = null;
        String contributed = null;
        IProject project = this.fProject;
        PythonNature nature = this.fNature;
        if (project == null || nature == null) {
            return "";
        }
        StringSubstitution stringSubstitution = new StringSubstitution((IPythonNature)nature);
        source = (String)this.getProjectSourcePath(true, stringSubstitution, 1);
        if (addExternal) {
            external = this.getProjectExternalSourcePath(true, stringSubstitution);
        }
        contributed = stringSubstitution.performPythonpathStringSubstitution(this.getContributedSourcePath(project));
        if (source == null) {
            source = "";
        }
        List strings = StringUtils.splitAndRemoveEmptyTrimmed((String)source, (char)'|');
        FastStringBuffer buf = new FastStringBuffer();
        for (String currentPath : strings) {
            IPath location;
            if (currentPath.trim().length() <= 0) continue;
            Path p = new Path(currentPath);
            if (SharedCorePlugin.inTestMode()) {
                buf.append(currentPath);
                buf.append("|");
                continue;
            }
            boolean found = false;
            IResource r = project.findMember((IPath)(p = p.removeFirstSegments(1)));
            if (r == null) {
                r = project.getFolder((IPath)p);
            }
            if (r != null && (location = r.getLocation()) != null) {
                found = true;
                buf.append(FileUtils.getFileAbsolutePath((File)location.toFile()));
                buf.append("|");
            }
            if (found) continue;
            Log.log((int)2, (String)("Unable to find the path " + currentPath + " in the project were it's \n" + "added as a source folder for pydev (project: " + project.getName() + ") member:" + r), null);
        }
        if (external == null) {
            external = "";
        }
        return buf.append("|").append(external).append("|").append(contributed).toString();
    }

    public Set<IResource> getProjectSourcePathFolderSet() throws CoreException {
        String source = null;
        IProject project = this.fProject;
        PythonNature nature = this.fNature;
        HashSet<IResource> ret = new HashSet<IResource>();
        if (project == null || nature == null) {
            return ret;
        }
        StringSubstitution stringSubstitution = new StringSubstitution((IPythonNature)nature);
        source = (String)this.getProjectSourcePath(true, stringSubstitution, 1);
        if (source == null) {
            return ret;
        }
        List strings = StringUtils.splitAndRemoveEmptyTrimmed((String)source, (char)'|');
        for (String currentPath : strings) {
            if (currentPath.trim().length() <= 0) continue;
            Path p = new Path(currentPath);
            IResource r = project.findMember((IPath)(p = p.removeFirstSegments(1)));
            if (r == null) {
                r = project.getFolder((IPath)p);
            }
            if (r == null || !r.exists()) continue;
            ret.add(r);
        }
        return ret;
    }

    private String getContributedSourcePath(IProject project) throws CoreException {
        FastStringBuffer buff = new FastStringBuffer();
        List contributors = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_pythonpath_contrib");
        for (IPythonPathContributor contributor : contributors) {
            String additionalPythonPath = contributor.getAdditionalPythonPath(project);
            if (additionalPythonPath == null || additionalPythonPath.trim().length() <= 0) continue;
            if (buff.length() > 0) {
                buff.append("|");
            }
            buff.append(additionalPythonPath.trim());
        }
        return buff.toString();
    }

    public void setProjectSourcePath(String newSourcePath) throws CoreException {
        PythonNature nature = this.fNature;
        if (nature != null) {
            nature.getStore().setPathProperty(PythonPathNature.getProjectSourcePathQualifiedName(), newSourcePath);
        }
    }

    public void setProjectExternalSourcePath(String newExternalSourcePath) throws CoreException {
        PythonNature nature = this.fNature;
        if (nature != null) {
            nature.getStore().setPathProperty(PythonPathNature.getProjectExternalSourcePathQualifiedName(), newExternalSourcePath);
        }
    }

    public void setVariableSubstitution(Map<String, String> variableSubstitution) throws CoreException {
        PythonNature nature = this.fNature;
        if (nature != null) {
            nature.getStore().setMapProperty(PythonPathNature.getProjectVariableSubstitutionQualifiedName(), variableSubstitution);
        }
    }

    public void clearCaches() {
    }

    public Set<String> getProjectSourcePathSet(boolean replace) throws CoreException {
        PythonNature nature = this.fNature;
        if (nature == null) {
            return new HashSet<String>();
        }
        String projectSourcePath = this.getProjectSourcePath(replace);
        return new HashSet<String>(StringUtils.splitAndRemoveEmptyTrimmed((String)projectSourcePath, (char)'|'));
    }

    public String getProjectSourcePath(boolean replace) throws CoreException {
        return (String)this.getProjectSourcePath(replace, null, 1);
    }

    public OrderedMap<String, String> getProjectSourcePathResolvedToUnresolvedMap() throws CoreException {
        return (OrderedMap)this.getProjectSourcePath(true, null, 2);
    }

    private Object getProjectSourcePath(boolean replace, StringSubstitution substitution, int returnType) throws CoreException {
        boolean restore = false;
        IProject project = this.fProject;
        PythonNature nature = this.fNature;
        if (project == null || nature == null) {
            if (returnType == 1) {
                return "";
            }
            if (returnType == 2) {
                return new OrderedMap();
            }
            throw new AssertionError((Object)("Unexpected return: " + returnType));
        }
        String projectSourcePath = nature.getStore().getPathProperty(PythonPathNature.getProjectSourcePathQualifiedName());
        if (projectSourcePath == null) {
            if (returnType == 1) {
                return "";
            }
            if (returnType == 2) {
                return new OrderedMap();
            }
            throw new AssertionError((Object)("Unexpected return: " + returnType));
        }
        if (replace && substitution == null) {
            substitution = new StringSubstitution((IPythonNature)this.fNature);
        }
        StringBuffer buffer = new StringBuffer();
        List paths = StringUtils.splitAndRemoveEmptyTrimmed((String)projectSourcePath, (char)'|');
        IPath projectPath = project.getFullPath();
        for (String path : paths) {
            if (path.trim().length() <= 0) continue;
            if (path.indexOf("${") != -1) {
                buffer.append(path);
            } else {
                Path p = new Path(path);
                if (p.isEmpty()) continue;
                if (projectPath != null && !FileUtils.isPrefixOf((IPath)projectPath, (IPath)p)) {
                    p = p.removeFirstSegments(1);
                    p = projectPath.append((IPath)p);
                    restore = true;
                }
                buffer.append(p.toString());
            }
            buffer.append("|");
        }
        if (restore) {
            projectSourcePath = buffer.toString();
            this.setProjectSourcePath(projectSourcePath);
            if (nature != null) {
                nature.rebuildPath();
            }
        }
        if (returnType == 1) {
            return this.trimAndReplaceVariablesIfNeeded(replace, projectSourcePath, nature, substitution);
        }
        if (returnType == 2) {
            String ret = StringUtils.leftAndRightTrim((String)projectSourcePath, (char)'|');
            OrderedMap map = new OrderedMap();
            List unresolvedVars = StringUtils.splitAndRemoveEmptyTrimmed((String)ret, (char)'|');
            List resolved = StringUtils.splitAndRemoveEmptyTrimmed((String)substitution.performPythonpathStringSubstitution(ret), (char)'|');
            int size = unresolvedVars.size();
            if (size != resolved.size()) {
                throw new AssertionError((Object)("Error: expected same size from:\n" + unresolvedVars + "\nand\n" + resolved));
            }
            int i = 0;
            while (i < size) {
                String un = (String)unresolvedVars.get(i);
                String res = (String)resolved.get(i);
                map.put((Object)res, (Object)un);
                ++i;
            }
            return map;
        }
        throw new AssertionError((Object)("Unexpected return: " + returnType));
    }

    private String trimAndReplaceVariablesIfNeeded(boolean replace, String projectSourcePath, PythonNature nature, StringSubstitution substitution) throws CoreException {
        String ret = StringUtils.leftAndRightTrim((String)projectSourcePath, (char)'|');
        if (replace) {
            ret = substitution.performPythonpathStringSubstitution(ret);
        }
        return ret;
    }

    public String getProjectExternalSourcePath(boolean replace) throws CoreException {
        return this.getProjectExternalSourcePath(replace, null);
    }

    private String getProjectExternalSourcePath(boolean replace, StringSubstitution substitution) throws CoreException {
        PythonNature nature = this.fNature;
        if (nature == null) {
            return "";
        }
        String extPath = nature.getStore().getPathProperty(PythonPathNature.getProjectExternalSourcePathQualifiedName());
        if (extPath == null) {
            extPath = "";
        }
        if (replace && substitution == null) {
            substitution = new StringSubstitution((IPythonNature)this.fNature);
        }
        return this.trimAndReplaceVariablesIfNeeded(replace, extPath, nature, substitution);
    }

    public List<String> getProjectExternalSourcePathAsList(boolean replaceVariables) throws CoreException {
        String projectExternalSourcePath = this.getProjectExternalSourcePath(replaceVariables);
        List externalPaths = StringUtils.splitAndRemoveEmptyTrimmed((String)projectExternalSourcePath, (char)'|');
        return externalPaths;
    }

    public Map<String, String> getVariableSubstitution() throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        return this.getVariableSubstitution(true);
    }

    public Map<String, String> getVariableSubstitution(boolean addInterpreterInfoSubstitutions) throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        IInterpreterInfo info;
        Properties stringSubstitutionVariables;
        PythonNature nature = this.fNature;
        if (nature == null) {
            return new HashMap<String, String>();
        }
        Map<Object, Object> variableSubstitution = addInterpreterInfoSubstitutions ? ((stringSubstitutionVariables = (info = nature.getProjectInterpreter()).getStringSubstitutionVariables(true)) == null ? new HashMap() : PropertiesHelper.createMapFromProperties((Properties)stringSubstitutionVariables)) : new HashMap();
        Map<String, String> variableSubstitution2 = nature.getStore().getMapProperty(PythonPathNature.getProjectVariableSubstitutionQualifiedName());
        if (variableSubstitution2 != null && !variableSubstitution2.isEmpty()) {
            if (variableSubstitution != null) {
                variableSubstitution.putAll(variableSubstitution2);
            } else {
                variableSubstitution = variableSubstitution2;
            }
        }
        if (variableSubstitution == null) {
            variableSubstitution = new HashMap();
        }
        return variableSubstitution;
    }
}

