/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.parser.PyParser;
import org.python.pydev.shared_core.editor.IBaseEditor;
import org.python.pydev.shared_core.parsing.BaseParserManager;
import org.python.pydev.shared_core.parsing.IParser;

public class PyParserManager
extends BaseParserManager {
    public static final String USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE = "USE_PYDEV_ONLY_ON_DOC_SAVE";
    public static final String PYDEV_ELAPSE_BEFORE_ANALYSIS = "PYDEV_ELAPSE_BEFORE_ANALYSIS";
    private IEclipsePreferences prefs;
    private static PyParserManager pyParserManager;

    public static synchronized PyParserManager getPyParserManager(IEclipsePreferences prefs) {
        if (pyParserManager == null) {
            pyParserManager = new PyParserManager(prefs);
        }
        return pyParserManager;
    }

    public static synchronized void setPyParserManager(PyParserManager pyParserManager) {
        PyParserManager.pyParserManager = pyParserManager;
    }

    private PyParserManager(IEclipsePreferences prefs) {
        Assert.isNotNull((Object)prefs);
        this.prefs = prefs;
        this.millisBeforeAnalysis = prefs.getInt(PYDEV_ELAPSE_BEFORE_ANALYSIS, 3000);
        this.useOnlyOnSave = prefs.getBoolean(USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE, false);
        IEclipsePreferences.IPreferenceChangeListener prefListener = new IEclipsePreferences.IPreferenceChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                String property = event.getKey();
                if (property.equals(PyParserManager.USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE) || property.equals(PyParserManager.PYDEV_ELAPSE_BEFORE_ANALYSIS)) {
                    PyParserManager.this.millisBeforeAnalysis = PyParserManager.this.prefs.getInt(PyParserManager.PYDEV_ELAPSE_BEFORE_ANALYSIS, 3000);
                    PyParserManager.this.useOnlyOnSave = PyParserManager.this.prefs.getBoolean(PyParserManager.USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE, false);
                    boolean useAnalysisOnlyOnDocSave = PyParserManager.this.useAnalysisOnlyOnDocSave();
                    Object object = PyParserManager.this.lock;
                    synchronized (object) {
                        for (IParser parser : PyParserManager.this.parsers.keySet()) {
                            parser.resetTimeoutPreferences(useAnalysisOnlyOnDocSave);
                        }
                    }
                }
            }
        };
        this.prefs.addPreferenceChangeListener(prefListener);
    }

    protected IParser createParser(IBaseEditor edit) {
        return new PyParser((IPyEdit)edit);
    }
}

