/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.fastparser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.python.pydev.core.ObjectsInternPool;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.LowMemoryArrayList;
import org.python.pydev.shared_core.structure.Tuple;

public final class FastDefinitionsParser {
    private final char[] cs;
    private final File file;
    private final int length;
    private int currIndex = 0;
    private int col;
    private int leadingTabsInLine;
    private int row = 0;
    private int firstCharCol = 1;
    private final ArrayList<stmtType> body = new ArrayList(16);
    private final FastStack<NodeEntry> stack = new FastStack(10);
    private final FastStringBuffer lineBuffer = new FastStringBuffer();
    private final String moduleName;
    public static boolean throwErrorOnWarnings = false;
    private static final boolean DEBUG = false;
    private final ObjectsInternPool.ObjectsPoolMap interned = new ObjectsInternPool.ObjectsPoolMap();
    public static List<ICallback<Object, Tuple<String, SimpleNode>>> parseCallbacks = new ArrayList<ICallback<Object, Tuple<String, SimpleNode>>>();

    private FastDefinitionsParser(char[] cs, String moduleName, File f) {
        this(cs, cs.length, moduleName, f);
    }

    private FastDefinitionsParser(char[] cs, int len, String moduleName, File f) {
        this.cs = cs;
        this.length = len;
        this.moduleName = moduleName;
        this.file = f;
    }

    private void extractBody() throws SyntaxErrorException {
        ParsingUtils parsingUtils = ParsingUtils.create((Object)this.cs, (boolean)false, (int)this.length);
        if (this.currIndex < this.length) {
            this.handleNewLine(parsingUtils);
        }
        if (this.currIndex < 0) {
            this.currIndex = 0;
        }
        while (this.currIndex < this.length) {
            char c = this.cs[this.currIndex];
            block0 : switch (c) {
                case '\"': 
                case '\'': {
                    int initialIndex = this.currIndex;
                    this.currIndex = parsingUtils.getLiteralEnd(this.currIndex, c);
                    this.updateCountRow(initialIndex, this.currIndex);
                    break;
                }
                case '#': {
                    while (this.currIndex < this.length) {
                        c = this.cs[this.currIndex];
                        if (c == '\r' || c == '\n') {
                            --this.currIndex;
                            break block0;
                        }
                        ++this.currIndex;
                    }
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    int initialIndex = this.currIndex;
                    this.currIndex = parsingUtils.eatPar(this.currIndex, null, c);
                    this.updateCountRow(initialIndex, this.currIndex);
                    break;
                }
                case '\r': {
                    if (this.currIndex < this.length - 1 && this.cs[this.currIndex + 1] == '\n') {
                        ++this.currIndex;
                    }
                }
                case '\n': {
                    ++this.currIndex;
                    this.handleNewLine(parsingUtils);
                    if (this.currIndex >= this.length) break;
                    c = this.cs[this.currIndex];
                    break;
                }
                case '=': {
                    if (this.currIndex >= this.length - 1 || this.cs[this.currIndex + 1] == '=' || this.currIndex <= 0 || this.cs[this.currIndex - 1] == '=') break;
                    int initialIndex = this.currIndex;
                    this.currIndex = parsingUtils.getFullFlattenedLine(this.currIndex, this.lineBuffer);
                    this.updateCountRow(initialIndex, this.currIndex);
                    String equalsLine = this.lineBuffer.toString().trim();
                    if (PySelection.startsWithIndentToken((String)equalsLine)) break;
                    this.lineBuffer.clear();
                    List splitted = StringUtils.split((String)equalsLine, (char)'=');
                    int splittedLen = splitted.size();
                    ArrayList<exprType> targets = new ArrayList<exprType>(2);
                    int j = 0;
                    while (j < splittedLen - 1 || splittedLen == 1 && j == 0) {
                        String lineContents;
                        int addCols = 0;
                        if (j > 0) {
                            int k = 0;
                            while (k < j) {
                                addCols += ((String)splitted.get(j)).length();
                                ++addCols;
                                ++k;
                            }
                        }
                        if ((lineContents = ((String)splitted.get(j)).trim()).length() != 0) {
                            int colonIndex = lineContents.indexOf(58);
                            if (colonIndex > 0) {
                                lineContents = lineContents.substring(0, colonIndex);
                            }
                            boolean add = true;
                            int lineContentsLen = lineContents.length();
                            int i = 0;
                            while (i < lineContentsLen) {
                                char lineC = lineContents.charAt(i);
                                if (lineC != '.' && !Character.isJavaIdentifierPart(lineC)) {
                                    add = false;
                                    break;
                                }
                                ++i;
                            }
                            if (add) {
                                if (lineContents.indexOf(46) != -1) {
                                    List dotSplit = StringUtils.dotSplit((String)lineContents);
                                    if (dotSplit.size() == 2 && ((String)dotSplit.get(0)).equals("self")) {
                                        Name selfName = new Name("self", 1, false);
                                        NameTok attribName = new NameTok((String)dotSplit.get(1), 8);
                                        selfName.beginLine = this.row;
                                        selfName.beginColumn = this.firstCharCol;
                                        attribName.beginLine = this.row;
                                        attribName.beginColumn = this.firstCharCol;
                                        Attribute attribute = new Attribute(selfName, attribName, 1);
                                        attribute.beginLine = this.row;
                                        attribute.beginColumn = this.firstCharCol;
                                        targets.add(attribute);
                                    }
                                } else {
                                    Name name = new Name(lineContents, 2, false);
                                    name.beginLine = this.row;
                                    name.beginColumn = this.firstCharCol + addCols;
                                    targets.add(name);
                                }
                            }
                        }
                        ++j;
                    }
                    if (targets.size() <= 0) break;
                    Assign assign = new Assign(targets.toArray(new exprType[targets.size()]), null, null);
                    assign.beginColumn = this.firstCharCol;
                    assign.beginLine = this.row;
                    this.stack.push((Object)new NodeEntry(assign, this.leadingTabsInLine));
                }
            }
            this.lineBuffer.append(c);
            ++this.currIndex;
            ++this.col;
        }
        this.endScopesInStack(0);
    }

    public void updateCountRow(int initialIndex, int currIndex) {
        int len = this.length;
        int k = initialIndex;
        while (k < len && k <= currIndex) {
            char c = this.cs[k];
            switch (c) {
                case '\n': {
                    ++this.row;
                    break;
                }
                case '\r': {
                    ++this.row;
                    if (k >= len - 1 || k > currIndex - 1 || this.cs[k + 1] != '\n') break;
                    ++k;
                }
            }
            ++k;
        }
    }

    private void handleNewLine(ParsingUtils parsingUtils) throws SyntaxErrorException {
        if (this.currIndex >= this.length - 1) {
            return;
        }
        this.col = 1;
        this.leadingTabsInLine = 0;
        ++this.row;
        this.lineBuffer.clear();
        char c = this.cs[this.currIndex];
        while (this.currIndex < this.length - 1 && Character.isWhitespace(c) && c != '\r' && c != '\n') {
            ++this.currIndex;
            ++this.col;
            if (c == '\t') {
                ++this.leadingTabsInLine;
            }
            c = this.cs[this.currIndex];
        }
        if (!Character.isWhitespace(c) && c != '#') {
            this.endScopesInStack(this.col - this.leadingTabsInLine + this.leadingTabsInLine * 8);
        }
        int funcDefDeltaIndex = -1;
        this.firstCharCol = this.col;
        if (c == 'c' && this.matchClass()) {
            int startClassCol = this.col;
            this.currIndex += 6;
            this.col += 6;
            if (this.length <= this.currIndex) {
                return;
            }
            this.startClass(this.getNextIdentifier(c), this.row, startClassCol, this.col, this.leadingTabsInLine);
        } else if (c == 'd' && (funcDefDeltaIndex = this.matchFunction()) != -1 || c == 'a' && (funcDefDeltaIndex = this.matchAsyncFunction()) != -1) {
            int startMethodCol = this.col;
            this.currIndex += funcDefDeltaIndex + 1;
            this.col += funcDefDeltaIndex + 1;
            if (this.length <= this.currIndex) {
                return;
            }
            this.startMethod(this.getNextIdentifier(c), this.row, startMethodCol, this.col, this.leadingTabsInLine);
        }
        if (this.currIndex < this.length) {
            int initialIndex = this.currIndex;
            int tempIndex = this.skipWhitespaces(this.currIndex);
            if (tempIndex >= this.length) {
                return;
            }
            c = this.cs[tempIndex];
            boolean updateIndex = false;
            switch (c) {
                case '(': {
                    tempIndex = parsingUtils.eatPar(tempIndex, null, c);
                    if (tempIndex < this.length && (c = this.cs[tempIndex = this.skipWhitespaces(tempIndex)]) == ')') {
                        ++tempIndex;
                    }
                    if (tempIndex < this.length && (c = this.cs[tempIndex = this.skipWhitespaces(tempIndex)]) == ':') {
                        ++tempIndex;
                        if ((tempIndex = this.skipWhitespaces(tempIndex)) < this.length && (c = this.cs[tempIndex]) != '\r' && c != '\n') {
                            updateIndex = true;
                        }
                    }
                    if (updateIndex) {
                        this.currIndex = tempIndex = this.skipWhitespaces(tempIndex);
                        this.updateCountRow(initialIndex, this.currIndex);
                        int i = tempIndex;
                        while (i > 0 && i < this.length) {
                            c = this.cs[i];
                            if (c == '\r' || c == '\n') break;
                            --i;
                        }
                        this.firstCharCol = tempIndex - i;
                        break;
                    }
                    --this.currIndex;
                    break;
                }
                default: {
                    --this.currIndex;
                }
            }
        }
    }

    private int skipWhitespaces(int tempIndex) {
        while (tempIndex < this.length) {
            char c = this.cs[tempIndex];
            if (c != ' ' && c != '\t') break;
            ++tempIndex;
        }
        return tempIndex;
    }

    private String getNextIdentifier(char c) {
        c = this.cs[this.currIndex];
        while (this.currIndex < this.length && Character.isWhitespace(c)) {
            ++this.currIndex;
            c = this.cs[this.currIndex];
        }
        int currClassNameCol = this.currIndex;
        while (Character.isJavaIdentifierPart(c)) {
            ++this.currIndex;
            if (this.currIndex >= this.length) break;
            c = this.cs[this.currIndex];
        }
        return ObjectsInternPool.internLocal((ObjectsInternPool.ObjectsPoolMap)this.interned, (String)new String(this.cs, currClassNameCol, this.currIndex - currClassNameCol));
    }

    private void startMethod(String name, int startMethodRow, int startMethodCol, int nameCol, int leadingTabs) {
        NameTok nameTok = new NameTok(name, 1);
        nameTok.beginLine = startMethodRow;
        nameTok.beginColumn = nameCol;
        FunctionDef functionDef = new FunctionDef(nameTok, null, null, null, null, false);
        functionDef.beginLine = startMethodRow;
        functionDef.beginColumn = startMethodCol;
        this.stack.push((Object)new NodeEntry(functionDef, leadingTabs));
    }

    private void startClass(String name, int startClassRow, int startClassCol, int nameCol, int leadingTabs) {
        NameTok nameTok = new NameTok(name, 1);
        nameTok.beginLine = startClassRow;
        nameTok.beginColumn = nameCol;
        ClassDef classDef = new ClassDef(nameTok, null, null, null, null, null, null);
        classDef.beginLine = startClassRow;
        classDef.beginColumn = startClassCol;
        this.stack.push((Object)new NodeEntry(classDef, leadingTabs));
    }

    private void endScopesInStack(int currLogicalCol) {
        while (this.stack.size() > 0) {
            NodeEntry peek = (NodeEntry)this.stack.peek();
            if (peek.logicalColumn < currLogicalCol) break;
            NodeEntry currNode = (NodeEntry)this.stack.pop();
            currNode.onEndScope();
            if (this.stack.size() > 0) {
                NodeEntry parentNode = (NodeEntry)this.stack.peek();
                if (parentNode.node instanceof FunctionDef) {
                    if (!(currNode.node instanceof Assign) || this.stack.size() <= 1) continue;
                    Assign assign = (Assign)currNode.node;
                    exprType target = assign.targets[0];
                    if (!(target instanceof Attribute)) continue;
                    NodeEntry parentParents = (NodeEntry)this.stack.peek(1);
                    if (!(parentParents.node instanceof ClassDef)) continue;
                    parentNode.body.add(currNode.node);
                    continue;
                }
                if (parentNode.node instanceof ClassDef) {
                    parentNode.body.add(currNode.node);
                    continue;
                }
                String msg = "Did not expect to find item below node: " + parentNode.node + " (module: " + this.moduleName + " file: " + this.file + " row: " + this.row + ").";
                if (throwErrorOnWarnings) {
                    throw new RuntimeException(msg);
                }
                Log.log((String)msg);
                continue;
            }
            this.body.add(currNode.node);
        }
    }

    private boolean matchClass() {
        return ParsingUtils.matchClass((int)this.currIndex, (char[])this.cs, (int)this.length) != -1;
    }

    private int matchFunction() {
        int matchAt = ParsingUtils.matchFunction((int)this.currIndex, (char[])this.cs, (int)this.length);
        if (matchAt != -1) {
            return matchAt - this.currIndex;
        }
        return matchAt;
    }

    private int matchAsyncFunction() {
        int matchAt = ParsingUtils.matchAsyncFunction((int)this.currIndex, (char[])this.cs, (int)this.length);
        if (matchAt != -1) {
            return matchAt - this.currIndex;
        }
        return matchAt;
    }

    public static SimpleNode parse(String s, String moduleName, File f) {
        return FastDefinitionsParser.parse(s.toCharArray(), moduleName, f);
    }

    public static SimpleNode parse(char[] cs, String moduleName, File f) {
        return FastDefinitionsParser.parse(cs, moduleName, cs.length, f);
    }

    public static SimpleNode parse(char[] cs, String moduleName, int len, File f) {
        FastDefinitionsParser parser = new FastDefinitionsParser(cs, len, moduleName, f);
        try {
            parser.extractBody();
        }
        catch (SyntaxErrorException e) {
            throw new RuntimeException(e);
        }
        catch (StackOverflowError e) {
            RuntimeException runtimeException = new RuntimeException(e);
            Log.log((String)("Error parsing: " + moduleName + " - " + f + "\nContents:\n" + new String(cs, 0, len > 1000 ? 1000 : len)), (Throwable)runtimeException);
            throw runtimeException;
        }
        ArrayList<stmtType> body = parser.body;
        Module ret = new Module(body.toArray(new stmtType[body.size()]));
        ret.beginLine = 1;
        ret.beginColumn = 1;
        if (parseCallbacks.size() > 0) {
            Tuple arg = new Tuple((Object)moduleName, (Object)ret);
            for (ICallback<Object, Tuple<String, SimpleNode>> c : parseCallbacks) {
                c.call((Object)arg);
            }
        }
        return ret;
    }

    public static SimpleNode parse(String s) {
        return FastDefinitionsParser.parse(s.toCharArray(), null, null);
    }

    private static class NodeEntry {
        public final stmtType node;
        public final List<SimpleNode> body = new LowMemoryArrayList();
        public final int logicalColumn;

        public NodeEntry(stmtType stmt, int leadingTabs) {
            this.node = stmt;
            this.logicalColumn = stmt.beginColumn - leadingTabs + leadingTabs * 8;
        }

        public void onEndScope() {
            if (this.body.size() > 0) {
                stmtType[] array = this.body.toArray(new stmtType[this.body.size()]);
                if (this.node instanceof ClassDef) {
                    ClassDef classDef = (ClassDef)this.node;
                    classDef.body = array;
                } else if (this.node instanceof FunctionDef) {
                    FunctionDef functionDef = (FunctionDef)this.node;
                    functionDef.body = array;
                } else {
                    String msg = "Assign statement is not expected to have body!";
                    if (throwErrorOnWarnings) {
                        throw new RuntimeException(msg);
                    }
                    Log.log((String)msg);
                    return;
                }
            }
        }
    }
}

