/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.fastparser.grammar_fstrings_common;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.fastparser.grammar_fstrings_common.SimpleNode;
import org.python.pydev.shared_core.string.TextSelectionUtils;

public class FStringsAST {
    private SimpleNode rootNode;

    public FStringsAST(SimpleNode rootNode) {
        this.rootNode = rootNode;
    }

    public void dump() {
        this.rootNode.dump("");
    }

    public void dump(IDocument doc) {
        this.rootNode.dump("", doc);
    }

    public boolean hasChildren() {
        return this.rootNode != null && this.rootNode.jjtGetNumChildren() > 0;
    }

    public Iterable<SimpleNode> childNodesOfId(int id) {
        SimpleNode node = this.rootNode;
        return FStringsAST.childNodesOfId(node, id);
    }

    public static Iterable<SimpleNode> childNodesOfId(SimpleNode node, int id) {
        int nChildren = node.jjtGetNumChildren();
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>(nChildren);
        int i = 0;
        while (i < nChildren) {
            SimpleNode n = (SimpleNode)node.jjtGetChild(i);
            if (n.id == id) {
                arrayList.add(n);
            }
            ++i;
        }
        return arrayList;
    }

    public Iterable<SimpleNode> getFStringExpressions() {
        return this.childNodesOfId(1);
    }

    public Iterable<SimpleNode> getBalancedExpressionsToBeEvaluatedInRegularGrammar() {
        return this.rootNode.collectChildren(4);
    }

    public Iterable<FStringExpressionContent> getFStringExpressionsContent(IDocument doc) {
        Iterable<SimpleNode> fStringExpressions = this.getBalancedExpressionsToBeEvaluatedInRegularGrammar();
        ArrayList<FStringExpressionContent> lst = new ArrayList<FStringExpressionContent>(this.rootNode.jjtGetNumChildren());
        for (SimpleNode simpleNode : fStringExpressions) {
            try {
                int startOffset = TextSelectionUtils.getAbsoluteCursorOffset((IDocument)doc, (int)(simpleNode.beginLine - 1), (int)(simpleNode.beginColumn - 1));
                int endOffset = TextSelectionUtils.getAbsoluteCursorOffset((IDocument)doc, (int)(simpleNode.endLine - 1), (int)simpleNode.endColumn);
                String string = doc.get(startOffset, endOffset - startOffset);
                if (string.endsWith("=")) {
                    string = string.substring(0, string.length() - 1);
                }
                lst.add(new FStringExpressionContent(string, startOffset, endOffset, simpleNode.beginLine, simpleNode.beginColumn, simpleNode.endLine, simpleNode.endColumn));
            }
            catch (RuntimeException | BadLocationException e) {
                Log.log((Throwable)e);
            }
        }
        return lst;
    }

    public static class FStringExpressionContent {
        public final String string;
        public final int startOffset;
        public final int endOffset;
        public final int beginLine;
        public final int beginColumn;
        public final int endLine;
        public final int endColumn;

        public FStringExpressionContent(String string, int startOffset, int endOffset, int beginLine, int beginColumn, int endLine, int endColumn) {
            this.string = string;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.beginLine = beginLine;
            this.beginColumn = beginColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
        }
    }
}

