/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.fastparser.grammar_fstrings_common;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.fastparser.grammar_fstrings_common.Node;
import org.python.pydev.parser.grammar_fstrings.FStringsGrammar;
import org.python.pydev.parser.grammar_fstrings.FStringsGrammarTreeConstants;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.LowMemoryArrayList;

public class SimpleNode
implements Node,
Iterable<SimpleNode> {
    protected Node parent;
    protected Node[] children;
    public final int id;
    protected Object value;
    public int beginColumn;
    public int endColumn;
    public int beginLine;
    public int endLine;

    public SimpleNode(int i) {
        this.id = i;
    }

    public static Node jjtCreate(FStringsGrammar p, int id) {
        return new SimpleNode(id);
    }

    @Override
    public void jjtOpen(FStringsGrammar parser) {
    }

    @Override
    public void jjtClose(FStringsGrammar parser) {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object value) {
        this.value = value;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    public String toString() {
        return StringUtils.join((String)"", (Object[])new Object[]{FStringsGrammarTreeConstants.jjtNodeName[this.id], " (", this.beginLine, ", ", this.beginColumn, ") -> (", this.endLine, ", ", this.endColumn, ")"});
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + this.toString();
    }

    public void dump(String prefix) {
        this.dump(prefix, null);
    }

    public void dump(String prefix, IDocument doc) {
        String contentsFromString = "";
        if (doc != null && this.beginColumn > 0 && this.beginLine > 0) {
            try {
                contentsFromString = " - " + this.getContentsFromString(doc);
            }
            catch (RuntimeException | BadLocationException e) {
                Log.log((Throwable)e);
            }
        }
        System.out.println(String.valueOf(this.toString(prefix)) + contentsFromString);
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n != null) {
                    n.dump(String.valueOf(prefix) + " ", doc);
                }
                ++i;
            }
        }
    }

    public String getContentsFromString(IDocument doc) throws BadLocationException {
        int offset1 = TextSelectionUtils.getAbsoluteCursorOffset((IDocument)doc, (int)(this.beginLine - 1), (int)(this.beginColumn - 1));
        int offset2 = TextSelectionUtils.getAbsoluteCursorOffset((IDocument)doc, (int)(this.endLine - 1), (int)this.endColumn);
        return doc.get(offset1, offset2 - offset1);
    }

    @Override
    public Iterator<SimpleNode> iterator() {
        return new Iterator<SimpleNode>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < SimpleNode.this.jjtGetNumChildren();
            }

            @Override
            public SimpleNode next() {
                SimpleNode child = (SimpleNode)SimpleNode.this.jjtGetChild(this.i);
                ++this.i;
                return child;
            }
        };
    }

    public List<SimpleNode> collectChildren(int id) {
        LowMemoryArrayList ret = new LowMemoryArrayList();
        this.collectChildren(id, (List<SimpleNode>)ret);
        return ret;
    }

    public void collectChildren(int id, List<SimpleNode> ret) {
        if (this != null) {
            int numChildren = this.jjtGetNumChildren();
            int i = 0;
            while (i < numChildren) {
                SimpleNode child = (SimpleNode)this.jjtGetChild(i);
                if (child.id == id) {
                    ret.add(child);
                }
                child.collectChildren(id, ret);
                ++i;
            }
        }
    }
}

