/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.util.Arrays;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.stmtType;

public final class ClassDef
extends stmtType {
    public NameTokType name;
    public exprType[] bases;
    public stmtType[] body;
    public decoratorsType[] decs;
    public keywordType[] keywords;
    public exprType starargs;
    public exprType kwargs;

    public ClassDef(NameTokType name, exprType[] bases, stmtType[] body, decoratorsType[] decs, keywordType[] keywords, exprType starargs, exprType kwargs) {
        this.name = name;
        this.bases = bases;
        this.body = body;
        this.decs = decs;
        this.keywords = keywords;
        this.starargs = starargs;
        this.kwargs = kwargs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.bases);
        result = 31 * result + Arrays.hashCode(this.body);
        result = 31 * result + Arrays.hashCode(this.decs);
        result = 31 * result + Arrays.hashCode(this.keywords);
        result = 31 * result + (this.starargs == null ? 0 : this.starargs.hashCode());
        result = 31 * result + (this.kwargs == null ? 0 : this.kwargs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassDef other = (ClassDef)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!Arrays.equals(this.bases, other.bases)) {
            return false;
        }
        if (!Arrays.equals(this.body, other.body)) {
            return false;
        }
        if (!Arrays.equals(this.decs, other.decs)) {
            return false;
        }
        if (!Arrays.equals(this.keywords, other.keywords)) {
            return false;
        }
        if (this.starargs == null ? other.starargs != null : !this.starargs.equals(other.starargs)) {
            return false;
        }
        return !(this.kwargs == null ? other.kwargs != null : !this.kwargs.equals(other.kwargs));
    }

    @Override
    public ClassDef createCopy() {
        return this.createCopy(true);
    }

    @Override
    public ClassDef createCopy(boolean copyComments) {
        commentType commentType2;
        keywordType[] new3;
        decoratorsType[] new2;
        stmtType[] new1;
        exprType[] new0;
        if (this.bases != null) {
            new0 = new exprType[this.bases.length];
            int i = 0;
            while (i < this.bases.length) {
                new0[i] = (exprType)(this.bases[i] != null ? this.bases[i].createCopy(copyComments) : null);
                ++i;
            }
        } else {
            new0 = this.bases;
        }
        if (this.body != null) {
            new1 = new stmtType[this.body.length];
            int i = 0;
            while (i < this.body.length) {
                new1[i] = (stmtType)(this.body[i] != null ? this.body[i].createCopy(copyComments) : null);
                ++i;
            }
        } else {
            new1 = this.body;
        }
        if (this.decs != null) {
            new2 = new decoratorsType[this.decs.length];
            int i = 0;
            while (i < this.decs.length) {
                new2[i] = this.decs[i] != null ? this.decs[i].createCopy(copyComments) : null;
                ++i;
            }
        } else {
            new2 = this.decs;
        }
        if (this.keywords != null) {
            new3 = new keywordType[this.keywords.length];
            int i = 0;
            while (i < this.keywords.length) {
                new3[i] = this.keywords[i] != null ? this.keywords[i].createCopy(copyComments) : null;
                ++i;
            }
        } else {
            new3 = this.keywords;
        }
        ClassDef temp = new ClassDef(this.name != null ? (NameTokType)this.name.createCopy(copyComments) : null, new0, new1, new2, new3, this.starargs != null ? (exprType)this.starargs.createCopy(copyComments) : null, this.kwargs != null ? (exprType)this.kwargs.createCopy(copyComments) : null);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsBefore().add(commentType2.createCopy(copyComments));
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsAfter().add(commentType2.createCopy(copyComments));
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("ClassDef[");
        sb.append("name=");
        sb.append(this.dumpThis(this.name));
        sb.append(", ");
        sb.append("bases=");
        sb.append(this.dumpThis(this.bases));
        sb.append(", ");
        sb.append("body=");
        sb.append(this.dumpThis(this.body));
        sb.append(", ");
        sb.append("decs=");
        sb.append(this.dumpThis(this.decs));
        sb.append(", ");
        sb.append("keywords=");
        sb.append(this.dumpThis(this.keywords));
        sb.append(", ");
        sb.append("starargs=");
        sb.append(this.dumpThis(this.starargs));
        sb.append(", ");
        sb.append("kwargs=");
        sb.append(this.dumpThis(this.kwargs));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitClassDef(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        int i;
        if (this.name != null) {
            this.name.accept(visitor);
        }
        if (this.bases != null) {
            i = 0;
            while (i < this.bases.length) {
                if (this.bases[i] != null) {
                    this.bases[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.body != null) {
            i = 0;
            while (i < this.body.length) {
                if (this.body[i] != null) {
                    this.body[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.decs != null) {
            i = 0;
            while (i < this.decs.length) {
                if (this.decs[i] != null) {
                    this.decs[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.keywords != null) {
            i = 0;
            while (i < this.keywords.length) {
                if (this.keywords[i] != null) {
                    this.keywords[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.starargs != null) {
            this.starargs.accept(visitor);
        }
        if (this.kwargs != null) {
            this.kwargs.accept(visitor);
        }
    }
}

