/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.util.Arrays;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.comp_contextType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.exprType;

public final class ListComp
extends exprType
implements comp_contextType {
    public exprType elt;
    public comprehensionType[] generators;
    public int ctx;

    public ListComp(exprType elt, comprehensionType[] generators, int ctx) {
        this.elt = elt;
        this.generators = generators;
        this.ctx = ctx;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elt == null ? 0 : this.elt.hashCode());
        result = 31 * result + Arrays.hashCode(this.generators);
        result = 31 * result + this.ctx;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListComp other = (ListComp)obj;
        if (this.elt == null ? other.elt != null : !this.elt.equals(other.elt)) {
            return false;
        }
        if (!Arrays.equals(this.generators, other.generators)) {
            return false;
        }
        return this.ctx == other.ctx;
    }

    @Override
    public ListComp createCopy() {
        return this.createCopy(true);
    }

    @Override
    public ListComp createCopy(boolean copyComments) {
        commentType commentType2;
        comprehensionType[] new0;
        if (this.generators != null) {
            new0 = new comprehensionType[this.generators.length];
            int i = 0;
            while (i < this.generators.length) {
                new0[i] = (comprehensionType)(this.generators[i] != null ? this.generators[i].createCopy(copyComments) : null);
                ++i;
            }
        } else {
            new0 = this.generators;
        }
        ListComp temp = new ListComp(this.elt != null ? (exprType)this.elt.createCopy(copyComments) : null, new0, this.ctx);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsBefore().add(commentType2.createCopy(copyComments));
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsAfter().add(commentType2.createCopy(copyComments));
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("ListComp[");
        sb.append("elt=");
        sb.append(this.dumpThis(this.elt));
        sb.append(", ");
        sb.append("generators=");
        sb.append(this.dumpThis(this.generators));
        sb.append(", ");
        sb.append("ctx=");
        sb.append(this.dumpThis(this.ctx, comp_contextType.comp_contextTypeNames));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitListComp(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        if (this.elt != null) {
            this.elt.accept(visitor);
        }
        if (this.generators != null) {
            int i = 0;
            while (i < this.generators.length) {
                if (this.generators[i] != null) {
                    this.generators[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

