/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinterv2;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IPyFormatStdProvider;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.prettyprinterv2.IFormatter;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterPrefsV2;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterV2;
import org.python.pydev.shared_core.parsing.BaseParser;

public class Formatter
implements IFormatter {
    @Override
    public void formatAll(IDocument doc, IPyFormatStdProvider edit, IFile f, boolean isOpenedFile, boolean throwSyntaxError) throws SyntaxErrorException {
        BaseParser.ParseOutput objects;
        try {
            objects = PyParser.reparseDocument(new PyParser.ParserInfo(doc, (IGrammarVersionProvider)edit.getPythonNature()));
        }
        catch (MisconfigurationException e1) {
            Log.log((Throwable)e1);
            return;
        }
        if (objects.error != null) {
            if (throwSyntaxError) {
                throw new SyntaxErrorException();
            }
        } else if (objects.ast != null) {
            try {
                SimpleNode n = (SimpleNode)objects.ast;
                PrettyPrinterV2 prettyPrinterV2 = new PrettyPrinterV2(new PrettyPrinterPrefsV2("\n", edit.getIndentPrefs().getIndentationString(), edit.getGrammarVersionProvider()));
                doc.set(prettyPrinterV2.print(n));
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    @Override
    public void formatSelection(IDocument doc, int[] regionsToFormat, IPyFormatStdProvider edit, PySelection ps) {
    }
}

