/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinterv2;

import java.io.IOException;
import java.util.List;
import java.util.Stack;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Match;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.match_caseType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.prettyprinterv2.ILinePart;
import org.python.pydev.parser.prettyprinterv2.IPrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinterv2.LinePartIndentMark;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterDocV2;
import org.python.pydev.shared_core.structure.Tuple;

public class PrettyPrinterUtilsV2
extends VisitorBase {
    protected IPrettyPrinterPrefs prefs;
    protected PrettyPrinterDocV2 doc;
    Stack<Integer> ids = new Stack();
    protected SimpleNode lastNode;

    public PrettyPrinterUtilsV2(IPrettyPrinterPrefs prefs, PrettyPrinterDocV2 doc) {
        this.prefs = prefs;
        this.doc = doc;
    }

    private void writeSpecialsBefore(SimpleNode node) throws IOException {
        if (node == null) {
            return;
        }
        List<Object> specialsBefore = node.specialsBefore;
        if (specialsBefore == null) {
            return;
        }
        this.writeSpecials(node, specialsBefore);
    }

    private void writeSpecialsAfter(SimpleNode node) throws IOException {
        if (node == null) {
            return;
        }
        List<Object> specialsAfter = node.specialsAfter;
        if (specialsAfter == null) {
            return;
        }
        this.writeSpecials(node, specialsAfter);
    }

    private void writeSpecials(SimpleNode node, List<Object> specials) {
        for (Object c : specials) {
            if (c instanceof commentType) {
                commentType comment = (commentType)c;
                this.doc.add(comment.beginLine, comment.beginColumn, comment.id, comment);
                continue;
            }
            if (c instanceof Name) {
                Name name = (Name)c;
                this.doc.add(name.beginLine, name.beginColumn, name.id, name);
                continue;
            }
            if (c instanceof ISpecialStr) {
                ISpecialStr specialStr = (ISpecialStr)c;
                this.doc.add(specialStr.getBeginLine(), specialStr.getBeginCol(), specialStr.toString(), specialStr);
                continue;
            }
            throw new RuntimeException("Unexpected special: '" + c + "' Class: " + c.getClass() + ". Node: " + node);
        }
    }

    protected void beforeNode(SimpleNode node) throws Exception {
        this.lastNode = node;
        this.beforeNodeWithoutSettintgLastNode(node);
    }

    protected void beforeNodeWithoutSettintgLastNode(SimpleNode node) throws IOException {
        if (node instanceof stmtType && !PrettyPrinterUtilsV2.isMultiLineStmt(node)) {
            this.startStatementPart();
        }
        this.writeSpecialsBefore(node);
    }

    public static boolean isMultiLineStmt(SimpleNode node) {
        return node instanceof ClassDef || node instanceof For || node instanceof FunctionDef || node instanceof If || node instanceof TryExcept || node instanceof TryFinally || node instanceof While || node instanceof With || node instanceof Match || node instanceof match_caseType;
    }

    protected void afterNode(SimpleNode node) throws IOException {
        if (node instanceof stmtType && !PrettyPrinterUtilsV2.isMultiLineStmt(node)) {
            this.endStatementPart(node);
        }
        this.writeSpecialsAfter(node);
    }

    protected void startStatementPart() {
        this.ids.push(this.doc.pushRecordChanges());
    }

    protected Tuple<ILinePart, ILinePart> endStatementPart(SimpleNode node) {
        List<ILinePart> recordChanges = this.doc.popRecordChanges(this.ids.pop());
        Tuple<ILinePart, ILinePart> lowerAndHigher = this.doc.getLowerAndHigerFound(recordChanges);
        if (lowerAndHigher != null) {
            this.doc.addStartStatementMark((ILinePart)lowerAndHigher.o1, node);
            this.doc.addEndStatementMark((ILinePart)lowerAndHigher.o2, node);
            return lowerAndHigher;
        }
        return null;
    }

    protected void indent(SimpleNode node, boolean requireNewLine) {
        this.doc.addIndent(node, requireNewLine);
    }

    protected LinePartIndentMark dedent() {
        return this.doc.addDedent();
    }

    protected void dedent(int emptyLinesRequiredAfterDedent) {
        this.doc.addDedent(emptyLinesRequiredAfterDedent);
    }

    @Override
    protected Object unhandled_node(SimpleNode node) throws Exception {
        this.lastNode = node;
        return null;
    }

    @Override
    public void traverse(SimpleNode node) throws Exception {
        this.beforeNode(node);
        node.traverse(this);
        this.afterNode(node);
    }
}

