/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.visitors;

import org.python.pydev.core.ITypeInfo;
import org.python.pydev.core.UnpackInfo;
import org.python.pydev.parser.jython.ast.ExtSlice;
import org.python.pydev.parser.jython.ast.Index;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.sliceType;
import org.python.pydev.parser.visitors.NodeUtils;

public class TypeInfo
implements ITypeInfo {
    private final String rep;
    private final exprType expr;

    public TypeInfo(String rep) {
        this.rep = rep;
        this.expr = null;
    }

    public TypeInfo(exprType expr) {
        this.expr = NodeUtils.extractOptionalValueSubscript(expr);
        String tempRep = NodeUtils.getFullRepresentationString(this.expr);
        this.rep = tempRep == null ? "" : tempRep;
    }

    public String getActTok() {
        return this.rep;
    }

    public exprType getNode() {
        return this.expr;
    }

    public TypeInfo getPackedType() {
        return new TypeInfo(NodeUtils.getPackedTypeFromDocstring(this.rep));
    }

    public ITypeInfo getUnpacked(UnpackInfo unpackInfo) {
        if (this.expr != null && this.expr instanceof Subscript) {
            Subscript subscript = (Subscript)this.expr;
            if (subscript.slice instanceof ExtSlice) {
                sliceType sliceType2;
                int i;
                ExtSlice extSlice = (ExtSlice)subscript.slice;
                if (extSlice.dims != null && (i = unpackInfo.getUnpackTuple(extSlice.dims.length)) >= 0 && i < extSlice.dims.length && (sliceType2 = extSlice.dims[i]) instanceof Index) {
                    Index index = (Index)sliceType2;
                    exprType valExpr = index.value;
                    if (valExpr != null) {
                        return new TypeInfo(valExpr);
                    }
                }
            } else if (subscript.slice instanceof Index) {
                Index index = (Index)subscript.slice;
                exprType valExpr = index.value;
                if (valExpr != null) {
                    return new TypeInfo(valExpr);
                }
            }
        }
        return new TypeInfo(NodeUtils.getUnpackedTypeFromTypeDocstring(this.rep, unpackInfo));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeInfo other = (TypeInfo)obj;
        return !(this.rep == null ? other.rep != null : !this.rep.equals(other.rep));
    }
}

