/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.visitors.comparator;

import java.util.Iterator;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.comparator.DifferException;
import org.python.pydev.parser.visitors.comparator.FlatVisitor;
import org.python.pydev.shared_core.string.StringUtils;

public class SimpleNodeComparator {
    LineColComparator lineColComparator;

    public SimpleNodeComparator() {
        this(false);
    }

    public SimpleNodeComparator(boolean compareLineCol) {
        this(compareLineCol ? new RegularLineComparator() : null);
    }

    public SimpleNodeComparator(LineColComparator lineColComparator) {
        this.lineColComparator = lineColComparator;
    }

    public void compare(SimpleNode original, SimpleNode newNode) throws Exception, DifferException {
        FlatVisitor flatVisitorOriginal = new FlatVisitor();
        flatVisitorOriginal.traverse(original);
        FlatVisitor flatVisitor = new FlatVisitor();
        flatVisitor.traverse(newNode);
        Iterator<SimpleNode> it = flatVisitorOriginal.visited.iterator();
        Iterator<SimpleNode> it2 = flatVisitor.visited.iterator();
        while (it.hasNext() || it2.hasNext()) {
            SimpleNode node2;
            SimpleNode node = it.hasNext() ? it.next() : null;
            SimpleNode simpleNode = node2 = it2.hasNext() ? it2.next() : null;
            if (node == null || node2 == null) {
                throw new DifferException("Nodes differ. " + node + " != " + node2);
            }
            if (node.getClass() != node2.getClass()) {
                throw new DifferException("Nodes differ. " + node.getClass().getName() + " != " + node2.getClass().getName());
            }
            if (this.lineColComparator != null) {
                this.lineColComparator.compareLineCol(node, node2);
            }
            String s1 = NodeUtils.getFullRepresentationString(node);
            String s2 = NodeUtils.getFullRepresentationString(node2);
            if (s1 == null && s2 != null || s1 != null && s2 == null) {
                throw new DifferException("Nodes differ. (s1 == null && s2 != null) || (s1 != null && s2 == null)");
            }
            if (s1 == s2 || s1.equals(s2.replaceAll("\r", ""))) continue;
            throw new DifferException("Nodes differ. s1 != s2 \n-->" + s1 + "<--\n!=\n-->" + s2 + "<--");
        }
    }

    public static abstract class LineColComparator {
        public abstract void compareLineCol(SimpleNode var1, SimpleNode var2) throws DifferException;
    }

    public static class RegularLineComparator
    extends LineColComparator {
        @Override
        public void compareLineCol(SimpleNode node, SimpleNode node2) throws DifferException {
            if (node.beginLine != node2.beginLine) {
                throw new DifferException(StringUtils.format((String)"Nodes beginLine differ. (%s != %s) (%s -- %s)", (Object[])new Object[]{node.beginLine, node2.beginLine, node, node2}));
            }
        }
    }
}

