/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.visitors;

import java.io.File;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.ast.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISourceModule;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.TokenMgrError;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.refactoring.ast.PythonModuleManager;
import org.python.pydev.refactoring.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.visitors.CannotCreateContextRuntimeException;
import org.python.pydev.refactoring.ast.visitors.FindDuplicatesVisitor;
import org.python.pydev.refactoring.ast.visitors.context.AbstractContextVisitor;
import org.python.pydev.refactoring.ast.visitors.selection.SelectionException;
import org.python.pydev.refactoring.ast.visitors.selection.SelectionExtenderVisitor;
import org.python.pydev.refactoring.ast.visitors.selection.SelectionValidationVisitor;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.parsing.BaseParser;
import org.python.pydev.shared_core.string.ICoreTextSelection;

public final class VisitorFactory {
    private VisitorFactory() {
    }

    public static ICoreTextSelection createSelectionExtension(AbstractScopeNode<?> scope, ICoreTextSelection selection) {
        SelectionExtenderVisitor visitor = null;
        try {
            visitor = new SelectionExtenderVisitor(scope.getModule(), selection);
            scope.getASTNode().accept((VisitorIF)visitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return visitor.getSelection();
    }

    public static void validateSelection(ModuleAdapter scope) throws SelectionException {
        SelectionValidationVisitor visitor = null;
        try {
            visitor = new SelectionValidationVisitor();
            ((Module)scope.getASTNode()).accept((VisitorIF)visitor);
        }
        catch (SelectionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends VisitorIF> T createVisitor(Class<T> visitorClass, String source, IGrammarVersionProvider versionProvider) throws Throwable {
        return VisitorFactory.createVisitor(visitorClass, VisitorFactory.getRootNodeFromString(source, versionProvider));
    }

    public static <T extends VisitorIF> T createVisitor(Class<T> visitorClass, SimpleNode root) {
        VisitorIF visitor = null;
        try {
            visitor = (VisitorIF)visitorClass.newInstance();
            root.accept(visitor);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return (T)visitor;
    }

    public static <T extends AbstractContextVisitor> T createContextVisitor(Class<T> visitorClass, SimpleNode root, ModuleAdapter module, AbstractNodeAdapter parent) {
        try {
            AbstractContextVisitor visitor = (AbstractContextVisitor)((Object)visitorClass.getConstructors()[0].newInstance(module, parent));
            root.accept((VisitorIF)visitor);
            return (T)((Object)visitor);
        }
        catch (Exception e) {
            throw new CannotCreateContextRuntimeException(e);
        }
    }

    public static ModuleAdapter createModuleAdapter(PythonModuleManager pythonModuleManager, File file, IDocument doc, IPythonNature nature, IGrammarVersionProvider versionProvider) throws Throwable {
        if (file != null && file.exists()) {
            IModule module;
            String modName;
            IModulesManager modulesManager;
            if (FileTypesPreferences.isCythonFile((String)file.getName())) {
                versionProvider = new IGrammarVersionProvider(){

                    public int getGrammarVersion() throws MisconfigurationException {
                        return 777;
                    }

                    public IGrammarVersionProvider.AdditionalGrammarVersionsToCheck getAdditionalGrammarVersions() throws MisconfigurationException {
                        return null;
                    }
                };
            }
            if (pythonModuleManager != null && (modulesManager = pythonModuleManager.getIModuleManager()) != null && (modName = modulesManager.resolveModule(FileUtils.getFileAbsolutePath((File)file))) != null && (module = modulesManager.getModule(modName, nature, true, (IModuleRequestState)new BaseModuleRequest(false))) instanceof ISourceModule) {
                SourceModule iSourceModule = (SourceModule)module;
                if (iSourceModule.parseError != null) {
                    throw iSourceModule.parseError;
                }
                return new ModuleAdapter(pythonModuleManager, (ISourceModule)module, nature, doc);
            }
        }
        return new ModuleAdapter(pythonModuleManager, file, doc, VisitorFactory.getRootNode(doc, versionProvider), nature);
    }

    public static SimpleNode getRootNodeFromString(String source, IGrammarVersionProvider versionProvider) throws ParseException, MisconfigurationException {
        return VisitorFactory.getRootNode(VisitorFactory.getDocumentFromString(source), versionProvider);
    }

    private static IDocument getDocumentFromString(String source) {
        return new Document(source);
    }

    public static Module getRootNode(IDocument doc, IGrammarVersionProvider versionProvider) throws ParseException, MisconfigurationException {
        BaseParser.ParseOutput objects = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, versionProvider));
        Throwable exception = objects.error;
        if (exception != null) {
            if (exception instanceof ParseException) {
                throw (ParseException)exception;
            }
            if (exception instanceof TokenMgrError) {
                throw new ParseException(exception.toString());
            }
            throw new RuntimeException(exception);
        }
        if (objects.error != null) {
            throw new RuntimeException(objects.error);
        }
        return (Module)objects.ast;
    }

    public static FindDuplicatesVisitor createDuplicatesVisitor(ICoreTextSelection selection, SimpleNode nodeToVisit, exprType expression, AbstractScopeNode node, IDocument doc) {
        FindDuplicatesVisitor visitor = new FindDuplicatesVisitor(selection, expression, doc);
        try {
            nodeToVisit.accept((VisitorIF)visitor);
            visitor.finish();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return visitor;
    }
}

