/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.constructorfield.edit;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.refactoring.ast.adapters.FunctionDefAdapter;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.INodeAdapter;
import org.python.pydev.refactoring.codegenerator.constructorfield.request.ConstructorFieldRequest;
import org.python.pydev.refactoring.core.edit.AbstractInsertEdit;

public class ConstructorMethodEdit
extends AbstractInsertEdit {
    private static final String KWARGS = "kwargs";
    private static final String ARGS = "args";
    private int offsetStrategy;
    private List<INodeAdapter> attributes;
    private IClassDefAdapter classAdapter;

    public ConstructorMethodEdit(ConstructorFieldRequest req) {
        super(req);
        this.classAdapter = req.classAdapter;
        this.attributes = req.attributeAdapters;
        this.offsetStrategy = req.offsetStrategy;
    }

    @Override
    protected SimpleNode getEditNode() throws MisconfigurationException {
        List<IClassDefAdapter> bases = this.classAdapter.getBaseClasses();
        NameTok varArg = null;
        NameTok kwArg = null;
        LinkedHashSet<String> argsNames = new LinkedHashSet<String>();
        for (IClassDefAdapter baseClass : bases) {
            FunctionDefAdapter init = baseClass.getFirstInit();
            if (init == null) continue;
            if (!init.getArguments().hasOnlySelf()) {
                argsNames.addAll(init.getArguments().getSelfFilteredArgNames());
            }
            if (varArg == null && init.getArguments().hasVarArg()) {
                varArg = new NameTok(ARGS, 5);
            }
            if (kwArg != null || !init.getArguments().hasKwArg()) continue;
            kwArg = new NameTok(KWARGS, 6);
        }
        for (INodeAdapter adapter1 : this.attributes) {
            argsNames.add(this.nodeHelper.getPublicAttr(adapter1.getName()));
        }
        ArrayList<Name> argsExprList = new ArrayList<Name>();
        Name selfArg = new Name("self", 6, false);
        argsExprList.add(selfArg);
        for (String parameter : argsNames) {
            argsExprList.add(new Name(parameter.trim(), 6, false));
        }
        exprType[] argsExpr = argsExprList.toArray(new exprType[0]);
        argumentsType args = new argumentsType(argsExpr, (NameTokType)varArg, (NameTokType)kwArg, null, null, null, null, null, null, null);
        ArrayList<Object> body = new ArrayList<Object>();
        for (IClassDefAdapter base : bases) {
            Expr init = this.extractConstructorInit(base);
            if (init == null) continue;
            body.add(init);
        }
        for (INodeAdapter adapter : this.attributes) {
            Assign initParam1;
            Attribute target = new Attribute((exprType)new Name("self", 1, false), (NameTokType)new NameTok(adapter.getName(), 8), 2);
            Assign initParam = initParam1 = new Assign(new exprType[]{target}, (exprType)new Name(this.nodeHelper.getPublicAttr(adapter.getName()), 1, false), null);
            body.add(initParam);
        }
        return new FunctionDef((NameTokType)new NameTok("__init__", 2), args, body.toArray(new stmtType[0]), null, null, false);
    }

    private Expr extractConstructorInit(IClassDefAdapter base) {
        FunctionDefAdapter init = base.getFirstInit();
        if (init != null && !init.getArguments().hasOnlySelf()) {
            Attribute classInit = new Attribute((exprType)new Name(this.moduleAdapter.getBaseContextName(this.classAdapter, base.getName()), 1, false), (NameTokType)new NameTok("__init__", 8), 1);
            List<exprType> constructorParameters = init.getArguments().getSelfFilteredArgs();
            Name selfArg = new Name("self", 1, false);
            constructorParameters.add(0, (exprType)selfArg);
            exprType[] argExp = constructorParameters.toArray(new exprType[0]);
            Name varArg = null;
            Name kwArg = null;
            if (init.getArguments().hasVarArg()) {
                varArg = new Name(ARGS, 1, false);
            }
            if (init.getArguments().hasKwArg()) {
                kwArg = new Name(KWARGS, 1, false);
            }
            Call initCall = new Call((exprType)classInit, argExp, null, (exprType)varArg, (exprType)kwArg);
            return new Expr((exprType)initCall);
        }
        return null;
    }

    @Override
    public int getOffsetStrategy() {
        return this.offsetStrategy;
    }
}

