/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.generateproperties.edit;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.refactoring.codegenerator.generateproperties.request.GeneratePropertiesRequest;
import org.python.pydev.refactoring.codegenerator.generateproperties.request.SelectionState;
import org.python.pydev.refactoring.core.edit.AbstractInsertEdit;

public class PropertyEdit
extends AbstractInsertEdit {
    private static final Name NONE = new Name("None", 1, true);
    private static final Name PROPERTY = new Name("property", 1, false);
    private GeneratePropertiesRequest request;
    private String attributeName;
    private String propertyName;
    private SelectionState state;
    private int offsetStrategy;

    public PropertyEdit(GeneratePropertiesRequest req) {
        super(req);
        this.request = req;
        this.attributeName = req.getAttributeName();
        this.propertyName = req.getPropertyName();
        this.state = req.getSelectionState();
        this.offsetStrategy = req.offsetPropertyStrategy;
    }

    @Override
    protected SimpleNode getEditNode() {
        exprType[] target = new exprType[]{new Name(this.propertyName, 2, false)};
        Call property = this.createPropertyCall();
        return new Assign(target, (exprType)property, null);
    }

    private Call createPropertyCall() {
        exprType[] args = this.createPropertyArguments();
        Call property = new Call((exprType)PROPERTY, args, null, null, null);
        return property;
    }

    private exprType[] createPropertyArguments() {
        ArrayList<exprType> args = new ArrayList<exprType>();
        this.addArgument(args, this.state.isGetter(), "get");
        this.addArgument(args, this.state.isSetter(), "set");
        this.addArgument(args, this.state.isDelete(), "del");
        if (this.state.isDocstring()) {
            args.add((exprType)new Str(String.valueOf(this.propertyName) + "'s docstring", 4, false, false, false, false, null));
        } else {
            args.add((exprType)NONE);
        }
        return args.toArray(new exprType[args.size()]);
    }

    private void addArgument(List<exprType> args, boolean isAvailable, String accessType) {
        if (isAvailable) {
            args.add((exprType)new Name(GeneratePropertiesRequest.getAccessorName(accessType, this.attributeName), 1, false));
        } else {
            args.add((exprType)NONE);
        }
    }

    @Override
    public int getOffsetStrategy() {
        return this.offsetStrategy;
    }
}

