/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug.remote;

import com.python.pydev.debug.DebugPluginPrefsInitializer;
import com.python.pydev.debug.model.ProcessServer;
import com.python.pydev.debug.model.PyDebugTargetServer;
import com.python.pydev.debug.remote.IRemoteDebuggerListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PySourceLocator;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.shared_core.callbacks.ListenerList;

public class RemoteDebuggerServer
extends AbstractRemoteDebugger
implements Runnable {
    private static final int TIMEOUT = 0;
    private static volatile ServerSocket serverSocket;
    private volatile ILaunch launch;
    private volatile boolean terminated = true;
    private volatile ProcessServer serverProcess;
    private volatile IProcess iProcess;
    private volatile boolean inDispose = false;
    private volatile boolean inStopListening = false;
    private static volatile RemoteDebuggerServer remoteServer;
    private static volatile Thread remoteServerThread;
    private static final Object lock;
    private ListenerList<IRemoteDebuggerListener> listeners = new ListenerList(IRemoteDebuggerListener.class);

    static {
        lock = new Object();
    }

    public void addListener(IRemoteDebuggerListener listener) {
        this.listeners.add((Object)listener);
    }

    private RemoteDebuggerServer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteDebuggerServer getInstance() {
        Object object = lock;
        synchronized (object) {
            if (remoteServer == null) {
                remoteServer = new RemoteDebuggerServer();
            }
            return remoteServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        Object object = lock;
        synchronized (object) {
            boolean notify = false;
            this.stopListening(notify);
            if (serverSocket == null) {
                try {
                    int port = DebugPluginPrefsInitializer.getRemoteDebuggerPort();
                    serverSocket = new ServerSocket();
                    serverSocket.setReuseAddress(true);
                    serverSocket.setSoTimeout(0);
                    serverSocket.bind(new InetSocketAddress(port));
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
            }
            if (remoteServerThread == null) {
                remoteServerThread = new Thread(remoteServer);
                remoteServerThread.start();
            }
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.startDebugging(serverSocket.accept());
            }
        }
        catch (SocketException socketException) {
            remoteServerThread = null;
        }
        catch (Exception e) {
            try {
                Log.log((Throwable)e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                remoteServerThread = null;
            }
        }
    }

    private void startDebugging(Socket socket) throws InterruptedException {
        try {
            Thread.sleep(1000L);
            if (this.launch != null) {
                this.launch.setSourceLocator((ISourceLocator)new PySourceLocator());
            }
            PyDebugTargetServer target = new PyDebugTargetServer(this.launch, null, this);
            target.startTransmission(socket);
            target.initialize();
            this.addTarget(target);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
        }
    }

    public void stopListening() {
        this.stopListening(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopListening(boolean notify) {
        IRemoteDebuggerListener[] listeners2;
        Object object = lock;
        synchronized (object) {
            if (this.terminated || this.inStopListening) {
                return;
            }
            this.inStopListening = true;
            try {
                block15: {
                    this.terminated = true;
                    try {
                        if (this.launch != null && this.launch.canTerminate()) {
                            try {
                                this.launch.terminate();
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                        }
                        remoteServer.dispose();
                        if (serverSocket == null) break block15;
                        try {
                            serverSocket.close();
                        }
                        catch (Throwable e) {
                            Log.log((Throwable)e);
                        }
                        serverSocket = null;
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
                this.launch = null;
            }
            finally {
                this.inStopListening = false;
            }
        }
        IRemoteDebuggerListener[] iRemoteDebuggerListenerArray = listeners2 = (IRemoteDebuggerListener[])this.listeners.getListeners();
        int n = listeners2.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteDebuggerListener iRemoteDebuggerListener = iRemoteDebuggerListenerArray[n2];
            iRemoteDebuggerListener.stopped(this);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = lock;
        synchronized (object) {
            if (this.inDispose) {
                return;
            }
            this.inDispose = true;
            try {
                this.stopListening();
                if (this.launch != null) {
                    for (AbstractDebugTarget target : this.targets) {
                        this.launch.removeDebugTarget((IDebugTarget)target);
                        target.terminate();
                    }
                }
                this.targets.clear();
            }
            finally {
                this.inDispose = false;
            }
        }
    }

    public void disconnect() throws DebugException {
        this.stopListening();
    }

    public void setLaunch(ILaunch launch, ProcessServer p, IProcess pro) {
        if (this.launch != null) {
            this.stopListening();
        }
        this.terminated = false;
        this.serverProcess = p;
        this.launch = launch;
        this.iProcess = pro;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public IProcess getIProcess() {
        return this.iProcess;
    }

    public ProcessServer getServerProcess() {
        return this.serverProcess;
    }
}

