/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console.console.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.python.pydev.shared_interactive_console.console.ui.ScriptStyleRange;

public class ScriptConsolePartitioner
implements IConsoleDocumentPartitioner {
    private static final String[] LEGAL_CONTENT_TYPES = new String[]{"__dftl_partition_content_type"};
    private List<ScriptStyleRange> ranges = new ArrayList<ScriptStyleRange>();

    public void addRange(ScriptStyleRange r) {
        if (r.length > 0) {
            int i = this.ranges.size() - 1;
            while (i >= 0) {
                ScriptStyleRange last = this.ranges.get(i);
                int end = last.start + last.length;
                if (end <= r.start) break;
                if (r.start <= last.start) {
                    this.ranges.remove(i);
                } else {
                    last.length = r.start - last.start;
                }
                --i;
            }
            boolean updatedRange = false;
            if (this.ranges.size() > 0) {
                ScriptStyleRange lastRange = this.ranges.get(this.ranges.size() - 1);
                if (lastRange.scriptType == r.scriptType && this.equalsColor(lastRange.foreground, r.foreground) && this.equalsColor(lastRange.background, r.background) && lastRange.start + lastRange.length == r.start) {
                    lastRange.length += r.length;
                    updatedRange = true;
                }
            }
            if (!updatedRange) {
                this.ranges.add(r);
            }
        }
    }

    private boolean equalsColor(Color foreground, Color foreground2) {
        if (foreground == foreground2) {
            return true;
        }
        if (foreground == null || foreground2 == null) {
            return false;
        }
        return foreground.equals((Object)foreground2);
    }

    public ScriptStyleRange[] getStyleRanges(int offset, int length) {
        int lastOffset = -1;
        boolean found = false;
        ArrayList<ScriptStyleRange> result = new ArrayList<ScriptStyleRange>();
        int i = this.ranges.size() - 1;
        while (i >= 0) {
            ScriptStyleRange r = this.ranges.get(i);
            if (r.start >= offset && r.start <= offset + length || r.start < offset && r.start + r.length > offset) {
                found = true;
                result.add(0, (ScriptStyleRange)((Object)r.clone()));
                if (lastOffset == -1) {
                    lastOffset = r.start + r.length;
                }
            } else if (found) break;
            --i;
        }
        if (lastOffset == -1) {
            lastOffset = offset;
        }
        if (lastOffset < offset + length) {
            ScriptStyleRange lastPart = new ScriptStyleRange(lastOffset, offset + length - lastOffset, Display.getDefault().getSystemColor(15), Display.getDefault().getSystemColor(1), -1);
            result.add(lastPart);
        }
        return result.toArray(new ScriptStyleRange[result.size()]);
    }

    public boolean isReadOnly(int offset) {
        return false;
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        return new TypedRegion[]{new TypedRegion(offset, length, "__dftl_partition_content_type")};
    }

    public void connect(IDocument document) {
    }

    public void disconnect() {
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return false;
    }

    public String getContentType(int offset) {
        return "__dftl_partition_content_type";
    }

    public String[] getLegalContentTypes() {
        return LEGAL_CONTENT_TYPES;
    }

    public ITypedRegion getPartition(int offset) {
        return new TypedRegion(offset, 1, "__dftl_partition_content_type");
    }
}

