/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console.console.ui.internal;

import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsolePartitioner;
import org.python.pydev.shared_interactive_console.console.ui.ScriptStyleRange;

public class ClipboardHandler {
    public void putIntoClipboard(IDocument doc, Point selectedRange, int clipboardType, Display display) {
        String plainText = this.getPlainText(doc, selectedRange);
        if (plainText.length() == 0) {
            return;
        }
        this.putIntoClipboard(clipboardType, display, plainText);
    }

    public void putIntoClipboard(int clipboardType, Display display, String plainText) throws SWTError {
        Clipboard clipboard = new Clipboard(display);
        try {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            Object[] data = new String[]{plainText};
            Transfer[] types = new Transfer[]{plainTextTransfer};
            try {
                clipboard.setContents(data, types, clipboardType);
            }
            catch (SWTError error) {
                if (error.code != 2002) {
                    throw error;
                }
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    public String getPlainText(IDocument doc, Point selectedRange) {
        StringBuffer plainText = new StringBuffer();
        ScriptConsolePartitioner scriptConsolePartitioner = (ScriptConsolePartitioner)doc.getDocumentPartitioner();
        ScriptStyleRange[] ranges = scriptConsolePartitioner.getStyleRanges(selectedRange.x, selectedRange.y);
        if (ranges.length == 0) {
            return "";
        }
        try {
            int currentRange = 0;
            int minOffset = selectedRange.x;
            int maxOffset = selectedRange.x + selectedRange.y;
            int i = minOffset;
            while (i < maxOffset) {
                char c = doc.getChar(i);
                if (c == '\r' || c == '\n') {
                    plainText.append(c);
                } else {
                    ScriptStyleRange current = null;
                    while (currentRange < ranges.length) {
                        current = ranges[currentRange];
                        if (current.start <= i && i < current.start + current.length) break;
                        ++currentRange;
                    }
                    if (current != null && current.scriptType != 1) {
                        plainText.append(c);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return plainText.toString();
    }

    public static String getClipboardContents() {
        Clipboard cb = null;
        try {
            cb = new Clipboard(Display.getDefault());
            String string = cb.getContents((Transfer)TextTransfer.getInstance()).toString();
            return string;
        }
        finally {
            if (cb != null) {
                cb.dispose();
            }
        }
    }
}

