/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console.console.ui.internal;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.python.pydev.core.autoedit.IHandleScriptAutoEditStrategy;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.DocCmd;
import org.python.pydev.shared_core.utils.IDocumentCommand;
import org.python.pydev.shared_interactive_console.console.InterpreterResponse;
import org.python.pydev.shared_interactive_console.console.ScriptConsoleHistory;
import org.python.pydev.shared_interactive_console.console.ScriptConsolePrompt;
import org.python.pydev.shared_interactive_console.console.ui.IConsoleStyleProvider;
import org.python.pydev.shared_interactive_console.console.ui.IScriptConsoleSession;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsolePartitioner;
import org.python.pydev.shared_interactive_console.console.ui.ScriptStyleRange;
import org.python.pydev.shared_interactive_console.console.ui.internal.ICommandHandler;
import org.python.pydev.shared_interactive_console.console.ui.internal.IScriptConsoleViewer2ForDocumentListener;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class ScriptConsoleDocumentListener
implements IDocumentListener {
    private ICommandHandler handler;
    private ScriptConsolePrompt prompt;
    private ScriptConsoleHistory history;
    private int readOnlyColumnsInCurrentBeforePrompt;
    private int historyFullLine;
    private IDocument doc;
    private int disconnectionLevel = 0;
    private long lastChangeMillis;
    private String initialCommands;
    private volatile boolean promptReady;
    private IScriptConsoleViewer2ForDocumentListener viewer;
    private List<WeakReference<IScriptConsoleViewer2ForDocumentListener>> otherViewers = new ArrayList<WeakReference<IScriptConsoleViewer2ForDocumentListener>>();
    private IHandleScriptAutoEditStrategy strategy;
    private List<IConsoleLineTracker> consoleLineTrackers;
    private boolean scrollLock = false;

    public long getLastChangeMillis() {
        return this.lastChangeMillis;
    }

    public IHandleScriptAutoEditStrategy getIndentStrategy() {
        return this.strategy;
    }

    protected synchronized void reconnect(IDocument oldDoc, IDocument newDoc) {
        Assert.isTrue((this.disconnectionLevel == 0 ? 1 : 0) != 0);
        if (oldDoc != null) {
            oldDoc.removeDocumentListener((IDocumentListener)this);
        }
        newDoc.addDocumentListener((IDocumentListener)this);
        this.doc = newDoc;
    }

    protected synchronized void startDisconnected() {
        if (this.disconnectionLevel == 0) {
            this.doc.removeDocumentListener((IDocumentListener)this);
        }
        ++this.disconnectionLevel;
    }

    protected synchronized void stopDisconnected() {
        --this.disconnectionLevel;
        if (this.disconnectionLevel == 0) {
            this.doc.addDocumentListener((IDocumentListener)this);
        }
    }

    public void clear(boolean addInitialCommands) {
        this.startDisconnected();
        try {
            this.doc.set("");
            this.appendInvitation(true);
        }
        finally {
            this.stopDisconnected();
        }
        if (addInitialCommands) {
            try {
                this.doc.replace(this.doc.getLength(), 0, String.valueOf(this.initialCommands) + "\n");
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public void addViewer(IScriptConsoleViewer2ForDocumentListener scriptConsoleViewer) {
        this.otherViewers.add(new WeakReference<IScriptConsoleViewer2ForDocumentListener>(scriptConsoleViewer));
    }

    public ScriptConsoleDocumentListener(IScriptConsoleViewer2ForDocumentListener viewer, ICommandHandler handler, ScriptConsolePrompt prompt, ScriptConsoleHistory history, List<IConsoleLineTracker> consoleLineTrackers, String initialCommands, IHandleScriptAutoEditStrategy strategy) {
        this.lastChangeMillis = System.currentTimeMillis();
        this.strategy = strategy;
        this.prompt = prompt;
        this.handler = handler;
        this.history = history;
        this.viewer = viewer;
        this.readOnlyColumnsInCurrentBeforePrompt = 0;
        this.historyFullLine = 0;
        this.doc = null;
        this.consoleLineTrackers = consoleLineTrackers;
        this.initialCommands = initialCommands;
        ICallback<Object, Tuple<String, String>> onContentsReceived = new ICallback<Object, Tuple<String, String>>(){

            public Object call(final Tuple<String, String> result) {
                if (((String)result.o1).length() > 0 || ((String)result.o2).length() > 0) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            PromptContext pc;
                            ScriptConsoleDocumentListener.this.startDisconnected();
                            try {
                                pc = ScriptConsoleDocumentListener.this.removeUserInput();
                                IScriptConsoleSession consoleSession = (this).ScriptConsoleDocumentListener.this.viewer.getConsoleSession();
                                if (((String)result.o1).length() > 0) {
                                    if (consoleSession != null) {
                                        consoleSession.onStdoutContentsReceived((String)result.o1);
                                    }
                                    ScriptConsoleDocumentListener.this.addToConsoleView((String)result.o1, true, true);
                                }
                                if (((String)result.o2).length() > 0) {
                                    if (consoleSession != null) {
                                        consoleSession.onStderrContentsReceived((String)result.o2);
                                    }
                                    ScriptConsoleDocumentListener.this.addToConsoleView((String)result.o2, false, true);
                                }
                                if (pc.removedPrompt) {
                                    ScriptConsoleDocumentListener.this.appendInvitation(false);
                                }
                            }
                            finally {
                                ScriptConsoleDocumentListener.this.stopDisconnected();
                            }
                            if (pc.removedPrompt) {
                                ScriptConsoleDocumentListener.this.appendText(pc.userInput);
                                (this).ScriptConsoleDocumentListener.this.viewer.setCaretOffset((this).ScriptConsoleDocumentListener.this.doc.getLength() - pc.cursorOffset, false);
                            }
                        }
                    };
                    RunInUiThread.async((Runnable)runnable);
                }
                return null;
            }
        };
        handler.setOnContentsReceivedCallback(onContentsReceived);
    }

    protected PromptContext removeUserInput() {
        if (!this.promptReady) {
            return new PromptContext(false, -1, "");
        }
        PromptContext pc = new PromptContext(true, -1, "");
        try {
            int lastLine = this.doc.getNumberOfLines() - 1;
            int lastLineLength = this.doc.getLineLength(lastLine);
            int end = this.doc.getLength();
            int start = end - lastLineLength;
            int promptOffset = this.doc.get(start, lastLineLength).indexOf(this.prompt.toString());
            pc.userInput = this.doc.get(start += promptOffset, lastLineLength -= promptOffset);
            pc.cursorOffset = end - this.viewer.getCaretOffset();
            this.doc.replace(start, lastLineLength, "");
            pc.userInput = pc.userInput.replace(this.prompt.toString(), "");
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return pc;
    }

    public void setDocument(IDocument doc) {
        this.reconnect(this.doc, doc);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    protected void processResult(InterpreterResponse result) {
        if (result != null) {
            this.history.commit();
            try {
                this.readOnlyColumnsInCurrentBeforePrompt = this.getLastLineLength();
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
            if (!result.more) {
                this.historyFullLine = this.history.getAsList().size();
            }
        }
        this.appendInvitation(false);
    }

    private void addToConsoleView(String out, boolean stdout, boolean textAddedIsReadOnly) {
        if (out.length() == 0) {
            return;
        }
        int start = this.doc.getLength();
        IConsoleStyleProvider styleProvider = this.viewer.getStyleProvider();
        Tuple<List<ScriptStyleRange>, String> style = null;
        if (styleProvider != null && (style = stdout ? styleProvider.createInterpreterOutputStyle(out, start) : styleProvider.createInterpreterErrorStyle(out, start)) != null) {
            for (ScriptStyleRange s : (List)style.o1) {
                this.addToPartitioner(s);
            }
        }
        if (style != null) {
            this.appendText((String)style.o2);
            if (textAddedIsReadOnly) {
                try {
                    int len;
                    int lastLine = this.doc.getNumberOfLines() - 1;
                    this.readOnlyColumnsInCurrentBeforePrompt = len = this.doc.getLineLength(lastLine);
                }
                catch (BadLocationException e) {
                    Log.log((Throwable)e);
                }
            }
        }
        TextSelectionUtils ps = new TextSelectionUtils(this.doc, start);
        int cursorLine = ps.getCursorLine();
        int numberOfLines = this.doc.getNumberOfLines();
        int i = cursorLine;
        while (i < numberOfLines) {
            try {
                int offset = ps.getLineOffset(i);
                int endOffset = ps.getEndLineOffset(i);
                Region region = new Region(offset, endOffset - offset);
                for (IConsoleLineTracker lineTracker : this.consoleLineTrackers) {
                    lineTracker.lineAppended((IRegion)region);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            ++i;
        }
        if (!this.scrollLock) {
            this.revealEndOfDocument();
        }
    }

    private void addToPartitioner(ScriptStyleRange style) {
        IDocumentPartitioner partitioner = this.doc.getDocumentPartitioner();
        if (partitioner instanceof ScriptConsolePartitioner) {
            ScriptConsolePartitioner scriptConsolePartitioner = (ScriptConsolePartitioner)partitioner;
            scriptConsolePartitioner.addRange(style);
        }
    }

    protected void proccessAddition(int offset, String text) {
        String indentString = "";
        boolean addedNewLine = false;
        char addedParen = '\u0000';
        char addedCloseParen = '\u0000';
        int addedLen = text.length();
        if (addedLen == 1) {
            if (text.equals("\r") || text.equals("\n")) {
                addedNewLine = true;
            } else if (text.equals("(")) {
                addedParen = '(';
            } else if (text.equals(")")) {
                addedCloseParen = ')';
            } else if (text.equals("[")) {
                addedParen = '[';
            } else if (text.equals("]")) {
                addedCloseParen = ']';
            } else if (text.equals("{")) {
                addedParen = '{';
            } else if (text.equals("}")) {
                addedCloseParen = '}';
            }
        } else if (addedLen == 2 && text.equals("\r\n")) {
            addedNewLine = true;
        }
        String delim = this.getDelimeter();
        int newDeltaCaretPosition = this.doc.getLength() - (offset + text.length());
        try {
            boolean offset_in_command_line;
            this.doc.replace(offset, text.length(), "");
            boolean bl = offset_in_command_line = offset >= this.getCommandLineOffset();
            if (!offset_in_command_line) {
                offset = newDeltaCaretPosition = this.getCommandLineOffset();
                text = String.valueOf(this.doc.get(this.getCommandLineOffset(), this.getCommandLineLength())) + text;
                this.doc.replace(this.getCommandLineOffset(), this.getCommandLineLength(), "");
            } else {
                text = String.valueOf(text) + this.doc.get(offset, this.doc.getLength() - offset);
                this.doc.replace(offset, this.doc.getLength() - offset, "");
            }
        }
        catch (BadLocationException e) {
            text = "";
            Log.log((Throwable)e);
        }
        text = StringUtils.replaceNewLines((String)text, (String)delim);
        int start = 0;
        int index = -1;
        ArrayList<String> commands = new ArrayList<String>();
        while ((index = text.indexOf(delim, start)) != -1) {
            String cmd = text.substring(start, index);
            cmd = this.convertTabs(cmd);
            commands.add(cmd);
            start = index + delim.length();
        }
        String[] finalIndentString = new String[]{indentString};
        if (commands.size() > 0) {
            this.startDisconnected();
            String cmd = (String)commands.get(0);
            this.execCommand(addedNewLine, delim, finalIndentString, cmd, commands, 0, text, addedParen, start, addedCloseParen, newDeltaCaretPosition);
        } else {
            this.onAfterAllLinesHandled(text, addedParen, start, offset, addedCloseParen, finalIndentString[0], newDeltaCaretPosition);
        }
    }

    private void execCommand(boolean addedNewLine, String delim, final String[] finalIndentString, String cmd, final List<String> commands, final int currentCommand, final String text, final char addedParen, final int start, final char addedCloseParen, final int newDeltaCaretPosition) {
        this.applyStyleToUserAddedText(cmd, this.doc.getLength());
        this.appendText(cmd);
        final String commandLine = this.getCommandLine();
        if (this.handler.isOnStateWhereCommandHandlingShouldStop(commandLine)) {
            return;
        }
        this.history.update(commandLine);
        this.appendText(this.getDelimeter());
        final boolean finalAddedNewLine = addedNewLine;
        final String finalDelim = delim;
        ICallback<Object, InterpreterResponse> onResponseReceived = new ICallback<Object, InterpreterResponse>(){

            public Object call(final InterpreterResponse arg) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            List<String> historyList;
                            Document historyDoc;
                            int currHistoryLen;
                            ScriptConsoleDocumentListener.this.processResult(arg);
                            if (finalAddedNewLine && (currHistoryLen = (historyDoc = new Document(String.valueOf(StringUtils.join((String)"\n", (historyList = (this).ScriptConsoleDocumentListener.this.history.getAsList()).subList((this).ScriptConsoleDocumentListener.this.historyFullLine, historyList.size()))) + "\n")).getLength()) > 0) {
                                DocCmd docCmd = new DocCmd(currHistoryLen - 1, 0, finalDelim);
                                (this).ScriptConsoleDocumentListener.this.strategy.customizeNewLine((IDocument)historyDoc, (IDocumentCommand)docCmd);
                                finalIndentString[0] = docCmd.text.replaceAll("\\r\\n|\\n|\\r", "");
                                if (currHistoryLen != historyDoc.getLength()) {
                                    Log.log((String)"Error: the document passed to the customizeNewLine should not be changed!");
                                }
                            }
                        }
                        catch (Throwable e) {
                            Log.log((Throwable)e);
                        }
                        if (currentCommand + 1 < commands.size()) {
                            ScriptConsoleDocumentListener.this.execCommand(finalAddedNewLine, finalDelim, finalIndentString, (String)commands.get(currentCommand + 1), commands, currentCommand + 1, text, addedParen, start, addedCloseParen, newDeltaCaretPosition);
                        } else {
                            try {
                                ScriptConsoleDocumentListener.this.onAfterAllLinesHandled(text, addedParen, start, (this).ScriptConsoleDocumentListener.this.readOnlyColumnsInCurrentBeforePrompt, addedCloseParen, finalIndentString[0], newDeltaCaretPosition);
                            }
                            finally {
                                ScriptConsoleDocumentListener.this.stopDisconnected();
                            }
                        }
                    }
                };
                RunInUiThread.async((Runnable)runnable);
                return null;
            }
        };
        this.handler.beforeHandleCommand(commandLine, onResponseReceived);
        Job j = new Job("PyDev Console Hander", (ICallback)onResponseReceived){
            private final /* synthetic */ ICallback val$onResponseReceived;
            {
                this.val$onResponseReceived = iCallback;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                ScriptConsoleDocumentListener.this.promptReady = false;
                ScriptConsoleDocumentListener.this.handler.handleCommand(commandLine, (ICallback<Object, InterpreterResponse>)this.val$onResponseReceived);
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.schedule();
    }

    public void handleConsoleTabCompletions() {
        final String commandLine = this.getCommandLine();
        final int commandLineOffset = this.viewer.getCommandLineOffset();
        final int caretOffset = this.viewer.getCaretOffset();
        Job j = new Job("Async Fetch completions"){

            protected IStatus run(IProgressMonitor monitor) {
                ICompletionProposalHandle[] completions = ScriptConsoleDocumentListener.this.handler.getTabCompletions(commandLine, caretOffset - commandLineOffset);
                if (completions.length == 0) {
                    return Status.OK_STATUS;
                }
                final ArrayList<String> compList = new ArrayList<String>();
                boolean magicCommand = commandLine.startsWith("%") && !commandLine.startsWith("%cd ");
                ICompletionProposalHandle[] iCompletionProposalHandleArray = completions;
                int n = completions.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompletionProposalHandle completion = iCompletionProposalHandleArray[n2];
                    boolean magicCompletion = completion.getDisplayString().startsWith("%");
                    Document doc = new Document(commandLine.substring(magicCommand && magicCompletion ? 1 : 0));
                    completion.apply((IDocument)doc);
                    String out = doc.get().substring(magicCommand && !magicCompletion ? 1 : 0);
                    if (!out.startsWith("_", out.lastIndexOf(46) + 1) || commandLine.startsWith("_", commandLine.lastIndexOf(46) + 1)) {
                        if (out.indexOf(40, commandLine.length()) != -1) {
                            out = out.substring(0, out.indexOf(40, commandLine.length()));
                        }
                        compList.add(out);
                    }
                    ++n2;
                }
                String longestCommonPrefix = null;
                for (String completion : compList) {
                    if (!completion.startsWith(commandLine)) continue;
                    if (longestCommonPrefix == null) {
                        longestCommonPrefix = completion;
                        continue;
                    }
                    int i = 0;
                    while (i < longestCommonPrefix.length() && i < completion.length()) {
                        if (longestCommonPrefix.charAt(i) != completion.charAt(i)) {
                            longestCommonPrefix = longestCommonPrefix.substring(0, i);
                            break;
                        }
                        ++i;
                    }
                    if (longestCommonPrefix.length() <= completion.length()) continue;
                    longestCommonPrefix = completion;
                }
                if (longestCommonPrefix == null) {
                    longestCommonPrefix = commandLine;
                }
                int length = 0;
                for (String completion : compList) {
                    length = Math.max(length, completion.length());
                }
                final String fLongestCommonPrefix = longestCommonPrefix;
                final int maxLength = length;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        int formatLength;
                        int consoleWidth = (this).ScriptConsoleDocumentListener.this.viewer.getConsoleWidthInCharacters();
                        int completionsPerLine = consoleWidth / (formatLength = maxLength + 4);
                        if (completionsPerLine <= 0) {
                            completionsPerLine = 1;
                        }
                        String formatString = "%-" + formatLength + "s";
                        StringBuilder sb = new StringBuilder("\n");
                        int i = 0;
                        for (String completion : compList) {
                            sb.append(String.format(formatString, completion));
                            if (++i % completionsPerLine != 0) continue;
                            sb.append("\n");
                        }
                        sb.append("\n");
                        String currentCommand = ScriptConsoleDocumentListener.this.getCommandLine();
                        try {
                            ScriptConsoleDocumentListener.this.startDisconnected();
                            ScriptConsoleDocumentListener.this.addToConsoleView(sb.toString(), true, true);
                            ScriptConsoleDocumentListener.this.appendInvitation(false);
                        }
                        finally {
                            ScriptConsoleDocumentListener.this.stopDisconnected();
                        }
                        if (!currentCommand.equals(commandLine) || fLongestCommonPrefix.isEmpty()) {
                            ScriptConsoleDocumentListener.this.addToConsoleView(currentCommand, true, false);
                        } else {
                            ScriptConsoleDocumentListener.this.addToConsoleView(fLongestCommonPrefix, true, false);
                        }
                    }
                };
                RunInUiThread.async((Runnable)r);
                return Status.OK_STATUS;
            }
        };
        j.setPriority(10);
        j.setRule((ISchedulingRule)new TabCompletionSingletonRule());
        j.setSystem(true);
        j.schedule();
    }

    private void onAfterAllLinesHandled(String finalText, char finalAddedParen, int finalStart, int finalOffset, char finalAddedCloseParen, String finalIndentString, int finalNewDeltaCaretPosition) {
        String cmdLine;
        boolean shiftsCaret = true;
        String newText = finalText.substring(finalStart, finalText.length());
        if (finalAddedParen != '\u0000') {
            cmdLine = this.getCommandLine();
            Document parenDoc = new Document(String.valueOf(cmdLine) + newText);
            int currentOffset = cmdLine.length() + 1;
            DocCmd docCmd = new DocCmd(currentOffset, 0, "" + finalAddedParen);
            docCmd.shiftsCaret = true;
            this.strategy.setConsiderOnlyCurrentLine(true);
            this.strategy.customizeDocumentCommand((IDocument)parenDoc, (IDocumentCommand)docCmd);
            newText = String.valueOf(docCmd.text) + newText.substring(1);
            if (!docCmd.shiftsCaret) {
                shiftsCaret = false;
                this.setCaretOffset(finalOffset + (docCmd.caretOffset - currentOffset));
            }
        } else if (finalAddedCloseParen != '\u0000') {
            cmdLine = this.getCommandLine();
            String existingDoc = String.valueOf(cmdLine) + finalText.substring(1);
            int cmdLineOffset = cmdLine.length();
            if (existingDoc.length() > cmdLineOffset) {
                boolean canSkipOpenParenthesis;
                Document parenDoc = new Document(existingDoc);
                DocCmd docCmd = new DocCmd(cmdLineOffset, 0, "" + finalAddedCloseParen);
                docCmd.shiftsCaret = true;
                try {
                    canSkipOpenParenthesis = this.strategy.canSkipCloseParenthesis((IDocument)parenDoc, (IDocumentCommand)docCmd);
                }
                catch (BadLocationException e) {
                    canSkipOpenParenthesis = false;
                    Log.log((Throwable)e);
                }
                if (canSkipOpenParenthesis) {
                    shiftsCaret = false;
                    this.setCaretOffset(finalOffset + 1);
                    newText = newText.substring(1);
                }
            }
        }
        String cmd = String.valueOf(finalIndentString) + newText;
        cmd = this.convertTabs(cmd);
        this.applyStyleToUserAddedText(cmd, this.doc.getLength());
        this.appendText(cmd);
        if (shiftsCaret) {
            this.setCaretOffset(this.doc.getLength() - finalNewDeltaCaretPosition);
        }
        this.history.update(this.getCommandLine());
    }

    private String convertTabs(String cmd) {
        return this.strategy.convertTabs(cmd);
    }

    private void applyStyleToUserAddedText(String cmd, int offset2) {
        ScriptStyleRange style;
        IConsoleStyleProvider styleProvider = this.viewer.getStyleProvider();
        if (styleProvider != null && (style = styleProvider.createUserInputStyle(cmd, offset2)) != null) {
            this.addToPartitioner(style);
        }
    }

    public void documentChanged(DocumentEvent event) {
        this.lastChangeMillis = System.currentTimeMillis();
        this.startDisconnected();
        try {
            int eventOffset = event.getOffset();
            String eventText = event.getText();
            this.proccessAddition(eventOffset, eventText);
        }
        finally {
            this.stopDisconnected();
        }
    }

    protected void appendText(String text) {
        int initialOffset = this.doc.getLength();
        try {
            this.doc.replace(initialOffset, 0, text);
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
    }

    protected void appendInvitation(boolean async) {
        ScriptStyleRange style;
        int start = this.doc.getLength();
        String promptStr = this.prompt.toString();
        IConsoleStyleProvider styleProvider = this.viewer.getStyleProvider();
        if (styleProvider != null && (style = styleProvider.createPromptStyle(promptStr, start)) != null) {
            this.addToPartitioner(style);
        }
        this.appendText(promptStr);
        this.setCaretOffset(this.doc.getLength(), async);
        this.revealEndOfDocument();
        this.promptReady = true;
    }

    private void revealEndOfDocument() {
        this.viewer.revealEndOfDocument();
        Iterator<WeakReference<IScriptConsoleViewer2ForDocumentListener>> it = this.otherViewers.iterator();
        while (it.hasNext()) {
            WeakReference<IScriptConsoleViewer2ForDocumentListener> ref = it.next();
            IScriptConsoleViewer2ForDocumentListener v = (IScriptConsoleViewer2ForDocumentListener)ref.get();
            if (v == null) {
                it.remove();
                continue;
            }
            v.revealEndOfDocument();
        }
    }

    private void setCaretOffset(int offset) {
        this.setCaretOffset(offset, false);
    }

    private void setCaretOffset(int offset, boolean async) {
        this.viewer.setCaretOffset(offset, async);
        Iterator<WeakReference<IScriptConsoleViewer2ForDocumentListener>> it = this.otherViewers.iterator();
        while (it.hasNext()) {
            WeakReference<IScriptConsoleViewer2ForDocumentListener> ref = it.next();
            IScriptConsoleViewer2ForDocumentListener v = (IScriptConsoleViewer2ForDocumentListener)ref.get();
            if (v == null) {
                it.remove();
                continue;
            }
            v.setCaretOffset(offset, async);
        }
    }

    public String getDelimeter() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
    }

    public int getLastLineLength() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        return this.doc.getLineLength(lastLine);
    }

    public int getLastLineOffset() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        return this.doc.getLineOffset(lastLine);
    }

    public int getLastLineReadOnlySize() {
        return this.readOnlyColumnsInCurrentBeforePrompt + this.prompt.toString().length();
    }

    public int getCommandLineOffset() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        int commandLineOffset = this.doc.getLineOffset(lastLine) + this.getLastLineReadOnlySize();
        if (commandLineOffset > this.doc.getLength()) {
            return this.doc.getLength();
        }
        return commandLineOffset;
    }

    public int getCommandLineLength() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        int len = this.doc.getLineLength(lastLine) - this.getLastLineReadOnlySize();
        if (len <= 0) {
            return 0;
        }
        return len;
    }

    public String getCommandLine() {
        int commandLineLength;
        int commandLineOffset;
        try {
            commandLineOffset = this.getCommandLineOffset();
            commandLineLength = this.getCommandLineLength();
        }
        catch (BadLocationException e1) {
            Log.log((Throwable)e1);
            return "";
        }
        if (commandLineLength < 0) {
            return "";
        }
        try {
            return this.doc.get(commandLineOffset, commandLineLength);
        }
        catch (BadLocationException e) {
            String msg = new FastStringBuffer(60).append("Error: bad location: offset:").append(commandLineOffset).append(" text:").append(commandLineLength).toString();
            Log.log((String)msg);
            return "";
        }
    }

    public void setCommandLine(String command) throws BadLocationException {
        this.doc.replace(this.getCommandLineOffset(), this.getCommandLineLength(), command);
    }

    public void discardCommandLine() {
        if (!this.prompt.getNeedInput()) {
            String commandLine = this.getCommandLine();
            if (!commandLine.isEmpty()) {
                this.history.commit();
            } else if (!this.prompt.getNeedMore()) {
                return;
            }
        }
        this.startDisconnected();
        try {
            try {
                this.doc.replace(this.doc.getLength(), 0, "\n");
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
            this.readOnlyColumnsInCurrentBeforePrompt = 0;
            this.prompt.setMode(true);
            this.prompt.setNeedInput(false);
            this.appendInvitation(false);
            this.viewer.setCaretOffset(this.doc.getLength(), false);
        }
        finally {
            this.stopDisconnected();
        }
    }

    public void setScrollLock(boolean state) {
        this.scrollLock = state;
    }

    public boolean getScrollLock() {
        return this.scrollLock;
    }

    private class PromptContext {
        public boolean removedPrompt;
        public int cursorOffset;
        public String userInput;

        public PromptContext(boolean removedPrompt, int cursorOffset, String userInput) {
            this.removedPrompt = removedPrompt;
            this.cursorOffset = cursorOffset;
            this.userInput = userInput;
        }
    }

    private static class TabCompletionSingletonRule
    implements ISchedulingRule {
        private TabCompletionSingletonRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof TabCompletionSingletonRule;
        }
    }
}

