/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django.debug.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.python.pydev.ast.runners.SimpleRunner;
import org.python.pydev.django.debug.ui.actions.DjangoAction;
import org.python.pydev.plugin.nature.PythonNature;

public class DjangoWar
extends DjangoAction {
    @Override
    public void run(IAction action) {
        try {
            PythonNature nature = PythonNature.getPythonNature((IProject)this.selectedProject);
            if (nature.getInterpreterType() != 1) {
                MessageDialog.openInformation(null, (String)"Can't create WAR", (String)"Creation of WAR packages is only supported on Jython");
                return;
            }
            String projectPythonPath = nature.getPythonPathNature().getOnlyProjectPythonPathStr(true);
            String javaLibs = null;
            String[] stringArray = projectPythonPath.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (path.endsWith(".jar")) {
                    if (javaLibs == null) {
                        javaLibs = path;
                    } else {
                        javaLibs = String.valueOf(javaLibs) + SimpleRunner.getPythonPathSeparator();
                        javaLibs = String.valueOf(javaLibs) + path;
                    }
                }
                ++n2;
            }
            String command = "war";
            if (javaLibs != null) {
                command = String.valueOf(command) + " --include-java-libs=" + javaLibs;
            }
            this.launchDjangoCommand(command, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

