/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django.ui.wizards.project;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.BaseModuleRequest;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModuleRequestState;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PyStringUtils;
import org.python.pydev.django.ui.wizards.project.DjangoNotAvailableWizardPage;
import org.python.pydev.django.ui.wizards.project.ErrorWizardPage;
import org.python.pydev.ui.wizards.project.NewProjectNameAndLocationWizardPage;

public class DjangoNewProjectPage
extends NewProjectNameAndLocationWizardPage {
    public DjangoNewProjectPage(String pageName) {
        super(pageName);
        this.setTitle("PyDev Django Project");
        this.setDescription("Create a new Pydev Django Project.");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    public IWizardPage getNextPage() {
        String projectType = this.getProjectType();
        IInterpreterManager interpreterManager = IPythonNature.Versions.ALL_JYTHON_VERSIONS.contains(projectType) ? InterpreterManagersAPI.getJythonInterpreterManager() : (IPythonNature.Versions.ALL_IRONPYTHON_VERSIONS.contains(projectType) ? InterpreterManagersAPI.getIronpythonInterpreterManager() : InterpreterManagersAPI.getPythonInterpreterManager());
        try {
            String projectInterpreter = this.getProjectInterpreter();
            IInterpreterInfo interpreterInfo = projectInterpreter.toLowerCase().equals("default") ? interpreterManager.getDefaultInterpreterInfo(false) : interpreterManager.getInterpreterInfo(projectInterpreter, (IProgressMonitor)new NullProgressMonitor());
            IModule module = interpreterInfo.getModulesManager().getModuleWithoutBuiltins("django.core.__init__", null, false, (IModuleRequestState)new BaseModuleRequest(false));
            if (module == null) {
                DjangoNotAvailableWizardPage page = new DjangoNotAvailableWizardPage("Django not available", interpreterInfo);
                page.setWizard(this.getWizard());
                return page;
            }
        }
        catch (MisconfigurationException e) {
            ErrorWizardPage page = new ErrorWizardPage("Unexpected error.", "An unexpected error happened:\n" + e.getMessage());
            page.setWizard(this.getWizard());
            return page;
        }
        return super.getNextPage();
    }

    protected boolean validatePage() {
        boolean validated = super.validatePage();
        if (!validated) {
            return false;
        }
        String projectName = this.getProjectName();
        if (projectName.trim().toLowerCase().equals("django")) {
            this.setErrorMessage("When creating a Django project it cannot be named Django because of conflicts with the default Django install.");
            return false;
        }
        if (!PyStringUtils.isValidIdentifier((String)projectName, (boolean)false)) {
            this.setErrorMessage("Project name is not a valid identifier.");
            return false;
        }
        return true;
    }
}

