// Autogenerated AST node
package org.python.pydev.parser.jython.ast;

import org.python.pydev.parser.jython.SimpleNode;
import java.util.Arrays;

public final class MatchSequence extends patternType implements enclosingType {
    public patternType[] patterns;
    public int enclosing;

    public MatchSequence(patternType[] patterns, int enclosing) {
        this.patterns = patterns;
        this.enclosing = enclosing;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(patterns);
        result = prime * result + enclosing;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;
        if (getClass() != obj.getClass()) return false;
        MatchSequence other = (MatchSequence) obj;
        if (!Arrays.equals(patterns, other.patterns)) return false;
        if(this.enclosing != other.enclosing) return false;
        return true;
    }
    @Override
    public MatchSequence createCopy() {
        return createCopy(true);
    }
    @Override
    public MatchSequence createCopy(boolean copyComments) {
        patternType[] new0;
        if(this.patterns != null){
        new0 = new patternType[this.patterns.length];
        for(int i=0;i<this.patterns.length;i++){
            new0[i] = (patternType) (this.patterns[i] != null?
            this.patterns[i].createCopy(copyComments):null);
        }
        }else{
            new0 = this.patterns;
        }
        MatchSequence temp = new MatchSequence(new0, enclosing);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if(this.specialsBefore != null && copyComments){
            for(Object o:this.specialsBefore){
                if(o instanceof commentType){
                    commentType commentType = (commentType) o;
                    temp.getSpecialsBefore().add(commentType.createCopy(copyComments));
                }
            }
        }
        if(this.specialsAfter != null && copyComments){
            for(Object o:this.specialsAfter){
                if(o instanceof commentType){
                    commentType commentType = (commentType) o;
                    temp.getSpecialsAfter().add(commentType.createCopy(copyComments));
                }
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MatchSequence[");
        sb.append("patterns=");
        sb.append(dumpThis(this.patterns));
        sb.append(", ");
        sb.append("enclosing=");
        sb.append(dumpThis(this.enclosing, enclosingType.enclosingTypeNames));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitMatchSequence(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        if (patterns != null) {
            for (int i = 0; i < patterns.length; i++) {
                if (patterns[i] != null) {
                    patterns[i].accept(visitor);
                }
            }
        }
    }

}
