/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.application;

import java.io.File;
import org.eclipse.cdt.debug.application.Messages;
import org.eclipse.cdt.debug.application.RemoteExecutableInfo;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RemoteExecutableDialog
extends TitleAreaDialog {
    private RemoteExecutableInfo fInfo = null;
    private Text fHostBinaryText;
    private Label fBinaryLabel;
    private Text fBuildLogText;
    private Text fAddressText;
    private Text fPortText;
    private Button fAttachButton;
    private final String fHostBinary;
    private final String fBuildLog;
    private final String fAddress;
    private final String fPort;
    private final boolean fAttach;

    public RemoteExecutableDialog(Shell parentShell) {
        this(parentShell, null, null, null, null, false);
    }

    public RemoteExecutableDialog(Shell parentShell, String hostBinary, String buildLog, String address, String port, boolean attach) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fHostBinary = hostBinary;
        this.fBuildLog = buildLog;
        this.fAddress = address;
        this.fPort = port;
        this.fAttach = attach;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.validate();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.GdbDebugRemoteExecutableCommand_Debug_Remote_Executable);
        this.setTitle(Messages.GdbDebugRemoteExecutableCommand_Select_Remote_Options);
        String message = Messages.GdbDebugRemoteExecutableCommand_Select_Remote_Options;
        this.setMessage(message);
        Composite control = (Composite)super.createDialogArea(parent);
        Composite comp = new Composite(control, 0);
        GridData gd = new GridData(4, 4, true, true);
        GridLayout layout = new GridLayout(3, false);
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)gd);
        this.fBinaryLabel = new Label(comp, 0);
        this.fBinaryLabel.setText(this.fAttach ? Messages.GdbDebugExecutableCommand_Binary_Optional : Messages.GdbDebugExecutableCommand_Binary);
        this.fHostBinaryText = new Text(comp, 2048);
        if (this.fHostBinary != null) {
            this.fHostBinaryText.setText(this.fHostBinary);
        }
        this.fHostBinaryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fHostBinaryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteExecutableDialog.this.validate();
            }
        });
        Button browseButton = new Button(comp, 8);
        browseButton.setText(Messages.GdbDebugExecutableCommand_Browse);
        browseButton.setFont(JFaceResources.getDialogFont());
        this.setButtonLayoutData(browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(RemoteExecutableDialog.this.getShell());
                dialog.setFileName(RemoteExecutableDialog.this.fHostBinaryText.getText());
                String result = dialog.open();
                if (result != null) {
                    RemoteExecutableDialog.this.fHostBinaryText.setText(result);
                }
            }
        });
        new Label(comp, 0).setText(Messages.GdbDebugExecutableCommand_BuildLog);
        this.fBuildLogText = new Text(comp, 2048);
        if (this.fBuildLog != null) {
            this.fBuildLogText.setText(this.fBuildLog);
        }
        this.fBuildLogText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fBuildLogText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteExecutableDialog.this.validate();
            }
        });
        new Label(comp, 0).setText(Messages.GdbDebugRemoteExecutableCommand_Host_name_or_ip_address);
        this.fAddressText = new Text(comp, 2048);
        if (this.fAddress != null) {
            this.fAddressText.setText(this.fAddress);
        }
        this.fAddressText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fAddressText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteExecutableDialog.this.validate();
            }
        });
        new Label(comp, 0).setText(Messages.GdbDebugRemoteExecutableCommand_Port_number);
        this.fPortText = new Text(comp, 2048);
        if (this.fPort != null) {
            this.fPortText.setText(this.fPort);
        }
        this.fPortText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteExecutableDialog.this.validate();
            }
        });
        this.fAttachButton = new Button(comp, 32);
        this.fAttachButton.setText(Messages.GdbDebugRemoteExecutableCommand_Attach);
        this.fAttachButton.setSelection(this.fAttach);
        this.fAttachButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RemoteExecutableDialog.this.fBinaryLabel.setText(RemoteExecutableDialog.this.fAttachButton.getSelection() ? Messages.GdbDebugExecutableCommand_Binary_Optional : Messages.GdbDebugExecutableCommand_Binary);
                RemoteExecutableDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RemoteExecutableDialog.this.fBinaryLabel.setText(RemoteExecutableDialog.this.fAttachButton.getSelection() ? Messages.GdbDebugExecutableCommand_Binary_Optional : Messages.GdbDebugExecutableCommand_Binary);
                RemoteExecutableDialog.this.validate();
            }
        });
        return control;
    }

    protected void okPressed() {
        this.fInfo = new RemoteExecutableInfo(this.fHostBinaryText.getText().trim(), this.fBuildLogText.getText().trim(), this.fAddressText.getText().trim(), this.fPortText.getText().trim(), this.fAttachButton.getSelection());
        super.okPressed();
    }

    public RemoteExecutableInfo getExecutableInfo() {
        return this.fInfo;
    }

    private void validate() {
        String error = null;
        String hostBinary = this.fHostBinaryText.getText().trim();
        if (hostBinary.isEmpty()) {
            boolean attach = this.fAttachButton.getSelection();
            if (!attach) {
                error = Messages.GdbDebugNewExecutableCommand_Binary_must_be_specified;
            }
        } else {
            File file = new File(hostBinary);
            if (!file.exists()) {
                error = Messages.GdbDebugNewExecutableCommand_Binary_file_does_not_exist;
            } else if (file.isDirectory()) {
                error = Messages.GdbDebugNewExecutableCommand_Invalid_binary;
            }
        }
        String buildLog = this.fBuildLogText.getText();
        if (error == null && !buildLog.isEmpty()) {
            File file = new File(buildLog);
            if (!file.exists()) {
                error = Messages.GdbDebugNewExecutableCommand_BuildLog_file_does_not_exist;
            } else if (file.isDirectory()) {
                error = Messages.GdbDebugNewExecutableCommand_Invalid_buildLog;
            }
        }
        String address = this.fAddressText.getText().trim();
        if (error == null && address.isEmpty()) {
            error = Messages.GdbDebugRemoteExecutableCommand_address_must_be_specified;
        }
        String port = this.fPortText.getText().trim();
        if (error == null) {
            if (port.isEmpty()) {
                error = Messages.GdbDebugRemoteExecutableCommand_port_must_be_specified;
            } else {
                try {
                    Integer.parseInt(port);
                }
                catch (NumberFormatException numberFormatException) {
                    error = Messages.GdbDebugRemoteExecutableCommand_port_must_be_a_number;
                }
            }
        }
        this.setErrorMessage(error != null ? error : null);
        this.getButton(0).setEnabled(this.getErrorMessage() == null);
    }
}

