/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.qt.core.ASTUtil;
import org.eclipse.cdt.qt.core.QtKeywords;

public class QtFunctionCallUtil {
    private static final Pattern SignalRegex = Pattern.compile("^\\s*SIGNAL.*");
    private static final Pattern MethodRegex = Pattern.compile("^\\s*(?:SIGNAL|SLOT).*");

    public static boolean isQObjectFunctionCall(IASTCompletionContext astContext, boolean isPrefix, IASTName name) {
        IBinding[] funcBindings;
        if (name == null || name.getSimpleID() == null || name.getSimpleID().length <= 0) {
            return false;
        }
        IBinding[] iBindingArray = funcBindings = astContext.findBindings(name.getLastName(), isPrefix);
        int n = funcBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding funcBinding = iBindingArray[n2];
            if (QtKeywords.is_QObject_connect(funcBinding) || QtKeywords.is_QObject_disconnect(funcBinding)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IType getTargetType(IASTFunctionCallExpression call, IASTInitializerClause[] args, int argIndex) {
        int sigExpIndex = QtFunctionCallUtil.getExpansionArgIndex(args, 0, SignalRegex);
        if (argIndex == sigExpIndex) {
            return QtFunctionCallUtil.getSignalTargetType(sigExpIndex, call, args);
        }
        int methodExpIndex = QtFunctionCallUtil.getExpansionArgIndex(args, sigExpIndex + 1, MethodRegex);
        if (argIndex == methodExpIndex) {
            return QtFunctionCallUtil.getMethodTargetType(methodExpIndex, sigExpIndex, call, args);
        }
        return null;
    }

    private static IType getSignalTargetType(int sigExpIndex, IASTFunctionCallExpression call, IASTInitializerClause[] args) {
        return ASTUtil.getBaseType((IASTInitializerClause)(sigExpIndex == 0 ? call : args[sigExpIndex - 1]));
    }

    private static IType getMethodTargetType(int methodExpIndex, int sigExpIndex, IASTFunctionCallExpression call, IASTInitializerClause[] args) {
        if (methodExpIndex == sigExpIndex + 1) {
            return ASTUtil.getReceiverType(call);
        }
        return ASTUtil.getBaseType(args[methodExpIndex - 1]);
    }

    private static int getExpansionArgIndex(IASTInitializerClause[] args, int begin, Pattern macroNameRegex) {
        int i = begin;
        while (i < args.length) {
            IASTInitializerClause arg = args[i];
            String raw = arg.getRawSignature();
            Matcher m = macroNameRegex.matcher(raw);
            if (m.matches()) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

