/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.qt.core.index.QMakeEnvProviderManager;
import org.eclipse.cdt.internal.qt.core.index.QMakeInfo;
import org.eclipse.cdt.qt.core.index.IQMakeEnv;
import org.eclipse.cdt.qt.core.index.IQMakeEnv2;
import org.eclipse.cdt.qt.core.index.IQMakeEnvProvider;
import org.eclipse.cdt.qt.core.index.IQMakeInfo;
import org.eclipse.cdt.qt.core.index.IQMakeProjectInfo;
import org.eclipse.cdt.qt.core.index.IQMakeProjectInfoListener;
import org.eclipse.cdt.qt.core.index.QMakeEnvInfo;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class QMakeProjectInfo
implements IQMakeProjectInfo {
    private final State STATE_FREEZE = new State();
    private final State STATE_INVALID = new State();
    private final List<IQMakeProjectInfoListener> listeners = new CopyOnWriteArrayList<IQMakeProjectInfoListener>();
    private final IProject project;
    private final Object stateSync = new Object();
    private State state = this.STATE_INVALID;

    QMakeProjectInfo(IProject project) {
        this.project = project;
    }

    void destroy() {
        this.setState(this.STATE_FREEZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStateFrom(State fromState) {
        Object object = this.stateSync;
        synchronized (object) {
            if (this.state != fromState) {
                return;
            }
        }
        this.updateState();
    }

    State updateState() {
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescriptionManager().getProjectDescription(this.project);
        ICConfigurationDescription configuration = projectDescription != null ? projectDescription.getActiveConfiguration() : null;
        State newState = configuration != null ? new State(configuration) : this.STATE_INVALID;
        this.setState(newState);
        return newState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State newState) {
        State oldState = null;
        Object object = this.stateSync;
        synchronized (object) {
            if (newState == null || this.state == newState) {
                return;
            }
            if (this.state == this.STATE_FREEZE) {
                newState.destroyBeforeInit();
                return;
            }
            oldState = this.state;
            this.state = newState;
            if (oldState != null) {
                oldState.destroy();
            }
            newState.init();
        }
        for (IQMakeProjectInfoListener listener : this.listeners) {
            listener.qmakeInfoChanged();
        }
    }

    @Override
    public void addListener(IQMakeProjectInfoListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IQMakeProjectInfoListener listener) {
        this.listeners.remove(listener);
    }

    IProject getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQMakeInfo getActualInfo() {
        Object object = this.stateSync;
        synchronized (object) {
            return this.state.getQMakeInfo();
        }
    }

    @Override
    public IQMakeInfo updateActualInfo() {
        return this.updateState().getQMakeInfo();
    }

    private static String toFilePath(IFile file) {
        File f;
        IPath rawLocation;
        if (file != null && (rawLocation = file.getRawLocation()) != null && (rawLocation = rawLocation.makeAbsolute()) != null && (f = rawLocation.toFile()) != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsAnySensitiveFile(Set<IPath> files) {
        Object object = this.stateSync;
        synchronized (object) {
            return this.state.containsAnySensitiveFile(files);
        }
    }

    private static final class SensitiveSet
    extends HashSet<IPath> {
        private static final long serialVersionUID = 2684086006933209512L;

        private SensitiveSet() {
        }

        private void addSensitiveFile(String sensitiveFile) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile[] files = root.findFilesForLocationURI(URIUtil.toURI((IPath)Path.fromOSString((String)sensitiveFile).makeAbsolute()));
            if (files != null && files.length > 0) {
                IFile file = files[0];
                this.addSensitiveFile(file);
            }
        }

        private void addSensitiveFile(IFile file) {
            IPath fullPath = file.getFullPath();
            if (fullPath != null) {
                this.add(fullPath);
            }
        }
    }

    private final class State
    implements IQMakeEnvProvider.IController {
        private final ICConfigurationDescription configuration;
        private final IQMakeEnv qmakeEnv;
        private final IQMakeInfo qmakeInfo;
        private final SensitiveSet sensitiveFilePathSet;

        State() {
            this.configuration = null;
            this.qmakeEnv = null;
            this.qmakeInfo = QMakeInfo.INVALID;
            this.sensitiveFilePathSet = new SensitiveSet();
        }

        State(ICConfigurationDescription configuration) {
            List<String> list;
            this.configuration = configuration;
            this.qmakeEnv = QMakeEnvProviderManager.getInstance().createEnv(this);
            QMakeEnvInfo qmakeEnvInfo = this.qmakeEnv.getQMakeEnvInfo();
            String proFilePath = QMakeProjectInfo.toFilePath(qmakeEnvInfo != null ? qmakeEnvInfo.getProFile() : null);
            String qmakeFilePath = qmakeEnvInfo != null ? qmakeEnvInfo.getQMakeFilePath() : null;
            ArrayList<String> envList = new ArrayList<String>();
            Map<Object, Object> envMap = qmakeEnvInfo != null ? qmakeEnvInfo.getEnvironment() : Collections.emptyMap();
            for (Map.Entry<Object, Object> entry : envMap.entrySet()) {
                envList.add(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
            }
            this.qmakeInfo = QMakeInfo.create(proFilePath, qmakeFilePath, envList.toArray(new String[envList.size()]));
            this.sensitiveFilePathSet = new SensitiveSet();
            Set<Object> envSensFiles = qmakeEnvInfo != null ? qmakeEnvInfo.getSensitiveFiles() : Collections.emptySet();
            for (IFile iFile : envSensFiles) {
                if (iFile == null) continue;
                this.sensitiveFilePathSet.addSensitiveFile(iFile);
            }
            if (proFilePath != null) {
                this.sensitiveFilePathSet.addSensitiveFile(proFilePath);
            }
            if ((list = this.qmakeInfo.getInvolvedQMakeFiles()) != null) {
                for (String sensitiveFile : list) {
                    this.sensitiveFilePathSet.addSensitiveFile(sensitiveFile);
                }
            }
        }

        private boolean containsAnySensitiveFile(Set<IPath> files) {
            for (IPath path : files) {
                if (!this.sensitiveFilePathSet.contains(path)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ICConfigurationDescription getConfiguration() {
            return this.configuration;
        }

        public void destroyBeforeInit() {
            if (this.qmakeEnv != null && !(this.qmakeEnv instanceof IQMakeEnv2)) {
                this.qmakeEnv.destroy();
            }
        }

        public void init() {
            if (this.qmakeEnv instanceof IQMakeEnv2) {
                ((IQMakeEnv2)this.qmakeEnv).init();
            }
        }

        public void destroy() {
            if (this.qmakeEnv != null) {
                this.qmakeEnv.destroy();
            }
        }

        @Override
        public void scheduleUpdate() {
            QMakeProjectInfo.this.updateStateFrom(this);
        }

        IQMakeInfo getQMakeInfo() {
            return this.qmakeInfo;
        }
    }
}

