/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.util.StringUtil;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class LaunchUtils {
    public static final String MACOS_GDB_MARKER = "APPLE";

    public static ICProject verifyCProject(ILaunchConfiguration configuration) throws CoreException {
        String name = LaunchUtils.getProjectName(configuration);
        if (name == null) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.C_Project_not_specified"), null, 102);
            return null;
        }
        ICProject cproject = LaunchUtils.getCProject(configuration);
        if (cproject == null && name.length() > 0) {
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!proj.exists()) {
                LaunchUtils.abort(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Project_NAME_does_not_exist", name), null, 103);
            } else if (!proj.isOpen()) {
                LaunchUtils.abort(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Project_NAME_is_closed", name), null, 103);
            }
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Not_a_C_CPP_project"), null, 103);
        }
        return cproject;
    }

    public static IPath verifyProgramPath(ILaunchConfiguration configuration, ICProject cproject) throws CoreException {
        Path programPath;
        String programName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
        if (programName == null) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_not_specified"), null, 103);
        }
        if ((programPath = new Path(programName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programName))).isEmpty()) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_does_not_exist"), null, 103);
        }
        if (!programPath.isAbsolute() && cproject != null) {
            IFile wsProgramPath = cproject.getProject().getFile((IPath)programPath);
            programPath = wsProgramPath.getLocation();
        }
        if (!programPath.toFile().exists()) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.PROGRAM_PATH_not_found", programPath.toOSString())), 104);
        }
        return programPath;
    }

    public static IBinaryParser.IBinaryObject verifyBinary(ILaunchConfiguration configuration, IPath exePath) throws CoreException {
        ICProject cproject = LaunchUtils.getCProject(configuration);
        if (cproject != null) {
            ICConfigExtensionReference[] parserRefs;
            ICConfigExtensionReference[] iCConfigExtensionReferenceArray = parserRefs = CCorePlugin.getDefault().getDefaultBinaryParserExtensions(cproject.getProject());
            int n = parserRefs.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigExtensionReference parserRef = iCConfigExtensionReferenceArray[n2];
                try {
                    IBinaryParser parser = CoreModelUtil.getBinaryParser((ICConfigExtensionReference)parserRef);
                    IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
                    if (exe != null) {
                        return exe;
                    }
                }
                catch (ClassCastException classCastException) {
                }
                catch (IOException iOException) {}
                ++n2;
            }
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            return (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
        }
        catch (ClassCastException classCastException) {
        }
        catch (IOException iOException) {}
        LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_is_not_a_recognized_executable"), new FileNotFoundException(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Program_is_not_a_recognized_executable", exePath.toOSString())), 107);
        return null;
    }

    private static void abort(String message, Throwable exception, int code) throws CoreException {
        MultiStatus status = new MultiStatus("org.eclipse.cdt.dsf.gdb", code, message, exception);
        status.add((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", code, exception == null ? "" : exception.getLocalizedMessage(), exception));
        throw new CoreException((IStatus)status);
    }

    public static ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = LaunchUtils.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                return cProject;
            }
        }
        return null;
    }

    private static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }

    public static IPath getGDBPath(ILaunchConfiguration configuration) {
        String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
        Path retVal = new Path(defaultGdbCommand);
        try {
            String gdb = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            gdb = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(gdb, false);
            retVal = new Path(gdb);
        }
        catch (CoreException coreException) {}
        return retVal;
    }

    public static String getGDBVersionFromText(String versionOutput) {
        String version = "";
        Pattern pattern = Pattern.compile(" gdb( \\(.*?\\))? (\\D* )*\\(?(\\d*(\\.\\d*)*)", 8);
        Matcher matcher = pattern.matcher(versionOutput);
        if (matcher.find()) {
            version = matcher.group(3);
            if (versionOutput.toLowerCase().indexOf("cygwin") != -1 && version.startsWith("6.8")) {
                version = "6.8";
            }
        }
        if (versionOutput.indexOf("Apple") != -1) {
            version = String.valueOf(version) + MACOS_GDB_MARKER;
            Pattern aPattern = Pattern.compile(" \\(Apple version gdb-(\\d+(\\.\\d+)*)\\)", 8);
            Matcher aMatcher = aPattern.matcher(versionOutput);
            if (aMatcher.find()) {
                version = String.valueOf(version) + aMatcher.group(1);
            }
        }
        return version;
    }

    public static String getGDBVersion(ILaunchConfiguration configuration) throws CoreException {
        String cmd = String.valueOf(LaunchUtils.getGDBPath(configuration).toOSString()) + " --version";
        String[] args = CommandLineUtil.argumentsToArray((String)cmd);
        Process process = null;
        Job timeoutJob = null;
        try {
            final Process finalProc = process = ProcessFactory.getFactory().exec(args, LaunchUtils.getLaunchEnvironment(configuration));
            timeoutJob = new Job("GDB version timeout job"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor arg) {
                    finalProc.destroy();
                    return Status.OK_STATUS;
                }
            };
            timeoutJob.schedule(10000L);
            String streamOutput = LaunchUtils.readStream(process.getInputStream());
            String gdbVersion = LaunchUtils.getGDBVersionFromText(streamOutput);
            if (gdbVersion == null || gdbVersion.isEmpty()) {
                Exception detailedException = null;
                if (!streamOutput.isEmpty()) {
                    detailedException = new Exception("Unexpected output format: \n\n" + streamOutput);
                } else {
                    streamOutput = LaunchUtils.readStream(process.getErrorStream());
                    if (!streamOutput.isEmpty()) {
                        detailedException = new Exception(streamOutput);
                    }
                }
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Could not determine GDB version using command: " + StringUtil.join((String[])args, (String)" "), (Throwable)detailedException));
            }
            String string = gdbVersion;
            return string;
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Error with command: " + StringUtil.join((String[])args, (String)" "), (Throwable)e));
        }
        finally {
            if (timeoutJob != null) {
                timeoutJob.cancel();
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    private static String readStream(InputStream stream) throws IOException {
        String string;
        block8: {
            StringBuilder cmdOutput = new StringBuilder(200);
            try {
                String line;
                InputStreamReader r = new InputStreamReader(stream);
                BufferedReader reader = new BufferedReader(r);
                while ((line = reader.readLine()) != null) {
                    cmdOutput.append(line);
                    cmdOutput.append('\n');
                }
                string = cmdOutput.toString();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public static boolean getIsAttach(ILaunchConfiguration config) {
        String debugMode;
        block10: {
            block9: {
                block8: {
                    block7: {
                        try {
                            debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                            if (!debugMode.equals("run")) break block7;
                            return false;
                        }
                        catch (CoreException coreException) {}
                    }
                    if (!debugMode.equals("attach")) break block8;
                    return true;
                }
                if (!debugMode.equals("core")) break block9;
                return false;
            }
            if (!debugMode.equals("remote")) break block10;
            return false;
        }
        if (debugMode.equals("remote_attach")) {
            return true;
        }
        return false;
    }

    public static SessionType getSessionType(ILaunchConfiguration config) {
        try {
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (debugMode.equals("run")) {
                return SessionType.LOCAL;
            }
            if (debugMode.equals("attach")) {
                return SessionType.LOCAL;
            }
            if (debugMode.equals("core")) {
                return SessionType.CORE;
            }
            if (debugMode.equals("remote")) {
                return SessionType.REMOTE;
            }
            if (debugMode.equals("remote_attach")) {
                return SessionType.REMOTE;
            }
            assert (false) : "Unexpected session-type attribute in launch config: " + debugMode;
        }
        catch (CoreException coreException) {}
        return SessionType.LOCAL;
    }

    public static String[] getLaunchEnvironment(ILaunchConfiguration config) throws CoreException {
        ICdtVariable[] build_vars;
        IEnvironmentVariable[] vars;
        String projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        if (projectName == null) {
            return null;
        }
        if ((projectName = projectName.trim()).length() == 0) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.isAccessible()) {
            return null;
        }
        ICProjectDescription projDesc = CoreModel.getDefault().getProjectDescription(project, false);
        if (projDesc == null) {
            return null;
        }
        String buildConfigID = config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
        ICConfigurationDescription cfg = null;
        if (buildConfigID.length() != 0) {
            cfg = projDesc.getConfigurationById(buildConfigID);
        }
        if (cfg == null) {
            cfg = projDesc.getActiveConfiguration();
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        IEnvironmentVariable[] iEnvironmentVariableArray = vars = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(cfg, true);
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            envMap.put(var.getName(), var.getValue());
            ++n2;
        }
        ICdtVariable[] iCdtVariableArray = build_vars = CCorePlugin.getDefault().getCdtVariableManager().getVariables(cfg);
        int n3 = build_vars.length;
        n = 0;
        while (n < n3) {
            ICdtVariable var = iCdtVariableArray[n];
            try {
                if (!"project_classpath".equals(var.getName())) {
                    envMap.put(var.getName(), var.getStringValue());
                }
            }
            catch (CdtVariableException cdtVariableException) {}
            ++n;
        }
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        for (Map.Entry entry : envMap.entrySet()) {
            StringBuffer buffer = new StringBuffer((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static boolean getIsNonStopMode(ILaunchConfiguration config) {
        try {
            return config.getAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", LaunchUtils.getIsNonStopModeDefault());
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean getIsNonStopModeDefault() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.cdt.dsf.gdb", "defaultNonStop", false, null);
    }

    public static boolean getStopAtMainDefault() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.cdt.dsf.gdb", "defaultStopAtMain", true, null);
    }

    public static String getStopAtMainSymbolDefault() {
        return Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultStopAtMainSymbol", "main", null);
    }

    public static boolean getIsPostMortemTracing(ILaunchConfiguration config) {
        SessionType sessionType = LaunchUtils.getSessionType(config);
        if (sessionType == SessionType.CORE) {
            try {
                String coreType = config.getAttribute("org.eclipse.cdt.dsf.gdb.POST_MORTEM_TYPE", "CORE_FILE");
                return coreType.equals("TRACE_FILE");
            }
            catch (CoreException coreException) {}
        }
        return false;
    }
}

