/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.NullType;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ExtensionElement {
    protected IConfigurationElement m_element = null;

    public static List<ExtensionElement> wrapExtensionElements(IConfigurationElement[] elements) {
        int count = elements == null ? 0 : elements.length;
        ArrayList<ExtensionElement> result = new ArrayList<ExtensionElement>(count);
        int i = 0;
        while (i < count) {
            result.add(new ExtensionElement(elements[i]));
            ++i;
        }
        return result;
    }

    public ExtensionElement(IConfigurationElement element) {
        this.m_element = element;
    }

    public String getAttribute(String attributeName) {
        return this.m_element.getAttribute(attributeName);
    }

    public <T> T getClassAttribute() {
        return this.getClassAttribute("class");
    }

    public <T> T getClassAttribute(String attributeName) {
        Object result = null;
        try {
            result = this.m_element.createExecutableExtension(attributeName);
        }
        catch (ClassCastException classCastException) {
        }
        catch (CoreException coreException) {}
        return (T)result;
    }

    public <T> T getClassAttribute(String attributeName, Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return this.getClassAttribute(attributeName);
        }
        T result = null;
        try {
            String className = this.getAttribute(attributeName);
            IContributor contributor = this.m_element.getContributor();
            String pluginID = contributor.getName();
            Bundle plugin = Platform.getBundle((String)pluginID);
            Class instance = plugin.loadClass(className);
            int argumentsLength = arguments == null ? 0 : arguments.length;
            Class[] argumentTypes = new Class[argumentsLength];
            int i = 0;
            while (i < argumentsLength) {
                argumentTypes[i] = arguments[i] == null ? NullType.class : arguments[i].getClass();
                ++i;
            }
            Constructor constructor = instance.getConstructor(argumentTypes);
            result = constructor.newInstance(arguments);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (Exception exception) {}
        return result;
    }

    public List<ExtensionElement> getChildren() {
        return ExtensionElement.wrapExtensionElements(this.m_element.getChildren());
    }
}

