/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.formatter.scanner.Scanner;
import org.eclipse.cdt.internal.formatter.scanner.Token;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CElementHyperlink;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;

public class CElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, final IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof CEditor)) {
            return null;
        }
        IAction openAction = textEditor.getAction("OpenDeclarations");
        if (openAction == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(textEditor.getEditorInput());
        if (workingCopy == null) {
            return null;
        }
        final IRegion[] hyperlinkRegion = new IRegion[1];
        IStatus status = ASTProvider.getASTProvider().runOnAST((ICElement)workingCopy, ASTProvider.WAIT_NO, null, new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                if (ast == null) {
                    return Status.CANCEL_STATUS;
                }
                int offset = region.getOffset();
                int length = Math.max(1, region.getLength());
                IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
                Object linkASTNode = null;
                IASTFileLocation linkLocation = null;
                IASTName selectedName = nodeSelector.findEnclosingName(offset, length);
                if (selectedName != null) {
                    linkASTNode = selectedName.getParent() instanceof IASTPreprocessorIncludeStatement ? selectedName.getParent() : selectedName;
                } else {
                    IASTImplicitName implicit = nodeSelector.findEnclosingImplicitName(offset, length);
                    if (implicit != null) {
                        linkASTNode = implicit;
                    } else {
                        IASTNode cand = nodeSelector.findEnclosingNode(offset, length);
                        if (cand instanceof IASTPreprocessorIncludeStatement) {
                            linkASTNode = cand;
                        }
                    }
                }
                if (linkASTNode != null) {
                    IASTName astName;
                    IASTImageLocation imageLocation;
                    if (linkASTNode instanceof IASTName && (imageLocation = (astName = linkASTNode).getImageLocation()) != null) {
                        linkLocation = imageLocation;
                    }
                    if (linkLocation == null) {
                        linkLocation = linkASTNode.getFileLocation();
                    }
                }
                if (linkLocation == null) {
                    return Status.CANCEL_STATUS;
                }
                hyperlinkRegion[0] = new Region(linkLocation.getNodeOffset(), linkLocation.getNodeLength());
                return Status.OK_STATUS;
            }
        });
        if (status == Status.CANCEL_STATUS) {
            try {
                String partitionType = TextUtilities.getContentType((IDocument)document, (String)"___c_partitioning", (int)region.getOffset(), (boolean)false);
                if ("__dftl_partition_content_type".equals(partitionType)) {
                    hyperlinkRegion[0] = CElementHyperlinkDetector.getIdentifier(document, region.getOffset(), workingCopy.getLanguage());
                } else if ("__c_preprocessor".equals(partitionType)) {
                    Scanner scanner = new Scanner();
                    scanner.setSplitPreprocessor(true);
                    scanner.setSource(document.get().toCharArray());
                    scanner.setCurrentPosition(CElementHyperlinkDetector.findPreprocessorDirectiveStart(document, region.getOffset()));
                    Token token = scanner.nextToken();
                    if (token != null && token.getType() == 1004) {
                        int endPos = token.getOffset() + token.getLength();
                        while (Character.isWhitespace(document.getChar(--endPos))) {
                        }
                        if (region.getOffset() <= ++endPos) {
                            hyperlinkRegion[0] = new Region(token.getOffset(), endPos - token.getOffset());
                        }
                    } else {
                        hyperlinkRegion[0] = CElementHyperlinkDetector.getIdentifier(document, region.getOffset(), workingCopy.getLanguage());
                    }
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (CoreException coreException) {}
        }
        if (hyperlinkRegion[0] == null) {
            return null;
        }
        return new IHyperlink[]{new CElementHyperlink(hyperlinkRegion[0], openAction)};
    }

    private static IRegion getIdentifier(IDocument document, int offset, ILanguage language) throws BadLocationException {
        String word;
        IRegion wordRegion = CWordFinder.findWord(document, offset);
        if (wordRegion != null && wordRegion.getLength() > 0 && !Character.isDigit((word = document.get(wordRegion.getOffset(), wordRegion.getLength())).charAt(0)) && !CElementHyperlinkDetector.isLanguageKeyword(language, word)) {
            return wordRegion;
        }
        return null;
    }

    private static boolean isLanguageKeyword(ILanguage lang, String word) {
        ICLanguageKeywords keywords = (ICLanguageKeywords)lang.getAdapter(ICLanguageKeywords.class);
        if (keywords != null) {
            String keyword;
            String[] stringArray = keywords.getKeywords();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                keyword = stringArray[n2];
                if (keyword.equals(word)) {
                    return true;
                }
                ++n2;
            }
            stringArray = keywords.getBuiltinTypes();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (type.equals(word)) {
                    return true;
                }
                ++n2;
            }
            stringArray = keywords.getPreprocessorKeywords();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                keyword = stringArray[n2];
                if (keyword.charAt(0) == '#' && keyword.length() == word.length() + 1 && keyword.regionMatches(1, word, 0, word.length())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static int findPreprocessorDirectiveStart(IDocument document, int offset) throws BadLocationException {
        IRegion lineRegion;
        int lineOffset;
        while ((lineOffset = (lineRegion = document.getLineInformationOfOffset(offset)).getOffset()) != 0) {
            int lineEnd = lineOffset + lineRegion.getLength();
            offset = lineOffset;
            while (offset < lineEnd && Character.isWhitespace(document.getChar(offset))) {
                ++offset;
            }
            if (offset < document.getLength() && document.getChar(offset) == '#') {
                return lineOffset;
            }
            offset = lineOffset - 1;
        }
        return lineOffset;
    }
}

