/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.ui.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.CDTStatusInfo;
import org.eclipse.cdt.ui.newui.TypedCDTViewerFilter;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableManager;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.cdt.utils.ui.controls.IFileListChangeListener;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FileListControl {
    public static final int BROWSE_NONE = 0;
    public static final int BROWSE_FILE = 1;
    public static final int BROWSE_DIR = 2;
    private static final String WORKSPACELOC_VAR = "workspace_loc";
    private static final String PROJECTNAME_VAR = "ProjName";
    private static final IPath PROJECTNAME_PATH = new Path(VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("ProjName", null));
    private static final String WORKSPACEBUTTON_NAME = Messages.FileListControl_button_workspace;
    private static final String FILESYSTEMBUTTON_NAME = Messages.FileListControl_button_fs;
    private static final String ADD_STR = Messages.FileListControl_add;
    private static final String DEL_STR = Messages.FileListControl_delete;
    private static final String EDIT_STR = Messages.FileListControl_edit;
    private static final String MOVEUP_STR = Messages.FileListControl_moveup;
    private static final String MOVEDOWN_STR = Messages.FileListControl_movedown;
    private static final String FILE_TITLE_ADD = Messages.BrowseEntryDialog_file_title_add;
    private static final String DIR_TITLE_ADD = Messages.BrowseEntryDialog_dir_title_add;
    private static final String FILE_TITLE_EDIT = Messages.BrowseEntryDialog_file_title_edit;
    private static final String DIR_TITLE_EDIT = Messages.BrowseEntryDialog_dir_title_edit;
    private static final String WORKSPACE_DIR_DIALOG_TITLE = Messages.BrowseEntryDialog_wsp_dir_dlg_title;
    private static final String WORKSPACE_FILE_DIALOG_TITLE = Messages.BrowseEntryDialog_wsp_file_dlg_title;
    private static final String WORKSPACE_DIR_DIALOG_MSG = Messages.FileListControl_BrowseEntryDialog_wsp_dir_dlg_msg;
    private static final String WORKSPACE_FILE_DIALOG_MSG = Messages.FileListControl_BrowseEntryDialog_wsp_file_dlg_msg;
    private static final String WORKSPACE_FILE_DIALOG_ERR = Messages.FileListControl_BrowseEntryDialog_wsp_file_dlg_err;
    private static final String FILESYSTEM_DIR_DIALOG_MSG = Messages.BrowseEntryDialog_fs_dir_dlg_msg;
    private static final String FILE_MSG = Messages.BrowseEntryDialog_message_file;
    private static final String DIR_MSG = Messages.BrowseEntryDialog_message_directory;
    private static final String TITLE = Messages.BuildPropertyCommon_label_title;
    private boolean neverPromptForDelete;
    private boolean promptForDelete;
    private ToolBar toolBar;
    private ToolItem addItem;
    private ToolItem deleteItem;
    private ToolItem editItem;
    private ToolItem moveUpItem;
    private ToolItem moveDownItem;
    private Label title;
    private ClipboardList list;
    private String compTitle;
    private SelectionListener selectionListener;
    private GridData tgdata;
    private GridData grid3;
    private GridData grid4;
    private GridData grid2;
    private int browseType;
    private String filterPath;
    private String[] filterExtensions;
    private IPath path = new Path("");
    private boolean fWorkspaceSupport = false;
    private IVariableContextInfo contextInfo;
    IUndoContext undoContext;
    IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
    private List<IFileListChangeListener> listeners = new ArrayList<IFileListChangeListener>();
    private String[] oldValue;
    private final Image IMG_ADD = CDTSharedImages.getImage("icons/elcl16/list-add.gif");
    private final Image IMG_DEL = CDTSharedImages.getImage("icons/elcl16/list-delete.gif");
    private final Image IMG_EDIT = CDTSharedImages.getImage("icons/elcl16/list-edit.gif");
    private final Image IMG_MOVEUP = CDTSharedImages.getImage("icons/elcl16/list-moveup.gif");
    private final Image IMG_MOVEDOWN = CDTSharedImages.getImage("icons/elcl16/list-movedown.gif");

    public FileListControl(Composite parent, String compTitle, int type, boolean promptForDelete) {
        this(parent, compTitle, type);
        this.promptForDelete = promptForDelete;
        this.neverPromptForDelete = !promptForDelete;
    }

    public FileListControl(Composite parent, String compTitle, int type) {
        this.promptForDelete = type == 1 || type == 2;
        this.browseType = type;
        Composite filePanel = new Composite(parent, 0);
        GridLayout form1 = new GridLayout();
        form1.numColumns = 1;
        form1.horizontalSpacing = 0;
        form1.verticalSpacing = 0;
        form1.marginHeight = 0;
        form1.marginWidth = 0;
        filePanel.setLayout((Layout)form1);
        filePanel.setLayoutData((Object)new GridData(1808));
        Composite titlePanel = new Composite(filePanel, 2048);
        GridLayout titleform = new GridLayout(2, false);
        titleform.horizontalSpacing = 0;
        titleform.verticalSpacing = 0;
        titleform.marginHeight = 0;
        titleform.marginWidth = 0;
        titlePanel.setLayout((Layout)titleform);
        this.tgdata = new GridData(768);
        this.tgdata.heightHint = 25;
        titlePanel.setLayoutData((Object)this.tgdata);
        this.title = new Label(titlePanel, 1);
        this.compTitle = "  " + compTitle;
        this.title.setText(this.compTitle);
        this.grid2 = new GridData(768);
        this.title.setLayoutData((Object)this.grid2);
        Composite buttonPanel = new Composite(titlePanel, 0);
        GridLayout form2 = new GridLayout();
        form2.numColumns = 5;
        form2.horizontalSpacing = 0;
        form2.verticalSpacing = 0;
        form2.marginWidth = 0;
        form2.marginHeight = 0;
        buttonPanel.setLayout((Layout)form2);
        this.toolBar = new ToolBar(buttonPanel, 8519936);
        this.addItem = new ToolItem(this.toolBar, 8);
        this.addItem.setImage(this.IMG_ADD);
        this.addItem.setToolTipText(ADD_STR);
        this.addItem.addSelectionListener(this.getSelectionListener());
        this.deleteItem = new ToolItem(this.toolBar, 8);
        this.deleteItem.setImage(this.IMG_DEL);
        this.deleteItem.setToolTipText(DEL_STR);
        this.deleteItem.addSelectionListener(this.getSelectionListener());
        this.editItem = new ToolItem(this.toolBar, 8);
        this.editItem.setImage(this.IMG_EDIT);
        this.editItem.setToolTipText(EDIT_STR);
        this.editItem.addSelectionListener(this.getSelectionListener());
        this.moveUpItem = new ToolItem(this.toolBar, 8);
        this.moveUpItem.setImage(this.IMG_MOVEUP);
        this.moveUpItem.setToolTipText(MOVEUP_STR);
        this.moveUpItem.addSelectionListener(this.getSelectionListener());
        this.moveDownItem = new ToolItem(this.toolBar, 8);
        this.moveDownItem.setImage(this.IMG_MOVEDOWN);
        this.moveDownItem.setToolTipText(MOVEDOWN_STR);
        this.moveDownItem.addSelectionListener(this.getSelectionListener());
        this.grid3 = new GridData(896);
        buttonPanel.setLayoutData((Object)this.grid3);
        this.list = new ClipboardList(filePanel, 2818);
        this.grid4 = new GridData(1808);
        Point preferredSize = titlePanel.computeSize(-1, -1);
        this.grid4.widthHint = preferredSize.x;
        this.grid4.heightHint = preferredSize.y * 3;
        this.grid4.horizontalSpan = 2;
        this.list.setLayoutData(this.grid4);
        this.list.addSelectionListener(this.getSelectionListener());
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FileListControl.this.editSelection();
            }
        });
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 8: 
                    case 127: {
                        if (e.stateMask != 0) break;
                        FileListControl.this.removePressed();
                    }
                }
            }
        });
        this.undoContext = new ObjectUndoContext((Object)this);
        this.operationHistory.setLimit(this.undoContext, 50);
        try {
            IFocusService fs = (IFocusService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getService(IFocusService.class);
            fs.addFocusTracker((Control)this.list, "org.eclipse.cdt.ui.FileListControl");
        }
        catch (Exception e) {
            CUIPlugin.log(e);
        }
        this.selectionChanged();
    }

    public void setList(String[] listVal) {
        if (this.list != null) {
            this.list.removeAll();
        }
        String[] stringArray = listVal;
        int n = listVal.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.list.add(element);
            ++n2;
        }
        this.checkNotificationNeeded();
    }

    public void addChangeListener(IFileListChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(IFileListChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void checkNotificationNeeded() {
        Object[] items = this.getItems();
        if (this.oldValue != null) {
            if (Arrays.equals(this.oldValue, items)) {
                return;
            }
            AbstractOperation op = new AbstractOperation("", (String[])items){
                final String[] previousValue;
                final String[] newValue;
                {
                    this.previousValue = FileListControl.this.oldValue;
                    this.newValue = stringArray;
                }

                public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    FileListControl.this.list.setItems(this.previousValue);
                    FileListControl.this.notifyListeners(this.newValue, this.previousValue);
                    FileListControl.this.oldValue = this.previousValue;
                    return Status.OK_STATUS;
                }

                public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    FileListControl.this.list.setItems(this.newValue);
                    FileListControl.this.notifyListeners(this.previousValue, this.newValue);
                    FileListControl.this.oldValue = this.newValue;
                    return Status.OK_STATUS;
                }

                public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    return Status.CANCEL_STATUS;
                }
            };
            op.addContext(this.undoContext);
            this.operationHistory.add((IUndoableOperation)op);
            this.oldValue = new String[items.length];
            System.arraycopy(items, 0, this.oldValue, 0, items.length);
            this.notifyListeners(this.oldValue, (String[])items);
            this.list.setFocus();
        } else {
            this.oldValue = new String[items.length];
            System.arraycopy(items, 0, this.oldValue, 0, items.length);
        }
    }

    public void notifyListeners(String[] oldVal, String[] newVal) {
        for (IFileListChangeListener listener : this.listeners) {
            listener.fileListChanged(this, oldVal, newVal);
        }
    }

    public void setSelection(int sel) {
        if (this.list.getItemCount() > 0) {
            this.list.setSelection(sel);
        }
        this.selectionChanged();
    }

    public void setSelection() {
        if (this.list.getItemCount() > 0) {
            this.list.setSelection(0);
        }
    }

    public void removeAll() {
        if (this.list != null) {
            this.list.removeAll();
            this.checkNotificationNeeded();
        }
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    private void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == FileListControl.this.addItem) {
                    FileListControl.this.addPressed();
                } else if (widget == FileListControl.this.deleteItem) {
                    FileListControl.this.removePressed();
                } else if (widget == FileListControl.this.moveUpItem) {
                    FileListControl.this.upPressed();
                } else if (widget == FileListControl.this.moveDownItem) {
                    FileListControl.this.downPressed();
                } else if (widget == FileListControl.this.list) {
                    FileListControl.this.selectionChanged();
                } else if (widget == FileListControl.this.editItem) {
                    FileListControl.this.editSelection();
                }
            }
        };
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    private void addPressed() {
        String[] input = this.getNewInputObject();
        if (input.length > 0) {
            int index = this.list.getSelectionIndex();
            int i = 0;
            String[] stringArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.list.add(s, index + ++i);
                ++n2;
            }
            this.list.setSelection(index + 1);
            this.checkNotificationNeeded();
        }
        this.selectionChanged();
    }

    private void removePressed() {
        if (this.list.getSelectionCount() == 0 || this.list.getSelectionIndex() == -1) {
            return;
        }
        boolean delDir = true;
        if (this.promptForDelete) {
            String quest = Messages.FileListControl_deletedialog_message;
            String title = Messages.FileListControl_deletedialog_title;
            delDir = MessageDialog.openQuestion((Shell)this.list.getShell(), (String)title, (String)quest);
        }
        if (delDir) {
            int i;
            while ((i = this.list.getSelectionIndex()) != -1) {
                this.list.remove(i);
            }
            this.checkNotificationNeeded();
        }
        this.selectionChanged();
    }

    private void upPressed() {
        int index = this.list.getSelectionIndex();
        String curSelList = this.list.getItem(index);
        String preList = this.list.getItem(index - 1);
        this.list.setItem(index - 1, curSelList);
        this.list.setItem(index, preList);
        this.list.setSelection(index - 1);
        this.checkNotificationNeeded();
        this.selectionChanged();
    }

    private void downPressed() {
        int index = this.list.getSelectionIndex();
        String curSelList = this.list.getItem(index);
        String nextList = this.list.getItem(index + 1);
        this.list.setItem(index + 1, curSelList);
        this.list.setItem(index, nextList);
        this.list.setSelection(index + 1);
        this.checkNotificationNeeded();
        this.selectionChanged();
    }

    private void editSelection() {
        String selItem;
        int index = this.list.getSelectionIndex();
        if (index != -1 && (selItem = this.list.getItem(index)) != null) {
            InputDialog dialog;
            String title;
            if (this.browseType == 2 || this.browseType == 1) {
                String message;
                if (this.browseType == 2) {
                    title = DIR_TITLE_EDIT;
                    message = DIR_MSG;
                } else {
                    title = FILE_TITLE_EDIT;
                    message = FILE_MSG;
                }
                dialog = new SelectPathInputDialog(this.getListControl().getShell(), title, message, selItem, null, this.browseType);
            } else {
                title = Messages.FileListControl_editdialog_title;
                dialog = new InputDialog(null, title, this.compTitle, selItem, null);
            }
            if (dialog.open() == 0) {
                String[] newItems;
                if (dialog instanceof SelectPathInputDialog) {
                    SelectPathInputDialog selDialog = (SelectPathInputDialog)dialog;
                    newItems = selDialog.getValues();
                    if (selDialog.isValueSetByBrowse()) {
                        int i = 0;
                        while (i < newItems.length) {
                            newItems[i] = this.doubleQuotePath(newItems[i]);
                            ++i;
                        }
                    }
                } else {
                    newItems = new String[]{dialog.getValue()};
                }
                if (newItems.length == 1 && newItems[0].equals(selItem)) {
                    return;
                }
                this.list.setItem(index, newItems[0]);
                int i = 1;
                while (i < newItems.length) {
                    this.list.add(newItems[i], index + i);
                    ++i;
                }
                this.checkNotificationNeeded();
                this.selectionChanged();
            }
        }
    }

    public void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        int selectionCount = this.list.getSelectionCount();
        this.deleteItem.setEnabled(size > 0);
        this.moveUpItem.setEnabled(size > 1 && index > 0 && selectionCount == 1);
        this.moveDownItem.setEnabled(size > 1 && index >= 0 && index < size - 1 && selectionCount == 1);
        this.editItem.setEnabled(selectionCount == 1);
    }

    public org.eclipse.swt.widgets.List getListControl() {
        return this.list;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    @Deprecated
    public void setType(int type) {
        this.browseType = type;
        if (!this.neverPromptForDelete) {
            this.promptForDelete = type == 1 || type == 2;
        }
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    public void setWorkspaceSupport(boolean enable) {
        this.fWorkspaceSupport = enable;
    }

    public void setContext(IVariableContextInfo info) {
        this.contextInfo = info;
        while (info != null) {
            info = info.getNext();
        }
    }

    private String[] getNewInputObject() {
        String[] input = new String[]{};
        String title = "";
        String message = "";
        String initVal = "";
        if (this.browseType == 2) {
            title = DIR_TITLE_ADD;
            message = DIR_MSG;
            initVal = this.path.toString();
        } else if (this.browseType == 1) {
            title = FILE_TITLE_ADD;
            message = FILE_MSG;
            initVal = this.path.toString();
        } else {
            title = TITLE;
            message = this.compTitle;
        }
        SelectPathInputDialog dialog = new SelectPathInputDialog(this.getListControl().getShell(), title, message, initVal, null, this.browseType);
        if (dialog.open() == 0 && (input = dialog.getValues()).length > 0 && (this.browseType == 2 || this.browseType == 1)) {
            int i = 0;
            while (i < input.length) {
                input[i] = this.doubleQuotePath(input[i]);
                ++i;
            }
        }
        return input;
    }

    public Label getLabelControl() {
        return this.title;
    }

    public void setEnabled(boolean enabled) {
        this.title.setEnabled(enabled);
        this.toolBar.setEnabled(enabled);
        this.list.setEnabled(enabled);
    }

    private String doubleQuotePath(String pathName) {
        pathName = pathName.trim();
        boolean bStartsWithQuote = pathName.startsWith("\"");
        boolean bEndsWithQuote = pathName.endsWith("\"");
        int i = pathName.indexOf(" ") + pathName.indexOf("\\") + pathName.indexOf("${");
        if (i != -3) {
            if (!bStartsWithQuote) {
                pathName = "\"" + pathName;
            }
            if (!bEndsWithQuote) {
                pathName = String.valueOf(pathName) + "\"";
            }
        }
        return pathName;
    }

    public final class ClipboardList
    extends org.eclipse.swt.widgets.List {
        private Clipboard clipboard;

        public ClipboardList(Composite parent, int style) {
            super(parent, style);
        }

        private String[] getClipboardContents() {
            Clipboard cp = this.getClipboard();
            String contents = (String)cp.getContents((Transfer)TextTransfer.getInstance());
            if (contents != null) {
                String[] arr = contents.split("\n");
                return arr;
            }
            return new String[0];
        }

        public void copy() {
            String[] toCopy = this.getSelection();
            if (toCopy != null && toCopy.length > 0) {
                StringBuilder sb = new StringBuilder();
                String[] stringArray = toCopy;
                int n = toCopy.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    sb.append(item.trim()).append("\n");
                    ++n2;
                }
                Clipboard cp = this.getClipboard();
                cp.setContents(new Object[]{sb.toString().trim()}, new Transfer[]{TextTransfer.getInstance()});
            }
        }

        public void cut() {
            this.copy();
            if (Arrays.equals(this.getClipboardContents(), this.getSelection())) {
                FileListControl.this.removePressed();
            }
        }

        public void paste() {
            String[] pasteBuffer = this.getClipboardContents();
            int i = this.getSelectionIndex();
            String[] stringArray = pasteBuffer;
            int n = pasteBuffer.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (!item.trim().equals("")) {
                    this.add(item.trim(), ++i);
                }
                ++n2;
            }
            FileListControl.this.checkNotificationNeeded();
        }

        public void undo() {
            try {
                FileListControl.this.operationHistory.undo(FileListControl.this.undoContext, null, null);
            }
            catch (ExecutionException e) {
                CUIPlugin.log(e);
            }
        }

        public void redo() {
            try {
                FileListControl.this.operationHistory.redo(FileListControl.this.undoContext, null, null);
            }
            catch (ExecutionException e) {
                CUIPlugin.log(e);
            }
        }

        private Clipboard getClipboard() {
            if (this.clipboard == null) {
                this.clipboard = new Clipboard(Display.getDefault());
            }
            return this.clipboard;
        }

        public void dispose() {
            super.dispose();
            if (this.clipboard != null) {
                this.clipboard.dispose();
            }
        }

        public void delete() {
            FileListControl.this.removePressed();
        }

        protected void checkSubclass() {
        }
    }

    class SelectPathInputDialog
    extends InputDialog {
        private String[] values;
        private int type;
        private boolean fSetByBrowseDialog;

        public SelectPathInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, int browseType) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
            this.values = new String[0];
            this.fSetByBrowseDialog = false;
            this.type = browseType;
        }

        private String getInitialValue(String initialValue) {
            IDialogSettings dialogSettings = CUIPlugin.getDefault().getDialogSettings();
            String sfile = dialogSettings.get(FileListControl.class.getName());
            if (sfile != null && (initialValue == null || initialValue.isEmpty())) {
                return sfile;
            }
            return initialValue;
        }

        protected void saveWidgetValues() {
            IDialogSettings dialogSettings = CUIPlugin.getDefault().getDialogSettings();
            dialogSettings.put(FileListControl.class.getName(), this.getValue());
        }

        public boolean close() {
            this.saveWidgetValues();
            return super.close();
        }

        protected Control createContents(Composite parent) {
            Control area = super.createContents(parent);
            this.getText().setText(this.getInitialValue(this.getValue()));
            return area;
        }

        public boolean isValueSetByBrowse() {
            return this.fSetByBrowseDialog;
        }

        public String[] getValues() {
            if (this.values.length <= 1) {
                return new String[]{this.getValue()};
            }
            return this.values;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            if ((this.type == 2 || this.type == 1) && FileListControl.this.fWorkspaceSupport) {
                Button workspaceButton = this.createButton(parent, 3, WORKSPACEBUTTON_NAME, false);
                workspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent ev) {
                        String currentPathText = SelectPathInputDialog.this.getText().getText();
                        currentPathText = currentPathText.replaceAll("\"", "");
                        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
                        IProject project = null;
                        if (FileListControl.this.contextInfo != null) {
                            try {
                                ICdtVariable var = SupplierBasedCdtVariableManager.getVariable((String)FileListControl.PROJECTNAME_VAR, (IVariableContextInfo)FileListControl.this.contextInfo, (boolean)true);
                                if (var != null && var.getValueType() == 1) {
                                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(var.getStringValue());
                                }
                                SupplierBasedCdtVariableSubstitutor varSubs = new SupplierBasedCdtVariableSubstitutor(FileListControl.this.contextInfo, "", "");
                                currentPathText = CdtVariableResolver.resolveToString((String)currentPathText, (IVariableSubstitutor)varSubs);
                            }
                            catch (CdtVariableException cdtVariableException) {}
                        } else {
                            try {
                                currentPathText = variableManager.performStringSubstitution(currentPathText, false);
                            }
                            catch (CoreException coreException) {}
                        }
                        Object resource = null;
                        if (!currentPathText.isEmpty()) {
                            IContainer[] rs = null;
                            try {
                                rs = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(URIUtil.toURI((String)currentPathText));
                            }
                            catch (Exception exception) {}
                            resource = rs == null || rs.length == 0 ? ResourceLookup.selectFileForLocation((IPath)new Path(currentPathText), null) : rs[0];
                        }
                        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(SelectPathInputDialog.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                        if (SelectPathInputDialog.this.type == 2) {
                            dialog.setInitialSelection(resource);
                            Class[] filteredResources = new Class[]{IContainer.class, IProject.class};
                            dialog.addFilter((ViewerFilter)new TypedCDTViewerFilter(filteredResources));
                            dialog.setTitle(WORKSPACE_DIR_DIALOG_TITLE);
                            dialog.setMessage(WORKSPACE_DIR_DIALOG_MSG);
                        } else {
                            dialog.setInitialSelection(resource);
                            dialog.setValidator(new ISelectionStatusValidator(){

                                public IStatus validate(Object[] selection) {
                                    if (selection != null) {
                                        Object[] objectArray = selection;
                                        int n = selection.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            Object sel = objectArray[n2];
                                            if (!(sel instanceof IFile)) {
                                                return new CDTStatusInfo(4, WORKSPACE_FILE_DIALOG_ERR);
                                            }
                                            ++n2;
                                        }
                                    }
                                    return new CDTStatusInfo();
                                }
                            });
                            dialog.setTitle(WORKSPACE_FILE_DIALOG_TITLE);
                            dialog.setMessage(WORKSPACE_FILE_DIALOG_MSG);
                        }
                        if (dialog.open() == 0) {
                            SelectPathInputDialog.this.fSetByBrowseDialog = true;
                            Object[] rs = dialog.getResult();
                            if (rs != null) {
                                int i = 0;
                                SelectPathInputDialog.this.values = new String[rs.length];
                                Object[] objectArray = rs;
                                int n = rs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object o = objectArray[n2];
                                    resource = (IResource)o;
                                    ((SelectPathInputDialog)SelectPathInputDialog.this).values[i++] = resource.getProject().equals((Object)project) ? variableManager.generateVariableExpression(FileListControl.WORKSPACELOC_VAR, PROJECTNAME_PATH.append(resource.getProjectRelativePath()).makeAbsolute().toString()) : variableManager.generateVariableExpression(FileListControl.WORKSPACELOC_VAR, resource.getFullPath().toString());
                                    ++n2;
                                }
                                if (SelectPathInputDialog.this.values.length == 1) {
                                    SelectPathInputDialog.this.getText().setText(SelectPathInputDialog.this.values[0]);
                                } else {
                                    SelectPathInputDialog.this.buttonPressed(0);
                                }
                            }
                        }
                    }
                });
            }
            if (this.type != 0) {
                Button externalButton = this.createButton(parent, 4, FILESYSTEMBUTTON_NAME, false);
                externalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent ev) {
                        switch (SelectPathInputDialog.this.type) {
                            case 2: {
                                DirectoryDialog dialog = new DirectoryDialog(SelectPathInputDialog.this.getParentShell(), 69632);
                                String currentName = SelectPathInputDialog.this.getText().getText();
                                if (currentName != null && currentName.trim().length() != 0) {
                                    dialog.setFilterPath(currentName);
                                } else if (FileListControl.this.filterPath != null) {
                                    dialog.setFilterPath(FileListControl.this.filterPath);
                                }
                                dialog.setMessage(FILESYSTEM_DIR_DIALOG_MSG);
                                String result = dialog.open();
                                if (result == null) break;
                                SelectPathInputDialog.this.fSetByBrowseDialog = true;
                                SelectPathInputDialog.this.getText().setText(result);
                                break;
                            }
                            case 1: {
                                String result;
                                FileDialog browseDialog = new FileDialog(SelectPathInputDialog.this.getParentShell());
                                String currentName = SelectPathInputDialog.this.getText().getText();
                                if (currentName != null && currentName.trim().length() != 0) {
                                    browseDialog.setFilterPath(currentName);
                                } else if (FileListControl.this.filterPath != null) {
                                    browseDialog.setFilterPath(FileListControl.this.filterPath);
                                }
                                if (FileListControl.this.filterExtensions != null) {
                                    browseDialog.setFilterExtensions(FileListControl.this.filterExtensions);
                                }
                                if ((result = browseDialog.open()) == null) break;
                                SelectPathInputDialog.this.fSetByBrowseDialog = true;
                                SelectPathInputDialog.this.getText().setText(result);
                            }
                        }
                    }
                });
            }
        }
    }
}

