/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.elements.adapters;

import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.DebugElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class CVariableLabelProvider
extends DebugElementLabelProvider {
    protected String getLabel(TreePath elementPath, IPresentationContext context, String columnId) throws CoreException {
        if (columnId != null) {
            IVariable variable = (IVariable)elementPath.getLastSegment();
            IValue value = variable.getValue();
            return this.getColumnText(variable, value, context, columnId);
        }
        return super.getLabel(elementPath, context, columnId);
    }

    protected String getValueText(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        if (value instanceof ICValue) {
            return CDebugUIUtils.getValueText(value);
        }
        return null;
    }

    protected String getVariableTypeName(IVariable variable, IPresentationContext context) throws CoreException {
        if (variable instanceof ICVariable) {
            return CDebugUIUtils.getVariableTypeName(((ICVariable)variable).getType());
        }
        return null;
    }

    protected String getVariableName(IVariable variable, IPresentationContext context) throws CoreException {
        return CDebugUIUtils.getVariableName(variable);
    }

    protected String getColumnText(IVariable variable, IValue value, IPresentationContext context, String columnId) throws CoreException {
        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(columnId)) {
            return this.getVariableName(variable, context);
        }
        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_TYPE".equals(columnId)) {
            return this.getVariableTypeName(variable, context);
        }
        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_VALUE".equals(columnId)) {
            return this.getValueText(variable, value, context);
        }
        return null;
    }

    protected ImageDescriptor getImageDescriptor(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        if (columnId == null || "org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(columnId)) {
            return super.getImageDescriptor(elementPath, presentationContext, columnId);
        }
        return null;
    }

    protected RGB getBackground(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        IVariable variable;
        Object element = elementPath.getLastSegment();
        if (columnId != null && element instanceof IVariable && (variable = (IVariable)element).hasValueChanged()) {
            return DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB();
        }
        return super.getBackground(elementPath, presentationContext, columnId);
    }

    protected FontData getFontData(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        return JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0];
    }

    protected RGB getForeground(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        IVariable variable;
        Object element = elementPath.getLastSegment();
        if (columnId == null && element instanceof IVariable && (variable = (IVariable)element).hasValueChanged()) {
            return DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.changedDebugElement").getRGB();
        }
        return super.getForeground(elementPath, presentationContext, columnId);
    }
}

