/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownTypeScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPTemplateTemplateParameter
extends CPPTemplateParameter
implements ICPPTemplateTemplateParameter,
ICPPInternalTemplate,
ICPPUnknownBinding,
ICPPUnknownType {
    private ICPPTemplateParameter[] templateParameters;
    private ObjectMap instances;
    private ICPPScope unknownScope;
    private final boolean fIsParameterPack;

    public CPPTemplateTemplateParameter(IASTName name, boolean isPack) {
        super(name);
        this.fIsParameterPack = isPack;
    }

    @Override
    public final boolean isParameterPack() {
        return this.fIsParameterPack;
    }

    @Override
    public ICPPScope asScope() {
        if (this.unknownScope == null) {
            IASTName n = null;
            IASTName[] nodes = this.getDeclarations();
            if (nodes != null && nodes.length > 0) {
                n = nodes[0];
            }
            this.unknownScope = new CPPUnknownTypeScope(this, n);
        }
        return this.unknownScope;
    }

    @Override
    public ICPPTemplateParameter[] getTemplateParameters() {
        if (this.templateParameters == null) {
            ICPPASTTemplatedTypeTemplateParameter template = (ICPPASTTemplatedTypeTemplateParameter)this.getPrimaryDeclaration().getParent();
            ICPPASTTemplateParameter[] params = template.getTemplateParameters();
            ICPPTemplateParameter[] result = ICPPTemplateParameter.EMPTY_TEMPLATE_PARAMETER_ARRAY;
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter param = iCPPASTTemplateParameterArray[n2];
                IBinding binding = CPPTemplates.getTemplateParameterName(param).resolvePreBinding();
                if (binding instanceof ICPPTemplateParameter) {
                    result = ArrayUtil.append(result, (ICPPTemplateParameter)binding);
                }
                ++n2;
            }
            this.templateParameters = ArrayUtil.trim(result);
        }
        return this.templateParameters;
    }

    @Override
    public IBinding resolveTemplateParameter(ICPPTemplateParameter templateParameter) {
        return templateParameter;
    }

    @Override
    public IType getDefault() {
        IASTName[] nds = this.getDeclarations();
        if (nds == null || nds.length == 0) {
            return null;
        }
        IASTName[] iASTNameArray = nds;
        int n = nds.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName nd = iASTNameArray[n2];
            if (nd != null) {
                IASTName name;
                IBinding b;
                ICPPASTTemplatedTypeTemplateParameter param;
                IASTExpression value;
                IASTNode parent = nd.getParent();
                assert (parent instanceof ICPPASTTemplatedTypeTemplateParameter);
                if (parent instanceof ICPPASTTemplatedTypeTemplateParameter && (value = (param = (ICPPASTTemplatedTypeTemplateParameter)parent).getDefaultValue()) instanceof IASTIdExpression && (b = (name = ((IASTIdExpression)value).getName()).resolveBinding()) instanceof IType) {
                    return (IType)((Object)b);
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public ICPPTemplateArgument getDefaultValue() {
        IType d = this.getDefault();
        if (d == null) {
            return null;
        }
        return new CPPTemplateTypeArgument(d);
    }

    @Override
    public ICPPBase[] getBases() {
        return ICPPBase.EMPTY_BASE_ARRAY;
    }

    @Override
    public IField[] getFields() {
        return IField.EMPTY_FIELD_ARRAY;
    }

    @Override
    public IField findField(String name) {
        return null;
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    @Override
    public ICPPMethod[] getMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
    }

    @Override
    public IBinding[] getFriends() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        return ICPPClassType.EMPTY_CLASS_ARRAY;
    }

    @Override
    public int getKey() {
        return 0;
    }

    @Override
    public IScope getCompositeScope() {
        return null;
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (!(type instanceof ICPPTemplateTemplateParameter)) {
            return false;
        }
        return this.getParameterID() == ((ICPPTemplateParameter)((Object)type)).getParameterID();
    }

    @Override
    public ICPPClassTemplatePartialSpecialization[] getPartialSpecializations() {
        return ICPPClassTemplatePartialSpecialization.EMPTY_PARTIAL_SPECIALIZATION_ARRAY;
    }

    @Override
    public final void addInstance(ICPPTemplateArgument[] arguments, ICPPTemplateInstance instance) {
        if (this.instances == null) {
            this.instances = new ObjectMap(2);
        }
        String key = ASTTypeUtil.getArgumentListString(arguments, true);
        this.instances.put(key, instance);
    }

    @Override
    public final ICPPTemplateInstance getInstance(ICPPTemplateArgument[] arguments) {
        if (this.instances != null) {
            String key = ASTTypeUtil.getArgumentListString(arguments, true);
            return (ICPPTemplateInstance)this.instances.get(key);
        }
        return null;
    }

    @Override
    public ICPPTemplateInstance[] getAllInstances() {
        if (this.instances != null) {
            ICPPTemplateInstance[] result = new ICPPTemplateInstance[this.instances.size()];
            int i = 0;
            while (i < this.instances.size()) {
                result[i] = (ICPPTemplateInstance)this.instances.getAt(i);
                ++i;
            }
            return result;
        }
        return ICPPTemplateInstance.EMPTY_TEMPLATE_INSTANCE_ARRAY;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public ICPPDeferredClassInstance asDeferredInstance() {
        return null;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public int getVisibility(IBinding member) {
        throw new IllegalArgumentException(String.valueOf(member.getName()) + " is not a member of " + this.getName());
    }
}

