/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTypeSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.core.runtime.CoreException;

public class EvalFixed
extends CPPEvaluation {
    public static final ICPPEvaluation INCOMPLETE = new EvalFixed(ProblemType.UNKNOWN_FOR_EXPRESSION, IASTExpression.ValueCategory.PRVALUE, Value.UNKNOWN);
    private final IType fType;
    private final IValue fValue;
    private final IASTExpression.ValueCategory fValueCategory;
    private boolean fIsTypeDependent;
    private boolean fCheckedIsTypeDependent;
    private boolean fIsValueDependent;
    private boolean fCheckedIsValueDependent;

    public EvalFixed(IType type, IASTExpression.ValueCategory cat, IValue value) {
        Long num;
        if (type instanceof CPPBasicType && (num = value.numericalValue()) != null) {
            CPPBasicType t = (CPPBasicType)type.clone();
            t.setAssociatedNumericalValue(num);
            type = t;
        }
        this.fType = type;
        this.fValueCategory = cat;
        this.fValue = value;
    }

    public IType getType() {
        return this.fType;
    }

    public IValue getValue() {
        return this.fValue;
    }

    public IASTExpression.ValueCategory getValueCategory() {
        return this.fValueCategory;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (!this.fCheckedIsTypeDependent) {
            this.fCheckedIsTypeDependent = true;
            this.fIsTypeDependent = CPPTemplates.isDependentType(this.fType);
        }
        return this.fIsTypeDependent;
    }

    @Override
    public boolean isValueDependent() {
        if (!this.fCheckedIsValueDependent) {
            this.fCheckedIsValueDependent = true;
            this.fIsValueDependent = Value.isDependentValue(this.fValue);
        }
        return this.fIsValueDependent;
    }

    @Override
    public boolean isConstantExpression(IASTNode point) {
        return EvalFixed.isConstexprValue(this.fValue, point);
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        return this.fType;
    }

    @Override
    public IValue getValue(IASTNode point) {
        return this.fValue;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return this.fValueCategory;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        includeValue = includeValue && this.fValue != Value.UNKNOWN;
        short firstBytes = 7;
        if (includeValue) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        switch (this.fValueCategory) {
            case PRVALUE: {
                firstBytes = (short)(firstBytes | 0x40);
                break;
            }
            case LVALUE: {
                firstBytes = (short)(firstBytes | 0x80);
                break;
            }
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.fType);
        if (includeValue) {
            buffer.marshalValue(this.fValue);
        }
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IASTExpression.ValueCategory cat;
        boolean readValue = (firstBytes & 0x20) != 0;
        switch (firstBytes & 0xC0) {
            case 64: {
                cat = IASTExpression.ValueCategory.PRVALUE;
                break;
            }
            case 128: {
                cat = IASTExpression.ValueCategory.LVALUE;
                break;
            }
            default: {
                cat = IASTExpression.ValueCategory.XVALUE;
            }
        }
        IType type = buffer.unmarshalType();
        IValue value = readValue ? buffer.unmarshalValue() : Value.UNKNOWN;
        return new EvalFixed(type, cat, value);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPTypeSpecialization within, int maxdepth, IASTNode point) {
        IType type = CPPTemplates.instantiateType(this.fType, tpMap, packOffset, within, point);
        IValue value = CPPTemplates.instantiateValue(this.fValue, tpMap, packOffset, within, maxdepth, point);
        if (type == this.fType && value == this.fValue) {
            return this;
        }
        return new EvalFixed(type, this.fValueCategory, value);
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation eval = this.fValue.getEvaluation();
        if (eval == null) {
            return this;
        }
        if ((eval = eval.computeForFunctionCall(parameterMap, context.recordStep())) == this.fValue.getEvaluation()) {
            return this;
        }
        return new EvalFixed(this.fType, this.fValueCategory, Value.create(eval));
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return CPPTemplates.determinePackSize(this.fValue, tpMap);
    }

    @Override
    public boolean referencesTemplateParameter() {
        return false;
    }
}

