/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.widgets;

import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.cdt.codan.internal.ui.widgets.FileScopeComposite;
import org.eclipse.cdt.codan.internal.ui.widgets.LaunchingTabComposite;
import org.eclipse.cdt.codan.internal.ui.widgets.ParametersComposite;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class CustomizeProblemComposite
extends Composite {
    private Composite parametersTab;
    private IProblem problem;
    private ParametersComposite problemsComposite;
    private FileScopeComposite scopeComposite;
    private IResource resource;
    private LaunchingTabComposite launchingComposite;

    public CustomizeProblemComposite(Composite parent, IProblem selectedProblem, IResource resource) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, false));
        this.problem = selectedProblem;
        this.resource = resource;
        TabFolder tabFolder = new TabFolder((Composite)this, 128);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createParamtersTab(tabFolder);
        this.createScopeTab(tabFolder);
        this.createLaunchingTab(tabFolder);
    }

    public void save(IProblemWorkingCopy problem) {
        this.problemsComposite.save(problem);
        this.scopeComposite.save(problem);
        this.launchingComposite.save(problem);
    }

    private void createParamtersTab(TabFolder tabFolder) {
        TabItem tabItem1 = new TabItem(tabFolder, 0);
        tabItem1.setText(CodanUIMessages.CustomizeProblemComposite_TabParameters);
        this.parametersTab = new Composite((Composite)tabFolder, 0);
        tabItem1.setControl((Control)this.parametersTab);
        this.parametersTab.setLayout((Layout)new GridLayout());
        this.problemsComposite = new ParametersComposite(this.parametersTab, this.problem);
        this.problemsComposite.setLayoutData(new GridData(1, 1, true, false));
    }

    private void createScopeTab(TabFolder tabFolder) {
        TabItem tabItem1 = new TabItem(tabFolder, 0);
        tabItem1.setText(CodanUIMessages.CustomizeProblemComposite_TabScope);
        Composite comp = new Composite((Composite)tabFolder, 0);
        tabItem1.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        this.scopeComposite = new FileScopeComposite(comp, this.problem, this.resource);
        this.scopeComposite.setLayoutData(new GridData(1, 1, true, false));
    }

    private void createLaunchingTab(TabFolder tabFolder) {
        TabItem tabItem1 = new TabItem(tabFolder, 0);
        tabItem1.setText(CodanUIMessages.CustomizeProblemComposite_LaunchingTab);
        Composite comp = new Composite((Composite)tabFolder, 0);
        tabItem1.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        this.launchingComposite = new LaunchingTabComposite(comp, this.problem, this.resource);
        this.launchingComposite.setLayoutData(new GridData(1, 1, true, false));
    }
}

