/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.xlc;

import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.lrparser.IParser;
import org.eclipse.cdt.core.dom.lrparser.gnu.GPPLanguage;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.lrparser.xlc.XlcCPPScannerExtensionConfiguration;
import org.eclipse.cdt.core.lrparser.xlc.XlcCPPTokenMap;
import org.eclipse.cdt.core.lrparser.xlc.XlcKeywords;
import org.eclipse.cdt.core.lrparser.xlc.preferences.XlcLanguagePreferences;
import org.eclipse.cdt.core.lrparser.xlc.preferences.XlcPref;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.internal.core.lrparser.xlc.cpp.XlcCPPParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class XlcCPPLanguage
extends GPPLanguage {
    public static final String ID = "org.eclipse.cdt.core.lrparser.xlc.cpp";
    private static XlcCPPLanguage DEFAULT = new XlcCPPLanguage();

    public static XlcCPPLanguage getDefault() {
        return DEFAULT;
    }

    static IProject getProject(Map<String, String> properties) {
        String path = properties.get("org.eclipse.cdt.core.dom.lrparser.translationUnitPath");
        IFile[] file = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(path));
        IProject project = null;
        if (file != null && file.length > 0) {
            project = file[0].getProject();
        }
        return project;
    }

    static boolean getPref(XlcPref key, IProject project) {
        return Boolean.valueOf(XlcLanguagePreferences.get(key, project));
    }

    protected IParser<IASTTranslationUnit> getParser(IScanner scanner, IIndex index, Map<String, String> properties) {
        IProject project = XlcCPPLanguage.getProject(properties);
        boolean supportVectors = XlcCPPLanguage.getPref(XlcPref.SUPPORT_VECTOR_TYPES, project);
        boolean supportDecimals = XlcCPPLanguage.getPref(XlcPref.SUPPORT_DECIMAL_FLOATING_POINT_TYPES, project);
        boolean supportComplex = XlcCPPLanguage.getPref(XlcPref.SUPPORT_COMPLEX_IN_CPP, project);
        boolean supportRestrict = XlcCPPLanguage.getPref(XlcPref.SUPPORT_RESTRICT_IN_CPP, project);
        boolean supportStaticAssert = XlcCPPLanguage.getPref(XlcPref.SUPPORT_STATIC_ASSERT, project);
        XlcCPPTokenMap tokenMap = new XlcCPPTokenMap(supportVectors, supportDecimals, supportComplex, supportRestrict, supportStaticAssert);
        XlcCPPParser parser = new XlcCPPParser(scanner, tokenMap, this.getBuiltinBindingsProvider(), index, properties);
        return parser;
    }

    public String getId() {
        return ID;
    }

    protected IScannerExtensionConfiguration getScannerExtensionConfiguration() {
        return XlcCPPScannerExtensionConfiguration.getInstance();
    }

    public Object getAdapter(Class adapter) {
        if (ICLanguageKeywords.class.equals((Object)adapter)) {
            return XlcKeywords.ALL_CPP_KEYWORDS;
        }
        return super.getAdapter(adapter);
    }

    public static /* bridge */ /* synthetic */ GPPLanguage getDefault() {
        return XlcCPPLanguage.getDefault();
    }
}

