/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django.ui.wizards.project;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.ast.runners.UniversalRunner;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.django.DjangoPlugin;
import org.python.pydev.django.nature.DjangoNature;
import org.python.pydev.django.ui.wizards.project.DjangoNewProjectPage;
import org.python.pydev.django.ui.wizards.project.DjangoSettingsPage;
import org.python.pydev.plugin.PyStructureConfigHelpers;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.wizards.project.IWizardNewProjectNameAndLocationPage;
import org.python.pydev.ui.wizards.project.PythonProjectWizard;

public class DjangoProjectWizard
extends PythonProjectWizard {
    public static final String WIZARD_ID = "org.python.pydev.ui.wizards.project.DjangoProjectWizard";
    protected DjangoSettingsPage settingsPage = this.createDjangoSettingsPage(new ICallback0<IWizardNewProjectNameAndLocationPage>(){

        public IWizardNewProjectNameAndLocationPage call() {
            return DjangoProjectWizard.this.projectPage;
        }
    });
    protected static final String RUN_DJANGO_ADMIN = "from django.core import management;management.execute_from_command_line();";

    protected IWizardNewProjectNameAndLocationPage createProjectPage() {
        return new DjangoNewProjectPage("Setting project properties");
    }

    protected DjangoSettingsPage createDjangoSettingsPage(ICallback0<IWizardNewProjectNameAndLocationPage> projectPage) {
        return new DjangoSettingsPage("Django Settings", projectPage);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.settingsPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAndConfigProject(IProject projectHandle, IProjectDescription description, String projectType, String projectInterpreter, IProgressMonitor monitor, Object ... additionalArgsToConfigProject) throws CoreException {
        Assert.isTrue((additionalArgsToConfigProject.length == 1 ? 1 : 0) != 0);
        final DjangoSettingsPage.DjangoSettings djSettings = (DjangoSettingsPage.DjangoSettings)additionalArgsToConfigProject[0];
        final int sourceFolderConfigurationStyle = this.projectPage.getSourceFolderConfigurationStyle();
        ICallback getSourceFolderHandlesCallback = this.getSourceFolderHandlesCallback;
        ICallback getExistingSourceFolderHandlesCallback = this.getExistingSourceFolderHandlesCallback;
        ICallback<Map<String, String>, IProject> getVariableSubstitutionCallback = new ICallback<Map<String, String>, IProject>(){

            public Map<String, String> call(IProject projectHandle) {
                HashMap<String, String> variableSubstitution = new HashMap<String, String>();
                Object manageLocation = djSettings.djangoVersion.equals(DjangoSettingsPage.DJANGO_14) ? "manage.py" : projectHandle.getName() + "/manage.py";
                switch (sourceFolderConfigurationStyle) {
                    case 1: 
                    case 3: {
                        break;
                    }
                    default: {
                        manageLocation = "src/" + (String)manageLocation;
                    }
                }
                variableSubstitution.put("DJANGO_MANAGE_LOCATION", (String)manageLocation);
                return variableSubstitution;
            }
        };
        PyStructureConfigHelpers.createPydevProject((IProjectDescription)description, (IProject)projectHandle, (IProgressMonitor)monitor, (String)projectType, (String)projectInterpreter, (ICallback)getSourceFolderHandlesCallback, null, (ICallback)getExistingSourceFolderHandlesCallback, (ICallback)getVariableSubstitutionCallback);
        DjangoNature.addNature(projectHandle, null);
        try {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PythonNature nature = PythonNature.getPythonNature((IProject)projectHandle);
            Assert.isNotNull((Object)nature);
            ICodeCompletionASTManager astManager = nature.getAstManager();
            Object sync = new Object();
            int i = 0;
            while (i < 100 && astManager == null) {
                Object object = sync;
                synchronized (object) {
                    try {
                        sync.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                astManager = nature.getAstManager();
                ++i;
            }
            if (astManager == null) {
                throw new RuntimeException("Error creating Django project. ASTManager not available after 10 seconds.\nPlease report this bug at the sourceforge tracker.");
            }
            UniversalRunner.AbstractRunner runner = UniversalRunner.getRunner((IPythonNature)nature);
            IProject projectContainer = switch (sourceFolderConfigurationStyle) {
                case 1, 2, 3 -> projectHandle;
                default -> projectHandle.getFolder("src");
            };
            String projectName = projectHandle.getName();
            Tuple output = runner.runCodeAndGetOutput(RUN_DJANGO_ADMIN, new String[]{"startproject", projectName}, projectContainer.getLocation().toFile(), (IProgressMonitor)new NullProgressMonitor());
            if (((String)output.o2).indexOf("ImportError: no module named django") != -1) {
                RunInUiThread.async((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)EditorUtils.getShell(), (String)"Unable to create project.", (String)"Unable to create project because the selected interpreter does not have django.");
                    }
                });
                projectHandle.delete(true, null);
                return;
            }
            try {
                File copyTo;
                File copyFrom;
                File[] files;
                IDocument docFromResource = null;
                IFile settingsFile = null;
                if (djSettings.djangoVersion.equals(DjangoSettingsPage.DJANGO_14) && (files = (copyFrom = new File(copyTo = projectContainer.getLocation().toFile(), projectName)).listFiles()) != null) {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (f.isFile()) {
                            try {
                                FileUtils.copyFile((File)f, (File)new File(copyTo, f.getName()));
                                FileUtils.deleteFile((File)f);
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                        } else {
                            try {
                                FileUtils.copyDirectory((File)f, (File)new File(copyTo, f.getName()), null, null);
                                FileUtils.deleteDirectoryTree((File)f);
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                        }
                        ++n2;
                    }
                }
                settingsFile = projectContainer.getFile((IPath)new Path(projectName + "/settings.py"));
                settingsFile.refreshLocal(0, null);
                docFromResource = FileUtilsFileBuffer.getDocFromResource((IResource)settingsFile);
                if (docFromResource == null) {
                    throw new RuntimeException("Error creating Django project.\nsettings.py file not created.\nStdout: " + (String)output.o1 + "\nStderr: " + (String)output.o2);
                }
                String settings = docFromResource.get();
                if (djSettings.djangoVersion.equals(DjangoSettingsPage.DJANGO_12_OR_13) || djSettings.djangoVersion.equals(DjangoSettingsPage.DJANGO_14)) {
                    settings = settings.replaceFirst("'ENGINE': 'django.db.backends.'", "'ENGINE': 'django.db.backends." + djSettings.databaseEngine + "'");
                    settings = settings.replaceFirst("'NAME': ''", "'NAME': '" + djSettings.databaseName + "'");
                    settings = settings.replaceFirst("'HOST': ''", "'HOST': '" + djSettings.databaseHost + "'");
                    settings = settings.replaceFirst("'PORT': ''", "'PORT': '" + djSettings.databasePort + "'");
                    settings = settings.replaceFirst("'USER': ''", "'USER': '" + djSettings.databaseUser + "'");
                    settings = settings.replaceFirst("'PASSWORD': ''", "'PASSWORD': '" + djSettings.databasePassword + "'");
                } else {
                    settings = settings.replaceFirst("DATABASE_ENGINE = ''", "DATABASE_ENGINE = '" + djSettings.databaseEngine + "'");
                    settings = settings.replaceFirst("DATABASE_NAME = ''", "DATABASE_NAME = '" + djSettings.databaseName + "'");
                    settings = settings.replaceFirst("DATABASE_HOST = ''", "DATABASE_HOST = '" + djSettings.databaseHost + "'");
                    settings = settings.replaceFirst("DATABASE_PORT = ''", "DATABASE_PORT = '" + djSettings.databasePort + "'");
                    settings = settings.replaceFirst("DATABASE_USER = ''", "DATABASE_USER = '" + djSettings.databaseUser + "'");
                    settings = settings.replaceFirst("DATABASE_PASSWORD = ''", "DATABASE_PASSWORD = '" + djSettings.databasePassword + "'");
                }
                if (settingsFile != null) {
                    settingsFile.setContents((InputStream)new ByteArrayInputStream(settings.getBytes()), 0, monitor);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                RunInUiThread.async(() -> PyDialogHelpers.openCritical((String)"Error creating django project", (String)e.getMessage()));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IProject createNewProject(Object ... additionalArgsToConfigProject) {
        if (additionalArgsToConfigProject != null && additionalArgsToConfigProject.length > 0) {
            throw new RuntimeException("Did not expect to receive arguments here.");
        }
        DjangoSettingsPage.DjangoSettings djSettings = this.settingsPage.getSettings();
        return super.createNewProject(new Object[]{djSettings});
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = PydevPlugin.imageDescriptorFromPlugin((String)DjangoPlugin.getPluginID(), (String)"icons/django_logo.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        return currentPage == this.settingsPage;
    }
}

