/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console.console;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.AsyncCallback;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.python.pydev.shared_core.net.LocalHost;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_interactive_console.console.IXmlRpcClient;

public class ScriptXmlRpcClient
implements IXmlRpcClient {
    private XmlRpcClient impl = new XmlRpcClient();
    private Process process;

    public ScriptXmlRpcClient(Process process) {
        this.process = process;
    }

    @Override
    public void setPort(int port) throws MalformedURLException {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setServerURL(new URL("http://" + LocalHost.getLocalHost() + ":" + port));
        this.impl.setConfig((XmlRpcClientConfig)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(String command, Object[] args) throws XmlRpcException {
        if (this.process != null) {
            try {
                int exitValue = this.process.exitValue();
                return StringUtils.format((String)"Console already exited with value: %s while waiting for an answer.\n", (Object[])new Object[]{exitValue});
            }
            catch (IllegalThreadStateException exitValue) {
                // empty catch block
            }
        }
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.impl.executeAsync(command, args, new AsyncCallback(){

            public void handleError(XmlRpcRequest request, Throwable error) {
                result.set(error.getMessage());
            }

            public void handleResult(XmlRpcRequest request, Object receivedResult) {
                result.set(receivedResult);
            }
        });
        while (result.get() == null) {
            try {
                if (this.process == null) continue;
                int exitValue = this.process.exitValue();
                result.set(StringUtils.format((String)"Console already exited with value: %s while waiting for an answer.\n", (Object[])new Object[]{exitValue}));
                break;
            }
            catch (IllegalThreadStateException e) {
                ScriptXmlRpcClient scriptXmlRpcClient = this;
                synchronized (scriptXmlRpcClient) {
                    try {
                        this.wait(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return result.get();
    }
}

