/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.parser.IPyParser;
import org.python.pydev.parser.IGrammar;
import org.python.pydev.parser.PyParserManager;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.grammar30.PythonGrammar30;
import org.python.pydev.parser.grammar310.PythonGrammar310;
import org.python.pydev.parser.grammar311.PythonGrammar311;
import org.python.pydev.parser.grammar312.PythonGrammar312;
import org.python.pydev.parser.grammar36.PythonGrammar36;
import org.python.pydev.parser.grammar38.PythonGrammar38;
import org.python.pydev.parser.grammar_cython.PyParserCython;
import org.python.pydev.parser.grammarcommon.AbstractPythonGrammar;
import org.python.pydev.parser.jython.FastCharStream;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.Token;
import org.python.pydev.parser.jython.TokenMgrError;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.factory.PyAstFactory;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.model.ErrorDescription;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.out_of_memory.OnExpectedOutOfMemory;
import org.python.pydev.shared_core.parsing.BaseParser;
import org.python.pydev.shared_core.parsing.BaseParserManager;
import org.python.pydev.shared_core.parsing.ChangedParserInfoForObservers;
import org.python.pydev.shared_core.parsing.ErrorParserInfoForObservers;
import org.python.pydev.shared_core.parsing.IParserObserver;
import org.python.pydev.shared_core.parsing.IParserObserver2;
import org.python.pydev.shared_core.parsing.IParserObserver3;
import org.python.pydev.shared_core.preferences.InMemoryEclipsePreferences;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.LowMemoryArrayList;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.structure.Tuple3;

public final class PyParser
extends BaseParser
implements IPyParser {
    public static boolean DEBUG_SHOW_PARSE_ERRORS = false;
    public static boolean USE_FAST_STREAM = true;
    public static boolean ENABLE_TRACING = false;
    private final IGrammarVersionProvider grammarVersionProvider;
    private final List<IPostParserListener> postParserListeners = new LowMemoryArrayList();
    private final Object lockPostParserListeners = new Object();
    public static final List<ICallback<Object, Tuple3<ISimpleNode, Throwable, ParserInfo>>> successfulParseListeners = new ArrayList<ICallback<Object, Tuple3<ISimpleNode, Throwable, ParserInfo>>>();

    public static String getGrammarVersionStr(int grammarVersion) {
        switch (grammarVersion) {
            case 99: {
                return "grammar: Python 3.5";
            }
            case 100: {
                return "grammar: Python 3.6";
            }
            case 101: {
                return "grammar: Python 3.7";
            }
            case 102: {
                return "grammar: Python 3.8";
            }
            case 103: {
                return "grammar: Python 3.9";
            }
            case 104: {
                return "grammar: Python 3.10";
            }
            case 105: {
                return "grammar: Python 3.11";
            }
            case 106: {
                return "grammar: Python 3.12";
            }
            case 107: {
                return "grammar: Python 3.13";
            }
        }
        if (grammarVersion == 777) {
            return "grammar: Cython";
        }
        return "grammar: unrecognized: " + grammarVersion;
    }

    public int getGrammarVersion() throws MisconfigurationException {
        return this.grammarVersionProvider.getGrammarVersion();
    }

    public PyParser(IGrammarVersionProvider grammarVersionProvider) {
        super((BaseParserManager)PyParserManager.getPyParserManager((IEclipsePreferences)new InMemoryEclipsePreferences()));
        if (grammarVersionProvider == null) {
            grammarVersionProvider = new IGrammarVersionProvider(){

                public int getGrammarVersion() {
                    return 107;
                }

                public IGrammarVersionProvider.AdditionalGrammarVersionsToCheck getAdditionalGrammarVersions() throws MisconfigurationException {
                    return null;
                }
            };
        }
        this.grammarVersionProvider = grammarVersionProvider;
    }

    public PyParser(IPyEdit editorView) {
        this(PyParser.getGrammarProviderFromEdit(editorView));
    }

    private static IGrammarVersionProvider getGrammarProviderFromEdit(IPyEdit editorView) {
        return editorView.getGrammarVersionProvider();
    }

    public void notifySaved() {
        this.forceReparse(new Object[0]);
    }

    public boolean forceReparse(Object ... argsToReparse) {
        if (this.disposed) {
            return true;
        }
        return this.scheduler.parseNow(true, argsToReparse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostParseListener(IPostParserListener iParserObserver) {
        Object object = this.lockPostParserListeners;
        synchronized (object) {
            this.postParserListeners.add(iParserObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePostParseListener(IPostParserListener iPostParserListener) {
        Object object = this.lockPostParserListeners;
        synchronized (object) {
            this.postParserListeners.remove(iPostParserListener);
        }
    }

    protected void fireParserChanged(ChangedParserInfoForObservers info) {
        super.fireParserChanged(info);
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.parser.pydev_parser_observer");
        for (IParserObserver observer : participants) {
            try {
                if (observer instanceof IParserObserver3) {
                    ((IParserObserver3)observer).parserChanged(info);
                    continue;
                }
                if (observer instanceof IParserObserver2) {
                    ((IParserObserver2)observer).parserChanged(info.root, info.file, info.doc, info.argsToReparse);
                    continue;
                }
                observer.parserChanged(info.root, info.file, info.doc, info.docModificationStamp);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    protected void fireParserError(ErrorParserInfoForObservers info) {
        super.fireParserError(info);
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.parser.pydev_parser_observer");
        for (IParserObserver observer : participants) {
            if (observer instanceof IParserObserver3) {
                ((IParserObserver3)observer).parserError(info);
                continue;
            }
            if (observer instanceof IParserObserver2) {
                ((IParserObserver2)observer).parserError(info.error, info.file, info.doc, info.argsToReparse);
                continue;
            }
            observer.parserError(info.error, info.file, info.doc);
        }
    }

    public BaseParser.ParseOutput reparseDocument(Object ... argsToReparse) {
        int version;
        IGrammarVersionProvider.AdditionalGrammarVersionsToCheck additionalGrammarsToCheck = null;
        try {
            version = this.grammarVersionProvider.getGrammarVersion();
            additionalGrammarsToCheck = this.grammarVersionProvider.getAdditionalGrammarVersions();
        }
        catch (MisconfigurationException e1) {
            version = 107;
        }
        long documentTime = System.currentTimeMillis();
        BaseParser.ParseOutput obj = PyParser.parseFull(new ParserInfo(this.document, version, true, additionalGrammarsToCheck));
        IFile original = null;
        Object adaptable = null;
        if (this.input == null) {
            return obj;
        }
        original = this.input instanceof IAdaptable ? (IFile)((IAdaptable)this.input).getAdapter(IFile.class) : null;
        adaptable = original != null ? original : (IAdaptable)this.input;
        if (original != null) {
            try {
                PyParser.deleteErrorMarkers((IResource)original);
            }
            catch (ResourceException e) {
                if (original.exists()) {
                    Log.log((Throwable)e);
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        } else if (adaptable == null && !ACCEPT_NULL_INPUT_EDITOR) {
            throw new RuntimeException("Null input editor received in parser!");
        }
        if (this.disposed) {
            return new BaseParser.ParseOutput();
        }
        ErrorParserInfoForObservers errorInfo = null;
        if (obj.error instanceof ParseException || obj.error instanceof TokenMgrError) {
            errorInfo = new ErrorParserInfoForObservers(obj.error, (IAdaptable)adaptable, this.document, argsToReparse);
        }
        if (obj.ast != null) {
            ChangedParserInfoForObservers info = new ChangedParserInfoForObservers(obj.ast, obj.modificationStamp, (IAdaptable)adaptable, this.document, documentTime, errorInfo, argsToReparse);
            this.fireParserChanged(info);
        }
        if (errorInfo != null) {
            this.fireParserError(errorInfo);
        }
        if (this.postParserListeners.size() > 0) {
            ArrayList<IPostParserListener> tempList = new ArrayList<IPostParserListener>(this.postParserListeners);
            for (IPostParserListener iParserObserver : tempList) {
                iParserObserver.participantsNotified(argsToReparse);
            }
        }
        return obj;
    }

    public static SimpleNode parseSimple(String source, IGrammarVersionProvider versionProvider) throws ParseException, MisconfigurationException {
        return PyParser.parseSimple((IDocument)new Document(source), versionProvider);
    }

    public static Module parseSimple(IDocument doc, IGrammarVersionProvider versionProvider) throws ParseException, MisconfigurationException {
        BaseParser.ParseOutput objects = PyParser.parseFull(new ParserInfo(doc, versionProvider));
        Throwable exception = objects.error;
        if (exception != null) {
            if (exception instanceof ParseException) {
                throw (ParseException)exception;
            }
            if (exception instanceof TokenMgrError) {
                throw new ParseException(exception.toString());
            }
            throw new RuntimeException(exception);
        }
        if (objects.error != null) {
            throw new RuntimeException(objects.error);
        }
        return (Module)objects.ast;
    }

    private static char[] createCharArrayToParse(String startDoc) {
        int length = startDoc.length();
        int skipAtStart = 0;
        if (startDoc.startsWith(FileUtils.BOM_UTF8)) {
            skipAtStart = FileUtils.BOM_UTF8.length();
        } else if (startDoc.startsWith(FileUtils.BOM_UNICODE)) {
            skipAtStart = FileUtils.BOM_UNICODE.length();
        }
        int addAtEnd = 0;
        if (!startDoc.endsWith("\n") && !startDoc.endsWith("\r")) {
            addAtEnd = 1;
        }
        char[] charArray = new char[length - skipAtStart + addAtEnd];
        startDoc.getChars(skipAtStart, length, charArray, 0);
        if (addAtEnd > 0) {
            charArray[charArray.length - 1] = 10;
        }
        return charArray;
    }

    public static IGrammar createGrammar(boolean generateTree, int grammarVersion, char[] charArray) {
        FastCharStream in = new FastCharStream(charArray);
        AbstractPythonGrammar grammar = switch (grammarVersion) {
            case 99 -> new PythonGrammar30(generateTree, in);
            case 100 -> new PythonGrammar36(generateTree, in);
            case 101 -> new PythonGrammar36(generateTree, in);
            case 102 -> new PythonGrammar38(generateTree, in);
            case 103 -> new PythonGrammar38(generateTree, in);
            case 104 -> new PythonGrammar310(generateTree, in);
            case 105 -> new PythonGrammar311(generateTree, in);
            case 106 -> new PythonGrammar312(generateTree, in);
            case 107 -> new PythonGrammar312(generateTree, in);
            default -> throw new RuntimeException("The grammar specified for parsing is not valid: " + grammarVersion);
        };
        if (ENABLE_TRACING) {
            grammar.enable_tracing();
        }
        return grammar;
    }

    public static Tuple<SimpleNode, IGrammar> reparseDocumentInternal(IDocument doc, boolean generateTree, int grammarVersion) throws ParseException {
        char[] charArray = PyParser.createCharArrayToParse(doc.get());
        IGrammar grammar = PyParser.createGrammar(generateTree, grammarVersion, charArray);
        return new Tuple((Object)grammar.file_input(), (Object)grammar);
    }

    public static BaseParser.ParseOutput parseFull(IDocument doc, IGrammarVersionProvider versionProvider) throws MisconfigurationException {
        return PyParser.parseFull(new ParserInfo(doc, versionProvider));
    }

    public static BaseParser.ParseOutput parseFull(ParserInfo info) {
        Tuple returnVar;
        long modifiedTime;
        block21: {
            char[] charArray;
            if (info.grammarVersion == 777) {
                return PyParser.createCythonAst(info);
            }
            modifiedTime = ((IDocumentExtension4)info.document).getModificationStamp();
            String startDoc = info.document.get();
            if (startDoc.trim().length() == 0) {
                return new BaseParser.ParseOutput((ISimpleNode)new Module(PyAstFactory.EMPTY_STMT_TYPE), null, modifiedTime);
            }
            HashSet<Integer> parsedVersions = new HashSet<Integer>();
            try {
                charArray = PyParser.createCharArrayToParse(startDoc);
            }
            catch (OutOfMemoryError e1) {
                OnExpectedOutOfMemory.clearCacheOnOutOfMemory.call(null);
                charArray = PyParser.createCharArrayToParse(startDoc);
            }
            startDoc = null;
            returnVar = new Tuple(null, null);
            IGrammar grammar = null;
            try {
                IGrammarVersionProvider.AdditionalGrammarVersionsToCheck additionalGrammarVersionsToCheck;
                SimpleNode newRoot;
                parsedVersions.add(info.grammarVersion);
                grammar = PyParser.createGrammar(info.generateTree, info.grammarVersion, charArray);
                try {
                    newRoot = grammar.file_input();
                }
                catch (OutOfMemoryError e) {
                    OnExpectedOutOfMemory.clearCacheOnOutOfMemory.call(null);
                    newRoot = grammar.file_input();
                }
                returnVar.o1 = newRoot;
                if (successfulParseListeners.size() > 0) {
                    Tuple3 param = new Tuple3((Object)((ISimpleNode)returnVar.o1), (Object)((Throwable)returnVar.o2), (Object)info);
                    for (ICallback iCallback : successfulParseListeners) {
                        iCallback.call((Object)param);
                    }
                }
                returnVar.o2 = grammar.getErrorOnParsing();
                if (returnVar.o2 != null || (additionalGrammarVersionsToCheck = info.additionalGrammarVersionsToCheck) == null) break block21;
                Iterator<Object> iterator = additionalGrammarVersionsToCheck.getGrammarVersions().iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    if (parsedVersions.contains(n)) continue;
                    parsedVersions.add(n);
                    grammar = PyParser.createGrammar(false, n, charArray);
                    try {
                        grammar.file_input();
                    }
                    catch (OutOfMemoryError e) {
                        OnExpectedOutOfMemory.clearCacheOnOutOfMemory.call(null);
                        grammar.file_input();
                    }
                    returnVar.o2 = grammar.getErrorOnParsing();
                    if (returnVar.o2 == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                if (DEBUG_SHOW_PARSE_ERRORS) {
                    e.printStackTrace();
                }
                if (grammar == null) {
                    throw new RuntimeException(e);
                }
                Throwable errorOnParsing = grammar.getErrorOnParsing();
                if (errorOnParsing != null) {
                    e = errorOnParsing;
                } else if (DEBUG_SHOW_PARSE_ERRORS) {
                    System.out.println("Unhandled error");
                    e.printStackTrace();
                }
                grammar = null;
                if (e instanceof ParseException || e instanceof TokenMgrError) {
                    returnVar = new Tuple(null, (Object)e);
                }
                if (e.getClass().getName().indexOf("LookaheadSuccess") != -1) break block21;
                Log.log((Throwable)e);
            }
        }
        if (DEBUG_SHOW_PARSE_ERRORS && returnVar.o1 == null) {
            System.out.println("Unable to parse " + String.valueOf(info));
        }
        return new BaseParser.ParseOutput(returnVar, modifiedTime);
    }

    public static BaseParser.ParseOutput createCythonAst(ParserInfo info) {
        BaseParser.ParseOutput parseOutput = null;
        PyParserCython parserCython = new PyParserCython(info);
        try {
            parseOutput = parserCython.parse();
            parseOutput.isCython = true;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        if (parseOutput == null || parseOutput.ast == null) {
            List<stmtType> classesAndFunctions = FastParser.parseCython(info.document);
            Module ast = new Module(classesAndFunctions.toArray(new stmtType[classesAndFunctions.size()]));
            parseOutput = new BaseParser.ParseOutput((ISimpleNode)ast, parseOutput != null ? parseOutput.error : null, ((IDocumentExtension4)info.document).getModificationStamp());
            parseOutput.isCython = true;
        }
        return parseOutput;
    }

    public static ErrorDescription createParserErrorMarkers(Throwable error, IAdaptable resource, IDocument doc) {
        IResource fileAdapter;
        ErrorDescription errDesc = PyParser.createErrorDesc(error, doc);
        if (resource != null && (fileAdapter = (IResource)resource.getAdapter(IResource.class)) != null) {
            try {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("message", errDesc.message);
                map.put("severity", 2);
                map.put("lineNumber", errDesc.errorLine);
                map.put("charStart", errDesc.errorStart);
                map.put("charEnd", errDesc.errorEnd);
                map.put("transient", true);
                PyParser.createMarker(fileAdapter, map, "org.eclipse.core.resources.problemmarker");
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return errDesc;
    }

    public static void createMarker(final IResource resource, final Map<String, Object> attributes, final String markerType) throws CoreException {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(markerType);
                marker.setAttributes(attributes);
            }
        };
        resource.getWorkspace().run(r, null, 1, null);
    }

    public static ErrorDescription createErrorDesc(Throwable error, IDocument doc) {
        try {
            int errorStart = -1;
            int errorEnd = -1;
            int errorLine = -1;
            String message = null;
            int tokenBeginLine = -1;
            if (error instanceof ParseException) {
                ParseException parseErr = (ParseException)error;
                message = parseErr.getMessage();
                if (parseErr.currentToken == null) {
                    try {
                        IRegion endLine = doc.getLineInformationOfOffset(doc.getLength());
                        errorStart = endLine.getOffset();
                        errorEnd = endLine.getOffset() + endLine.getLength();
                    }
                    catch (BadLocationException endLine) {}
                } else {
                    Token errorToken;
                    Token token = errorToken = parseErr.currentToken.next != null ? parseErr.currentToken.next : parseErr.currentToken;
                    if (errorToken != null) {
                        tokenBeginLine = errorToken.beginLine - 1;
                        try {
                            IRegion startLine = doc.getLineInformation(PyParser.getDocPosFromAstPos(errorToken.beginLine));
                            IRegion endLine = errorToken.endLine == 0 ? startLine : doc.getLineInformation(PyParser.getDocPosFromAstPos(errorToken.endLine));
                            errorStart = startLine.getOffset() + PyParser.getDocPosFromAstPos(errorToken.beginColumn);
                            errorEnd = endLine.getOffset() + errorToken.endColumn;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
            } else if (error instanceof TokenMgrError) {
                TokenMgrError tokenErr = (TokenMgrError)error;
                message = tokenErr.getMessage();
                tokenBeginLine = tokenErr.errorLine - 1;
                try {
                    IRegion startLine = doc.getLineInformation(tokenErr.errorLine - 1);
                    errorStart = startLine.getOffset();
                    errorEnd = startLine.getOffset() + tokenErr.errorColumn;
                }
                catch (BadLocationException badLocationException) {}
            } else {
                Log.log((String)("Error, expecting ParseException or TokenMgrError. Received: " + String.valueOf(error)), (Throwable)error);
                return new ErrorDescription("Internal PyDev Error", 0, 0, 0);
            }
            try {
                errorLine = doc.getLineOfOffset(errorStart) + 1;
            }
            catch (BadLocationException e) {
                errorLine = tokenBeginLine;
            }
            if (message != null) {
                message = StringUtils.replaceNewLines((String)message, (String)" ");
            }
            return new ErrorDescription(message, errorLine, errorStart, errorEnd);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return new ErrorDescription("Internal PyDev Error", 0, 0, 0);
        }
    }

    private static int getDocPosFromAstPos(int astPos) {
        if (astPos > 0) {
            --astPos;
        }
        return astPos;
    }

    public static interface IPostParserListener {
        public void participantsNotified(Object ... var1);
    }

    public static final class ParserInfo
    implements IGrammarVersionProvider {
        public IDocument document;
        public final Set<Integer> linesChanged = new HashSet<Integer>();
        public final int grammarVersion;
        public final String moduleName;
        public final File file;
        public final boolean generateTree;
        public final IGrammarVersionProvider.AdditionalGrammarVersionsToCheck additionalGrammarVersionsToCheck;

        public ParserInfo(IDocument document, int grammarVersion, IGrammarVersionProvider.AdditionalGrammarVersionsToCheck additionalGrammarVersionsToCheck) {
            this(document, grammarVersion, null, null, true, additionalGrammarVersionsToCheck);
        }

        public ParserInfo(IDocument document, IGrammarVersionProvider nature) throws MisconfigurationException {
            this(document, nature.getGrammarVersion(), nature.getAdditionalGrammarVersions());
        }

        public ParserInfo(IDocument document, IGrammarVersionProvider grammarVersionProvider, String moduleName, File file) throws MisconfigurationException {
            this(document, grammarVersionProvider.getGrammarVersion(), moduleName, file, true, grammarVersionProvider.getAdditionalGrammarVersions());
        }

        public ParserInfo(IDocument document, int grammarVersion, String name, File f, boolean generateTree, IGrammarVersionProvider.AdditionalGrammarVersionsToCheck additionalGrammarVersionsToCheck) {
            this.document = document;
            this.grammarVersion = grammarVersion;
            this.moduleName = name;
            this.file = f;
            this.generateTree = generateTree;
            this.additionalGrammarVersionsToCheck = additionalGrammarVersionsToCheck;
        }

        public ParserInfo(IDocument document, IGrammarVersionProvider grammarProvider, boolean generateTree) throws MisconfigurationException {
            this(document, grammarProvider.getGrammarVersion(), null, null, generateTree, grammarProvider.getAdditionalGrammarVersions());
        }

        public ParserInfo(IDocument document, int grammarVersion, boolean generateTree, IGrammarVersionProvider.AdditionalGrammarVersionsToCheck additionalGrammarVersionsToCheck) {
            this(document, grammarVersion, null, null, generateTree, additionalGrammarVersionsToCheck);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("ParserInfo [");
            buf.append("file:");
            buf.append(this.file);
            buf.append("\nmoduleName:");
            buf.append(this.moduleName);
            if (!this.generateTree) {
                buf.append(" NOT GENERATING TREE");
            }
            buf.append("]");
            return buf.toString();
        }

        public int getGrammarVersion() throws MisconfigurationException {
            return this.grammarVersion;
        }

        public IGrammarVersionProvider.AdditionalGrammarVersionsToCheck getAdditionalGrammarVersions() throws MisconfigurationException {
            return this.additionalGrammarVersionsToCheck;
        }
    }
}

