/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import java.math.BigInteger;
import java.util.List;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.grammarcommon.AbstractPythonGrammar;
import org.python.pydev.parser.grammarcommon.AbstractTokenManager;
import org.python.pydev.parser.grammarcommon.IPythonGrammarActions;
import org.python.pydev.parser.grammarcommon.IntStack;
import org.python.pydev.parser.grammarcommon.TokensIterator;
import org.python.pydev.parser.jython.FastCharStream;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.Node;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.Token;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.decoratorsType;

public final class DefaultPythonGrammarActions
implements IPythonGrammarActions {
    private final AbstractPythonGrammar grammar;
    private ISpecialStr lastSpecial;
    private SimpleNode lastNodeWithSpecial;
    private SimpleNode prev;
    IntStack starExpr;

    DefaultPythonGrammarActions(AbstractPythonGrammar grammar) {
        this.grammar = grammar;
    }

    @Override
    public void markDecoratorWithCall() {
        decoratorsType d = (decoratorsType)this.prev;
        d.isCall = true;
    }

    @Override
    public ISpecialStr convertStringToSpecialStr(Object o) throws ParseException {
        if (o instanceof ISpecialStr) {
            return (ISpecialStr)o;
        }
        if (o instanceof Token) {
            return ((Token)o).asSpecialStr();
        }
        return this.createSpecialStr(((String)o).trim(), false, false);
    }

    private ParseException createException(String token, Token currentToken) {
        ParseException e = currentToken != null ? new ParseException("Expected:" + token, currentToken) : (this.grammar.getJJLastPos() != null ? new ParseException("Expected:" + token, this.grammar.getJJLastPos()) : new ParseException("Expected:" + token));
        return e;
    }

    @Override
    public void setImportFromLevel(int level) {
        ((ImportFrom)this.grammar.getJJTree().peekNode()).level = level;
    }

    @Override
    public final ISpecialStr createSpecialStr(String token) throws ParseException {
        return this.createSpecialStr(token, false);
    }

    @Override
    public final ISpecialStr createSpecialStr(String token, boolean searchOnLast) throws ParseException {
        return this.createSpecialStr(token, searchOnLast, true);
    }

    @Override
    public ISpecialStr createSpecialStr(String token, boolean searchOnLast, boolean throwException) throws ParseException {
        Token currentToken = this.grammar.getCurrentToken();
        Token firstTokenToIterate = searchOnLast ? this.grammar.getJJLastPos() : currentToken;
        Token foundToken = null;
        int foundAtPos = 0;
        TokensIterator iterTokens = this.grammar.getTokensIterator(firstTokenToIterate, 50, true);
        while (iterTokens.hasNext()) {
            ++foundAtPos;
            Token next = iterTokens.next();
            if (next.image == null || !next.image.equals(token)) continue;
            foundToken = next;
            break;
        }
        if (foundToken != null && (foundAtPos <= 2 || searchOnLast)) {
            return foundToken.asSpecialStr();
        }
        if (throwException) {
            ParseException e = this.createException(token, currentToken);
            if (foundToken != null) {
                this.grammar.addAndReport(e, "Found at wrong position: " + String.valueOf(foundToken));
                Token beforeLastReturned = iterTokens.getBeforeLastReturned();
                this.grammar.setCurrentToken(beforeLastReturned);
                return foundToken.asSpecialStr();
            }
            if (currentToken != null) {
                AbstractTokenManager tokenManager = this.grammar.getTokenManager();
                FastCharStream inputStream = tokenManager.getInputStream();
                int created = tokenManager.addCustom(currentToken, token);
                if (created != AbstractTokenManager.CUSTOM_NOT_CREATED) {
                    if (created == AbstractTokenManager.CUSTOM_CREATED_WAS_PARENS) {
                        currentToken.next.next = null;
                        if (tokenManager.levelBeforeEof != -1) {
                            tokenManager.indentation.level = tokenManager.levelBeforeEof;
                            tokenManager.levelBeforeEof = -1;
                        }
                        inputStream.restoreLineColPos(currentToken.endLine, currentToken.endColumn);
                    }
                    this.grammar.addAndReport(e, "Created custom token: " + token);
                    return new SpecialStr(token, currentToken.beginLine, currentToken.beginColumn);
                }
            }
            throw e;
        }
        return null;
    }

    @Override
    public void addToPeekCallFunc(Object t, boolean after) {
        Call n = (Call)this.grammar.getJJTree().peekNode();
        this.addSpecial(n.func, t, after);
    }

    @Override
    public void addSpecialTokenToLastOpened(Object o) throws ParseException {
        if ((o = this.convertStringToSpecialStr(o)) != null) {
            SimpleNode lastOpened = this.grammar.getJJTree().getLastOpened();
            if (o instanceof ISpecialStr) {
                this.lastSpecial = (ISpecialStr)o;
                this.lastNodeWithSpecial = lastOpened;
            }
            lastOpened.getSpecialsBefore().add(o);
        }
    }

    @Override
    public final void addToPeek(Object t, boolean after) throws ParseException {
        this.addToPeek(t, after, null);
    }

    @Override
    public SimpleNode addToPeek(Object t, boolean after, Class class_) throws ParseException {
        SimpleNode peeked = this.grammar.getJJTree().peekNode();
        this.addToPeek(peeked, t, after, class_);
        return peeked;
    }

    @Override
    public void markEndDefColon(ISpecialStr s, SimpleNode node) {
        if (node instanceof FunctionDef) {
            FunctionDef functionDef = (FunctionDef)node;
            functionDef.colonDefEnd = s;
        } else if (node instanceof ClassDef) {
            ClassDef classDef = (ClassDef)node;
            classDef.colonDefEnd = s;
        }
    }

    @Override
    public void addToPeek(SimpleNode peeked, Object t, boolean after, Class class_) throws ParseException {
        if (class_ != null && !peeked.getClass().equals(class_)) {
            throw new RuntimeException("Error, expecting class:" + String.valueOf(class_) + " received class:" + String.valueOf(peeked.getClass()) + " Representation:" + String.valueOf(peeked));
        }
        if ((t = this.convertStringToSpecialStr(t)) != null) {
            this.addSpecial(peeked, t, after);
        }
    }

    @Override
    public void jjtreeCloseNodeScope(Node n) throws ParseException {
        SimpleNode peeked = this.grammar.getJJTree().peekNode();
        List<Object> specialTokens = this.grammar.getTokenSourceSpecialTokensList();
        boolean after = true;
        if (n instanceof SimpleNode) {
            if (specialTokens.size() > 0) {
                if (this.prev == null) {
                    after = false;
                    this.prev = peeked;
                }
                for (Object next : specialTokens) {
                    int strategy = 0;
                    if (next instanceof Object[]) {
                        strategy = (Integer)((Object[])next)[1];
                        next = ((Object[])next)[0];
                    }
                    if (strategy == 1) {
                        this.addToPeek(peeked, next, false, null);
                        continue;
                    }
                    if (next instanceof Token) {
                        this.addSpecial(this.findTokenToAdd((Token)next), next, after);
                        continue;
                    }
                    this.addSpecial(this.prev, next, after);
                }
                specialTokens.clear();
            }
            this.prev = peeked;
        }
    }

    private SimpleNode findTokenToAdd(Token next) {
        SimpleNode curr = this.grammar.getJJTree().peekNode();
        if (curr != this.prev) {
            if (this.prev.beginLine == next.beginLine) {
                return this.prev;
            }
            if (curr.beginLine == next.beginLine) {
                return curr;
            }
            if (next.beginLine > this.prev.beginLine && next.beginLine > curr.beginLine) {
                return curr;
            }
        }
        return this.prev;
    }

    private void addSpecial(SimpleNode node, Object special, boolean after) {
        if (special instanceof Token) {
            Token t = (Token)special;
            if (t.toString().trim().startsWith("#")) {
                commentType comment = new commentType(t.image.trim());
                comment.beginColumn = t.beginColumn;
                comment.beginLine = t.beginLine;
                special = comment;
                if (node.beginLine != comment.beginLine && this.lastSpecial != null && this.lastNodeWithSpecial != null && (comment.beginLine < this.lastSpecial.getBeginLine() || comment.beginLine == this.lastSpecial.getBeginLine() && comment.beginColumn < this.lastSpecial.getBeginCol())) {
                    List<Object> specialsBefore = this.lastNodeWithSpecial.getSpecialsBefore();
                    specialsBefore.add(specialsBefore.indexOf(this.lastSpecial), comment);
                    return;
                }
            } else {
                special = t.asSpecialStr();
            }
        }
        node.addSpecial(special, after);
    }

    @Override
    public void addSpecialToken(Object o, int strategy) throws ParseException {
        ISpecialStr t = this.convertStringToSpecialStr(o);
        if (t != null) {
            this.grammar.getTokenSourceSpecialTokensList().add(new Object[]{t, strategy});
        }
    }

    @Override
    public void addSpecialToken(Object o) throws ParseException {
        if (!(o instanceof ISpecialStr)) {
            o = this.convertStringToSpecialStr(o);
        }
        this.grammar.getTokenSourceSpecialTokensList().add(new Object[]{o, 0});
    }

    @Override
    public ISpecialStr findTokenAndAdd(String token) throws ParseException {
        ISpecialStr s = this.createSpecialStr(token, false, true);
        this.grammar.getTokenSourceSpecialTokensList().add(new Object[]{s, 0});
        return s;
    }

    @Override
    public void makeInt(Token t, int radix, Token token, Num numberToFill) throws ParseException {
        this.makeInt(t.image, radix, token, numberToFill);
    }

    @Override
    public void makeIntSub2(Token t, int radix, Token token, Num numberToFill) throws ParseException {
        this.makeInt(t.image.substring(2, t.image.length()), radix, token, numberToFill);
    }

    @Override
    public void makeIntSub2CheckingOct(Token t, int radix, Token token, Num numberToFill) throws ParseException {
        char c;
        String s = t.image;
        if (s.length() >= 2 && ((c = s.charAt(1)) == 'o' || c == 'O')) {
            s = t.image.substring(2, t.image.length());
        }
        this.makeInt(s, radix, token, numberToFill);
    }

    private void makeInt(String s, int radix, Token token, Num numberToFill) throws ParseException {
        long l;
        s = s.replace("_", "");
        numberToFill.num = token.image;
        if (s.endsWith("L") || s.endsWith("l")) {
            s = s.substring(0, s.length() - 1);
            numberToFill.n = new BigInteger(s, radix);
            numberToFill.type = 2;
            return;
        }
        int ndigits = s.length();
        int i = 0;
        while (i < ndigits && s.charAt(i) == '0') {
            ++i;
        }
        if (ndigits - i > 11) {
            numberToFill.n = new BigInteger(s, radix);
            numberToFill.type = 2;
            return;
        }
        try {
            l = Long.valueOf(s, radix);
        }
        catch (NumberFormatException e) {
            this.handleNumberFormatException(token, e);
            l = 0L;
        }
        if (l > 0xFFFFFFFFL || radix == 10 && l > Integer.MAX_VALUE) {
            numberToFill.n = new BigInteger(s, radix);
            numberToFill.type = 2;
            return;
        }
        numberToFill.n = (int)l;
        numberToFill.type = 1;
    }

    @Override
    public void makeFloat(Token t, Num numberToFill) throws ParseException {
        String s;
        numberToFill.num = s = t.image.replace("_", "");
        try {
            numberToFill.n = Float.valueOf(s);
        }
        catch (NumberFormatException e) {
            this.handleNumberFormatException(t, e);
        }
        numberToFill.type = 3;
    }

    private void handleNumberFormatException(Token t, NumberFormatException e) throws ParseException {
        this.grammar.addAndReport(new ParseException("Unable to parse number: " + t.image, t), e.getMessage());
    }

    @Override
    public void makeComplex(Token t, Num numberToFill) throws ParseException {
        String s = t.image.replace("_", "");
        String compNumber = s.substring(0, s.length() - 1);
        numberToFill.num = s;
        try {
            numberToFill.n = Double.valueOf(compNumber);
        }
        catch (NumberFormatException e) {
            this.handleNumberFormatException(t, e);
        }
        numberToFill.type = 6;
    }

    @Override
    public void makeString(Token t, int quotes, Str strToFill) {
        String s = t.image;
        char quoteChar = s.charAt(0);
        int start = 0;
        boolean ustring = false;
        boolean bstring = false;
        boolean fstring = false;
        if (quoteChar == 'u' || quoteChar == 'U') {
            ustring = true;
            ++start;
        } else if (quoteChar == 'b' || quoteChar == 'B') {
            bstring = true;
            ++start;
        } else if (quoteChar == 'f' || quoteChar == 'F') {
            fstring = true;
            ++start;
        }
        quoteChar = s.charAt(start);
        if (quoteChar == 'r' || quoteChar == 'R') {
            if (start == 0) {
                char quoteCharAux = s.charAt(1);
                if (quoteCharAux == 'f' || quoteCharAux == 'F') {
                    fstring = true;
                    ++start;
                } else if (quoteCharAux == 'b' || quoteCharAux == 'B') {
                    bstring = true;
                    ++start;
                }
            }
            String str = s.substring(quotes + start + 1, s.length() - quotes);
            strToFill.type = this.getType(s.charAt(start + 1), quotes);
            strToFill.s = str;
            strToFill.unicode = ustring;
            strToFill.raw = true;
            strToFill.binary = bstring;
            strToFill.fstring = fstring;
        } else {
            int n = s.length() - quotes;
            int i = quotes + start;
            String str = s.substring(i, n);
            strToFill.type = this.getType(s.charAt(start), quotes);
            strToFill.s = str;
            strToFill.unicode = ustring;
            strToFill.raw = false;
            strToFill.binary = bstring;
            strToFill.fstring = fstring;
        }
    }

    private final int getType(char c, int quotes) {
        switch (c) {
            case '\'': {
                return quotes == 1 ? 3 : 1;
            }
            case '\"': {
                return quotes == 1 ? 4 : 2;
            }
        }
        throw new RuntimeException("Unable to determine type. Char: " + c + " quotes:" + quotes);
    }

    @Override
    public void addSpecialToPrev(Object special, boolean after) {
        this.prev.addSpecial(special, after);
    }

    @Override
    public void popStarExpr() {
        if (this.starExpr == null || this.starExpr.sp == 0) {
            Log.log((String)"Scope for star expr not properly set.");
        }
        this.starExpr.pop();
    }

    @Override
    public void pushStarExpr(int ctx) {
        if (this.starExpr == null) {
            this.starExpr = new IntStack();
        }
        this.starExpr.push(ctx);
    }

    @Override
    public int getStarExprScope() {
        if (this.starExpr == null || this.starExpr.sp == 0) {
            Log.log((String)"Scope for star expr not properly set.");
            return 1;
        }
        return this.starExpr.peek();
    }
}

