/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.util.Arrays;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.exprType;

public final class DictComp
extends exprType {
    public exprType key;
    public exprType value;
    public comprehensionType[] generators;

    public DictComp(exprType key, exprType value, comprehensionType[] generators) {
        this.key = key;
        this.value = value;
        this.generators = generators;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + Arrays.hashCode(this.generators);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DictComp other = (DictComp)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return Arrays.equals(this.generators, other.generators);
    }

    @Override
    public DictComp createCopy() {
        return this.createCopy(true);
    }

    @Override
    public DictComp createCopy(boolean copyComments) {
        commentType commentType2;
        comprehensionType[] new0;
        if (this.generators != null) {
            new0 = new comprehensionType[this.generators.length];
            int i = 0;
            while (i < this.generators.length) {
                new0[i] = (comprehensionType)(this.generators[i] != null ? this.generators[i].createCopy(copyComments) : null);
                ++i;
            }
        } else {
            new0 = this.generators;
        }
        DictComp temp = new DictComp(this.key != null ? (exprType)this.key.createCopy(copyComments) : null, this.value != null ? (exprType)this.value.createCopy(copyComments) : null, new0);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsBefore().add(commentType2.createCopy(copyComments));
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsAfter().add(commentType2.createCopy(copyComments));
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("DictComp[");
        sb.append("key=");
        sb.append(this.dumpThis(this.key));
        sb.append(", ");
        sb.append("value=");
        sb.append(this.dumpThis(this.value));
        sb.append(", ");
        sb.append("generators=");
        sb.append(this.dumpThis(this.generators));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitDictComp(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        if (this.key != null) {
            this.key.accept(visitor);
        }
        if (this.value != null) {
            this.value.accept(visitor);
        }
        if (this.generators != null) {
            int i = 0;
            while (i < this.generators.length) {
                if (this.generators[i] != null) {
                    this.generators[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

