/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;

public final class Exec
extends stmtType {
    public exprType body;
    public exprType globals;
    public exprType locals;

    public Exec(exprType body, exprType globals, exprType locals) {
        this.body = body;
        this.globals = globals;
        this.locals = locals;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + (this.globals == null ? 0 : this.globals.hashCode());
        result = 31 * result + (this.locals == null ? 0 : this.locals.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Exec other = (Exec)obj;
        if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
            return false;
        }
        if (this.globals == null ? other.globals != null : !this.globals.equals(other.globals)) {
            return false;
        }
        return !(this.locals == null ? other.locals != null : !this.locals.equals(other.locals));
    }

    @Override
    public Exec createCopy() {
        return this.createCopy(true);
    }

    @Override
    public Exec createCopy(boolean copyComments) {
        commentType commentType2;
        Exec temp = new Exec(this.body != null ? (exprType)this.body.createCopy(copyComments) : null, this.globals != null ? (exprType)this.globals.createCopy(copyComments) : null, this.locals != null ? (exprType)this.locals.createCopy(copyComments) : null);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsBefore().add(commentType2.createCopy(copyComments));
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsAfter().add(commentType2.createCopy(copyComments));
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("Exec[");
        sb.append("body=");
        sb.append(this.dumpThis(this.body));
        sb.append(", ");
        sb.append("globals=");
        sb.append(this.dumpThis(this.globals));
        sb.append(", ");
        sb.append("locals=");
        sb.append(this.dumpThis(this.locals));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitExec(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        if (this.body != null) {
            this.body.accept(visitor);
        }
        if (this.globals != null) {
            this.globals.accept(visitor);
        }
        if (this.locals != null) {
            this.locals.accept(visitor);
        }
    }
}

