/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.util.Arrays;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.enclosingType;
import org.python.pydev.parser.jython.ast.patternType;

public final class MatchSequence
extends patternType
implements enclosingType {
    public patternType[] patterns;
    public int enclosing;

    public MatchSequence(patternType[] patterns, int enclosing) {
        this.patterns = patterns;
        this.enclosing = enclosing;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.patterns);
        result = 31 * result + this.enclosing;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatchSequence other = (MatchSequence)obj;
        if (!Arrays.equals(this.patterns, other.patterns)) {
            return false;
        }
        return this.enclosing == other.enclosing;
    }

    @Override
    public MatchSequence createCopy() {
        return this.createCopy(true);
    }

    @Override
    public MatchSequence createCopy(boolean copyComments) {
        commentType commentType2;
        patternType[] new0;
        if (this.patterns != null) {
            new0 = new patternType[this.patterns.length];
            int i = 0;
            while (i < this.patterns.length) {
                new0[i] = (patternType)(this.patterns[i] != null ? this.patterns[i].createCopy(copyComments) : null);
                ++i;
            }
        } else {
            new0 = this.patterns;
        }
        MatchSequence temp = new MatchSequence(new0, this.enclosing);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsBefore().add(commentType2.createCopy(copyComments));
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsAfter().add(commentType2.createCopy(copyComments));
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MatchSequence[");
        sb.append("patterns=");
        sb.append(this.dumpThis(this.patterns));
        sb.append(", ");
        sb.append("enclosing=");
        sb.append(this.dumpThis(this.enclosing, enclosingType.enclosingTypeNames));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitMatchSequence(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        if (this.patterns != null) {
            int i = 0;
            while (i < this.patterns.length) {
                if (this.patterns[i] != null) {
                    this.patterns[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

