/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinterv2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.prettyprinterv2.ILinePart;
import org.python.pydev.parser.prettyprinterv2.ILinePart2;
import org.python.pydev.parser.prettyprinterv2.LinePart;
import org.python.pydev.parser.prettyprinterv2.LinePartIndentMark;
import org.python.pydev.parser.prettyprinterv2.LinePartRequireAdded;
import org.python.pydev.parser.prettyprinterv2.LinePartRequireIndentMark;
import org.python.pydev.parser.prettyprinterv2.LinePartRequireMark;
import org.python.pydev.parser.prettyprinterv2.LinePartStatementMark;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class PrettyPrinterDocLineEntry {
    private ArrayList<ILinePart> lineParts = new ArrayList();
    private int indentDiff;
    private int emptyLinesRequiredAfterDedent;
    public final int line;
    private boolean lineSorted = false;

    public PrettyPrinterDocLineEntry(int line) {
        this.line = line;
    }

    private void addPart(ILinePart linePart) {
        String token;
        int before = -1;
        if (linePart instanceof LinePartRequireMark && ((token = ((LinePartRequireMark)linePart).getToken().trim()).equals(":") || token.equals(",") || token.equals("(") || token.equals(")") || token.equals("[") || token.equals("]") || token.equals("=") || token.equals("{") || token.equals("}")) && this.lineParts.size() > 0) {
            int i = this.lineParts.size() - 1;
            while (i >= 0) {
                ILinePart existing = this.lineParts.get(i);
                if (!(existing instanceof LinePartStatementMark) && !(existing.getToken() instanceof commentType)) break;
                before = i--;
            }
        }
        if (before != -1) {
            this.lineParts.add(before, linePart);
        } else {
            this.lineParts.add(linePart);
        }
        this.lineSorted = false;
    }

    private void addPart(int i, ILinePart linePart) {
        this.lineParts.add(i, linePart);
        this.lineSorted = false;
    }

    private void sortLineParts() {
        if (!this.lineSorted) {
            Collections.sort(this.lineParts, new Comparator<ILinePart>(){

                @Override
                public int compare(ILinePart o1, ILinePart o2) {
                    return o1.getBeginCol() < o2.getBeginCol() ? -1 : (o1.getBeginCol() == o2.getBeginCol() ? 0 : 1);
                }
            });
            this.lineSorted = true;
        }
    }

    public ILinePart add(int beginCol, String string, Object token) {
        LinePart linePart = new LinePart(beginCol, string, token, this);
        this.addPart(linePart);
        return linePart;
    }

    public ILinePart addBefore(int beginCol, String string, Object token) {
        LinePart linePart = new LinePart(beginCol, string, token, this);
        int i = 0;
        while (i < this.lineParts.size()) {
            if (beginCol == this.lineParts.get(i).getBeginCol()) {
                this.addPart(i, linePart);
                return linePart;
            }
            ++i;
        }
        this.addPart(linePart);
        return linePart;
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer();
        for (ILinePart c : this.getSortedParts()) {
            if (c instanceof ILinePart2) {
                ILinePart2 iLinePart2 = (ILinePart2)c;
                buf.append(iLinePart2.getString());
            } else {
                buf.append(c.toString());
            }
            buf.append(c.isMarkedAsFound() ? "+" : "?");
            buf.append(" ");
        }
        return buf.toString();
    }

    public List<ILinePart> getSortedParts() {
        this.sortLineParts();
        return this.lineParts;
    }

    public void indent(SimpleNode node) {
        this.indent(node, false);
    }

    public LinePartIndentMark indent(SimpleNode node, boolean requireNewLine) {
        ++this.indentDiff;
        LinePartIndentMark linePartIndentMark = new LinePartIndentMark(node.beginColumn, node, true, this);
        linePartIndentMark.setRequireNewLine(requireNewLine);
        this.addPart(linePartIndentMark);
        return linePartIndentMark;
    }

    public LinePartIndentMark dedent(int emptyLinesRequiredAfterDedent) {
        LinePartIndentMark dedentMark;
        if (this.emptyLinesRequiredAfterDedent < emptyLinesRequiredAfterDedent) {
            this.emptyLinesRequiredAfterDedent = emptyLinesRequiredAfterDedent;
        }
        --this.indentDiff;
        List<ILinePart> sortedParts = this.getSortedParts();
        if (sortedParts.size() > 0) {
            dedentMark = new LinePartIndentMark(sortedParts.get(sortedParts.size() - 1).getBeginCol(), "", false, this);
            sortedParts.add(dedentMark);
        } else {
            dedentMark = new LinePartIndentMark(0, "", false, this);
            this.addPart(dedentMark);
        }
        return dedentMark;
    }

    public LinePartIndentMark indentAfter(ILinePart after, boolean requireNewLine) {
        ++this.indentDiff;
        LinePartIndentMark linePartIndentMark = new LinePartIndentMark(after.getBeginCol(), after.getToken(), true, this);
        linePartIndentMark.setRequireNewLine(requireNewLine);
        this.addPart(this.lineParts.indexOf(after) + 1, linePartIndentMark);
        return linePartIndentMark;
    }

    public int getIndentDiff() {
        return this.indentDiff;
    }

    public int getFirstCol() {
        ILinePart iLinePart0;
        this.sortLineParts();
        if (this.lineParts.size() > 0 && !((iLinePart0 = this.lineParts.get(0)) instanceof LinePartRequireAdded)) {
            return iLinePart0.getBeginCol();
        }
        return -1;
    }

    public void addStartStatementMark(ILinePart foundWithLowerLocation, SimpleNode node) {
        this.sortLineParts();
        int i = 0;
        while (i < this.lineParts.size()) {
            if (foundWithLowerLocation == this.lineParts.get(i)) {
                this.addPart(i, new LinePartStatementMark(foundWithLowerLocation.getBeginCol(), node, true, this));
                return;
            }
            ++i;
        }
        this.addPart(new LinePartStatementMark(foundWithLowerLocation.getBeginCol(), node, true, this));
    }

    public void addEndStatementMark(ILinePart foundWithHigherLocation, SimpleNode node) {
        this.addPart(new LinePartStatementMark(foundWithHigherLocation.getBeginCol(), node, false, this));
    }

    public int getNewLinesRequired() {
        return this.emptyLinesRequiredAfterDedent;
    }

    public LinePartRequireMark addRequireMark(int beginColumn, String string) {
        LinePartRequireMark mark = new LinePartRequireMark(beginColumn, string, this);
        this.addPart(mark);
        return mark;
    }

    public LinePartRequireMark addRequireMark(int beginColumn, String ... string) {
        LinePartRequireMark mark = new LinePartRequireMark(beginColumn, this, string);
        this.addPart(mark);
        return mark;
    }

    public LinePartRequireIndentMark addRequireIndentMark(int beginColumn, String string) {
        LinePartRequireIndentMark ret = new LinePartRequireIndentMark(beginColumn, string, this);
        this.addPart(ret);
        return ret;
    }

    public LinePartRequireMark addRequireMarkBefore(ILinePart o1, String string) {
        LinePartRequireMark linePart = new LinePartRequireMark(o1.getBeginCol(), string, this);
        int i = 0;
        while (i < this.lineParts.size()) {
            if (o1 == this.lineParts.get(i)) {
                this.addPart(i, linePart);
                return linePart;
            }
            ++i;
        }
        this.addPart(linePart);
        return linePart;
    }

    public LinePartRequireMark addRequireMarkAfterBefore(ILinePart o1, String string) {
        LinePartRequireMark linePart = new LinePartRequireMark(o1.getBeginCol(), string, this);
        int i = 0;
        while (i < this.lineParts.size()) {
            if (o1 == this.lineParts.get(i)) {
                this.addPart(i + 1, linePart);
                return linePart;
            }
            ++i;
        }
        this.addPart(linePart);
        return linePart;
    }
}

