/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.CoreTextSelection;
import org.python.pydev.shared_core.string.ICoreTextSelection;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Location;
import org.python.pydev.shared_core.utils.Reflection;
import org.python.pydev.shared_ui.editor_input.EditorInputUtils;

public class EditorUtils {
    public static File getFileFromEditorInput(IEditorInput editorInput) {
        File f = null;
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file != null) {
            IPath location = file.getLocation();
            if (location != null) {
                IPath path = location.makeAbsolute();
                f = path.toFile();
            }
        } else {
            try {
                if (editorInput instanceof IURIEditorInput) {
                    IURIEditorInput iuriEditorInput = (IURIEditorInput)editorInput;
                    return new File(iuriEditorInput.getURI());
                }
            }
            catch (Throwable iuriEditorInput) {
                // empty catch block
            }
            try {
                IPath path = (IPath)Reflection.invoke((Object)editorInput, (String)"getPath", (Object[])new Object[0]);
                f = path.toFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return f;
    }

    public static Shell getShell() {
        IWorkbenchWindow activeWorkbenchWindow = EditorUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            Log.log((String)"Error. Not currently with thread access (so, there is no activeWorkbenchWindow available)");
            return null;
        }
        return activeWorkbenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (IllegalStateException e) {
            return null;
        }
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        return activeWorkbenchWindow;
    }

    public static ITextEditor getActiveEditor() {
        IEditorPart activeEditor;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) instanceof ITextEditor) {
            return (ITextEditor)activeEditor;
        }
        return null;
    }

    public static IStatusLineManager getStatusLineManager(ITextEditor editor) {
        IEditorActionBarContributor contributor = editor.getEditorSite().getActionBarContributor();
        if (!(contributor instanceof EditorActionBarContributor)) {
            return null;
        }
        IActionBars actionBars = ((EditorActionBarContributor)contributor).getActionBars();
        if (actionBars == null) {
            return null;
        }
        return actionBars.getStatusLineManager();
    }

    public static IDocument getDocument(ITextEditor editor) {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider != null) {
            return documentProvider.getDocument((Object)editor.getEditorInput());
        }
        return null;
    }

    public static TextSelectionUtils createTextSelectionUtils(ITextEditor editor) {
        ISelection selection;
        IDocument document = EditorUtils.getDocument(editor);
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            CoreTextSelection coreTextSelection = new CoreTextSelection(document, textSelection.getOffset(), textSelection.getLength());
            return new TextSelectionUtils(document, (ICoreTextSelection)coreTextSelection);
        }
        Log.log((String)("Unable to get selection provider from editor: " + String.valueOf(editor)));
        return new TextSelectionUtils(document, 0);
    }

    public static void showInEditor(ITextEditor textEdit, Location start, Location end) {
        try {
            IDocument doc = textEdit.getDocumentProvider().getDocument((Object)textEdit.getEditorInput());
            int s = start.toOffset(doc);
            int e = end == null ? s : end.toOffset(doc);
            TextSelection sel = new TextSelection(s, e - s);
            textEdit.getSelectionProvider().setSelection((ISelection)sel);
        }
        catch (BadLocationException e1) {
            Log.log((int)4, (String)("Error setting selection:" + String.valueOf(start) + " - " + String.valueOf(end) + " - " + String.valueOf(textEdit)), (Throwable)e1);
        }
    }

    public static void showInEditor(ITextEditor textEdit, IRegion region) {
        TextSelection sel = new TextSelection(region.getOffset(), region.getLength());
        textEdit.getSelectionProvider().setSelection((ISelection)sel);
    }

    public static void showInEditor(ITextEditor textEdit, int lineNumber) {
        IDocument document;
        if (lineNumber > 0 && (document = textEdit.getDocumentProvider().getDocument((Object)textEdit.getEditorInput())) != null) {
            IRegion lineInfo = null;
            try {
                lineInfo = document.getLineInformation(lineNumber - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (lineInfo != null) {
                textEdit.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength());
            }
        }
    }

    public static IEditorPart openFile(File fileToOpen) {
        return EditorUtils.openFile(fileToOpen, true);
    }

    public static IEditorPart openFile(File fileToOpen, boolean activate) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            throw new RuntimeException("workbench cannot be null");
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            throw new RuntimeException("activeWorkbenchWindow cannot be null (we have to be in a ui thread for this to work)");
        }
        IWorkbenchPage wp = activeWorkbenchWindow.getActivePage();
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
        try {
            if (activate) {
                return IDE.openEditorOnFileStore((IWorkbenchPage)wp, (IFileStore)fileStore);
            }
            IEditorInput input = EditorUtils.getEditorInput(fileStore);
            String editorId = EditorUtils.getEditorId(input, null);
            return wp.openEditor(input, editorId, activate);
        }
        catch (Exception e) {
            Log.log((String)"Editor failed to open", (Throwable)e);
            return null;
        }
    }

    private static IEditorInput getEditorInput(IFileStore fileStore) {
        IFile workspaceFile = EditorUtils.getWorkspaceFile(fileStore);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        return new FileStoreEditorInput(fileStore);
    }

    private static IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocationURI(fileStore.toURI());
        if ((files = EditorUtils.filterNonExistentFiles(files)) == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    private static IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    public static IEditorPart openFile(IFile fileToOpen) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            throw new RuntimeException("workbench cannot be null");
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            throw new RuntimeException("activeWorkbenchWindow cannot be null (we have to be in a ui thread for this to work)");
        }
        IWorkbenchPage wp = activeWorkbenchWindow.getActivePage();
        try {
            return IDE.openEditor((IWorkbenchPage)wp, (IFile)fileToOpen);
        }
        catch (Exception e) {
            Log.log((String)"Editor failed to open", (Throwable)e);
            return null;
        }
    }

    public static IWorkbenchPartSite getSite() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        return activeEditor.getSite();
    }

    public static String getEditorId(IEditorInput input, Object element) {
        IEditorDescriptor defaultEditor;
        String name = input.getName();
        if (name == null) {
            return null;
        }
        try {
            IFile iFile = (IFile)input.getAdapter(IFile.class);
            if (iFile != null && (defaultEditor = IDE.getDefaultEditor((IFile)iFile)) != null) {
                return defaultEditor.getId();
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        defaultEditor = editorReg.getDefaultEditor(name);
        if (defaultEditor == null) {
            return null;
        }
        return defaultEditor.getId();
    }

    public static List<Object> getFilesInOpenEditors(IStatusLineManager statusLineManager) {
        IWorkbenchWindow window = EditorUtils.getActiveWorkbenchWindow();
        if (window == null) {
            if (statusLineManager != null) {
                statusLineManager.setErrorMessage("Active workbench window is null.");
            }
            return new ArrayList<Object>(0);
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            if (statusLineManager != null) {
                statusLineManager.setErrorMessage("Active page is null.");
            }
            return new ArrayList<Object>(0);
        }
        IEditorReference[] editorsArray = activePage.getEditorReferences();
        ArrayList<Object> files = new ArrayList<Object>();
        int i = 0;
        while (i < editorsArray.length) {
            IEditorPart realEditor = editorsArray[i].getEditor(true);
            if (realEditor != null) {
                if (realEditor instanceof MultiPageEditorPart) {
                    try {
                        Method getPageCount = MultiPageEditorPart.class.getDeclaredMethod("getPageCount", new Class[0]);
                        getPageCount.setAccessible(true);
                        Method getEditor = MultiPageEditorPart.class.getDeclaredMethod("getEditor", Integer.TYPE);
                        getEditor.setAccessible(true);
                        Integer pageCount = (Integer)getPageCount.invoke((Object)realEditor, new Object[0]);
                        int j = 0;
                        while (j < pageCount) {
                            IEditorInput input;
                            IEditorPart part = (IEditorPart)getEditor.invoke((Object)realEditor, j);
                            if (part != null && (input = part.getEditorInput()) != null) {
                                IFile file = (IFile)input.getAdapter(IFile.class);
                                if (file != null) {
                                    files.add(file);
                                } else {
                                    File file2 = EditorInputUtils.getFile(input);
                                    if (file2 != null) {
                                        files.add(file2);
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    catch (Throwable e1) {
                        Log.log((Throwable)e1);
                    }
                } else {
                    IEditorInput input = realEditor.getEditorInput();
                    if (input != null) {
                        IFile file = (IFile)input.getAdapter(IFile.class);
                        if (file != null) {
                            files.add(file);
                        } else {
                            File file2 = EditorInputUtils.getFile(input);
                            if (file2 != null) {
                                files.add(file2);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return files;
    }
}

