/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageDescriptor;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.structure.Tuple3;
import org.python.pydev.shared_core.structure.Tuple4;
import org.python.pydev.shared_ui.FontUtils;

public class ImageCache
implements IImageCache {
    private final Map<Object, Image> imageHash = new HashMap<Object, Image>(10);
    private final Map<Object, ImageDescriptor> descriptorHash = new HashMap<Object, ImageDescriptor>(10);
    private final ImageDecorator imageDecorator = new ImageDecorator();
    private final URL baseURL;
    private volatile Image missing = null;
    private final Object lock = new Object();
    private final Object descriptorLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getFromImageHash(Object key) {
        Object object = this.lock;
        synchronized (object) {
            Image ret = this.imageHash.get(key);
            if (ret != null && ret.isDisposed()) {
                this.imageHash.remove(key);
                ret = null;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image putOnImageHash(Object key, Image image) {
        Object object = this.lock;
        synchronized (object) {
            Image createdInMeanwhile = this.imageHash.get(key);
            if (createdInMeanwhile != null && !createdInMeanwhile.isDisposed()) {
                image.dispose();
                image = createdInMeanwhile;
            } else {
                this.imageHash.put(key, image);
            }
            return image;
        }
    }

    public ImageCache(URL baseURL) {
        this.baseURL = baseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<Image> e = this.imageHash.values().iterator();
            while (e.hasNext()) {
                e.next().dispose();
            }
            this.imageHash.clear();
            Image m = this.missing;
            if (m != null) {
                m.dispose();
            }
            this.missing = null;
        }
    }

    public IImageHandle get(String key) {
        Image image = this.getFromImageHash(key);
        if (image == null) {
            ImageDescriptor desc;
            try {
                desc = ImageCache.asImageDescriptor(this.getDescriptor(key));
                image = desc.createImage();
                image = this.putOnImageHash(key, image);
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
            catch (UnsatisfiedLinkError e) {
                return null;
            }
            catch (Exception e) {
                Log.log((String)("ERROR: Missing image: " + key));
                Image m = this.missing;
                if (m == null || m.isDisposed()) {
                    desc = ImageDescriptor.getMissingImageDescriptor();
                    m = this.missing = desc.createImage();
                }
                image = m;
            }
        }
        final Image computed = image;
        return new IImageHandle(){

            public Object getImage() {
                return computed;
            }

            public Object getImageData() {
                return computed.getImageData();
            }
        };
    }

    public IImageHandle getImageDecorated(String key, String decoration) {
        return this.getImageDecorated(key, decoration, 0);
    }

    public IImageHandle getImageDecorated(String key, String decoration, int decorationLocation) {
        return this.getImageDecorated(key, decoration, decorationLocation, null, -1);
    }

    public IImageHandle getImageDecorated(String key, String decoration, int decorationLocation, String secondDecoration, int secondDecorationLocation) {
        Image image;
        Display display = Display.getCurrent();
        if (display == null) {
            Log.log((String)"This method should only be called in a UI thread.");
        }
        Tuple4 cacheKey = new Tuple4((Object)key, (Object)decoration, (Object)decorationLocation, (Object)"imageDecoration");
        if (secondDecoration != null) {
            cacheKey = new Tuple3((Object)cacheKey, (Object)secondDecoration, (Object)secondDecorationLocation);
        }
        if ((image = this.getFromImageHash(cacheKey)) == null) {
            ImageData baseImageData = (ImageData)this.get(key).getImageData();
            image = this.decorateImage(decoration, decorationLocation, display, baseImageData);
            if (secondDecoration != null) {
                image = this.decorateImage(secondDecoration, secondDecorationLocation, display, image.getImageData());
            }
            image = this.putOnImageHash(cacheKey, image);
        }
        final Image computed = image;
        return new IImageHandle(){

            public Object getImageData() {
                return computed.getImageData();
            }

            public Object getImage() {
                return computed;
            }
        };
    }

    private Image decorateImage(String decoration, int decorationLocation, Display display, ImageData baseImageData) throws AssertionError {
        ImageData decorationImageData = (ImageData)this.get(decoration).getImageData();
        Image image = new Image((Device)display, switch (decorationLocation) {
            case 0 -> this.imageDecorator.drawDecoration(baseImageData, decorationImageData, baseImageData.width - decorationImageData.width, 0);
            case 1 -> this.imageDecorator.drawDecoration(baseImageData, decorationImageData, baseImageData.width - decorationImageData.width, baseImageData.height - decorationImageData.height);
            default -> throw new AssertionError((Object)("Decoration location not recognized: " + decorationLocation));
        });
        return image;
    }

    public IImageHandle getStringDecorated(String key, String stringToAddToDecoration) {
        Tuple3 cacheKey;
        Image image;
        Display display = Display.getCurrent();
        if (display == null) {
            Log.log((String)"This method should only be called in a UI thread.");
        }
        if ((image = this.getFromImageHash(cacheKey = new Tuple3((Object)key, (Object)stringToAddToDecoration, (Object)"stringDecoration"))) == null) {
            block7: {
                image = new Image((Device)display, ImageCache.asImage(this.get(key)), 0);
                GC gc = new GC((Drawable)image);
                Color colorBackground = new Color((Device)display, 255, 255, 255);
                Color colorForeground = new Color((Device)display, 0, 83, 41);
                FontData fontData = FontUtils.getFontData(3, true);
                fontData.setStyle(1);
                Font font = new Font((Device)display, fontData);
                try {
                    try {
                        gc.setForeground(colorForeground);
                        gc.setBackground(colorBackground);
                        gc.setTextAntialias(1);
                        gc.setFont(font);
                        gc.drawText(stringToAddToDecoration, 5, 0, true);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                        colorBackground.dispose();
                        colorForeground.dispose();
                        font.dispose();
                        gc.dispose();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    colorBackground.dispose();
                    colorForeground.dispose();
                    font.dispose();
                    gc.dispose();
                    throw throwable;
                }
                colorBackground.dispose();
                colorForeground.dispose();
                font.dispose();
                gc.dispose();
            }
            image = this.putOnImageHash(cacheKey, image);
        }
        final Image computed = image;
        return new IImageHandle(){

            public Object getImageData() {
                return computed.getImageData();
            }

            public Object getImage() {
                return computed;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImageDescriptor getDescriptor(String key) {
        ImageDescriptor desc;
        Object object = this.descriptorLock;
        synchronized (object) {
            desc = this.descriptorHash.get(key);
            if (desc == null) {
                try {
                    URL url = new URL(this.baseURL, key);
                    desc = ImageDescriptor.createFromURL((URL)url);
                }
                catch (MalformedURLException e) {
                    Log.log((String)("ERROR: Missing image: " + key));
                    desc = ImageDescriptor.getMissingImageDescriptor();
                }
                this.descriptorHash.put(key, desc);
            }
        }
        final ImageDescriptor computed = desc;
        return new IImageDescriptor(){

            public Object getImageDescriptor() {
                return computed;
            }
        };
    }

    public static ImageDescriptor asImageDescriptor(IImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return (ImageDescriptor)descriptor.getImageDescriptor();
    }

    public static Image asImage(IImageHandle imageHandle) {
        if (imageHandle == null) {
            return null;
        }
        return (Image)imageHandle.getImage();
    }

    private static final class ImageDecorator
    extends CompositeImageDescriptor {
        private Point size;
        private ImageData base;
        private ImageData decoration;
        private int ox;
        private int oy;

        private ImageDecorator() {
        }

        protected Point getSize() {
            return this.size;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.base, 0, 0);
            this.drawImage(this.decoration, this.ox, this.oy);
        }

        public final ImageData drawDecoration(ImageData base, ImageData decoration, int ox, int oy) {
            this.size = new Point(base.width, base.height);
            this.base = base;
            this.decoration = decoration;
            this.ox = ox;
            this.oy = oy;
            return this.getImageData();
        }
    }
}

