/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class SelectElementDialog
extends ElementListSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.python.pydev.shared_ui.dialogs.SelectElementDialog";
    private final IDialogSettings dialogSettings = SharedUiPlugin.getDefault().getDialogSettings();

    public SelectElementDialog(Shell parent, ILabelProvider renderer) {
        super(parent, renderer);
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        SharedUiPlugin.setCssId(parent, "py-select-dialog", true);
        return ret;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        Control area = this.getDialogArea();
        if (area != null) {
            SharedUiPlugin.fixSelectionStatusDialogStatusLineColor((Object)this, area.getBackground());
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings section = this.dialogSettings.getSection(DIALOG_SETTINGS);
        if (section == null) {
            section = this.dialogSettings.addNewSection(DIALOG_SETTINGS);
        }
        return section;
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            try {
                int width = settings.getInt("DIALOG_WIDTH");
                int height = settings.getInt("DIALOG_HEIGHT");
                if (width > 0 & height > 0) {
                    return new Point(width, height);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Point(300, 300);
    }

    public static <T> T selectOne(List<T> items, LabelProvider labelProvider, String message) {
        Shell activeShell = Display.getCurrent().getActiveShell();
        SelectElementDialog dialog = new SelectElementDialog(activeShell, (ILabelProvider)labelProvider);
        dialog.setTitle("Select One");
        dialog.setMessage(message);
        dialog.setElements(items.toArray());
        dialog.setMultipleSelection(false);
        int returnCode = dialog.open();
        if (returnCode == 0) {
            return (T)dialog.getFirstResult();
        }
        return null;
    }

    public static String[] selectMulti(List<String> items, LabelProvider labelProvider, String message) {
        Shell activeShell = Display.getCurrent().getActiveShell();
        SelectElementDialog dialog = new SelectElementDialog(activeShell, (ILabelProvider)labelProvider);
        dialog.setTitle("Select (multiple)");
        dialog.setMessage(message);
        dialog.setElements(items.toArray());
        dialog.setMultipleSelection(true);
        int returnCode = dialog.open();
        if (returnCode == 0) {
            Object[] selectedElements = dialog.getResult();
            if (selectedElements == null) {
                return null;
            }
            String[] ret = new String[selectedElements.length];
            int i = 0;
            while (i < selectedElements.length) {
                ret[i] = selectedElements[i].toString();
                ++i;
            }
            return ret;
        }
        return null;
    }
}

