/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.mark_occurrences;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_ui.editor.BaseEditor;

public abstract class BaseMarkOccurrencesJob
extends Job {
    public static final boolean DEBUG = false;
    protected WeakReference<BaseEditor> editor;
    private long currRequestTime = -1L;
    private static volatile long lastRequestTime = -1L;
    private static BaseMarkOccurrencesJob currRunningInstance;
    private static final Object lock;
    protected TextSelectionUtils ps;

    static {
        lock = new Object();
    }

    public BaseMarkOccurrencesJob(String string) {
        super(string);
    }

    public static synchronized void scheduleRequest(BaseMarkOccurrencesJob newJob) {
        BaseMarkOccurrencesJob.scheduleRequest(newJob, 700);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void scheduleRequest(BaseMarkOccurrencesJob newJob, int scheduleTime) {
        Object object = lock;
        synchronized (object) {
            BaseMarkOccurrencesJob j = currRunningInstance;
            if (j != null) {
                j.cancel();
                currRunningInstance = null;
            }
            currRunningInstance = newJob;
            currRunningInstance.schedule(scheduleTime);
        }
    }

    protected BaseMarkOccurrencesJob(WeakReference<BaseEditor> editor, TextSelectionUtils ps) {
        super("MarkOccurrencesJob");
        this.setPriority(40);
        this.setSystem(true);
        this.editor = editor;
        this.ps = ps;
        this.currRequestTime = System.currentTimeMillis();
    }

    protected abstract MarkOccurrencesRequest createRequest(BaseEditor var1, IDocumentProvider var2, IProgressMonitor var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        block26: {
            if (this.currRequestTime == -1L) {
                return Status.OK_STATUS;
            }
            if (this.currRequestTime == lastRequestTime) {
                return Status.OK_STATUS;
            }
            lastRequestTime = this.currRequestTime;
            monitor = new ProgressMonitorWrapper((IProgressMonitor)monitor){

                public boolean isCanceled() {
                    return super.isCanceled() || BaseMarkOccurrencesJob.this.currRequestTime != lastRequestTime;
                }
            };
            BaseEditor baseEditor = (BaseEditor)((Object)this.editor.get());
            try {
                try {
                    if (baseEditor == null || monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    IEditorInput editorInput = baseEditor.getEditorInput();
                    if (editorInput == null) {
                        return Status.OK_STATUS;
                    }
                    IDocumentProvider documentProvider = baseEditor.getDocumentProvider();
                    if (documentProvider == null || monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)baseEditor.getEditorInput());
                    if (annotationModel == null || monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    if (documentProvider.getDocument((Object)editorInput) == null) {
                        return Status.OK_STATUS;
                    }
                    if (baseEditor.getSelectionProvider() == null) {
                        return Status.OK_STATUS;
                    }
                    if (monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    MarkOccurrencesRequest ret = this.createRequest(baseEditor, documentProvider, (IProgressMonitor)monitor);
                    if (baseEditor.cache == null || monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    if (ret != null && ret.proceedWithMarkOccurrences) {
                        Map<String, Object> cache = baseEditor.cache;
                        if (cache == null) {
                            return Status.OK_STATUS;
                        }
                        Map<Annotation, Position> annotationsToAddAsMap = this.getAnnotationsToAddAsMap(baseEditor, annotationModel, ret, (IProgressMonitor)monitor);
                        if (annotationsToAddAsMap == null) {
                            this.removeOccurenceAnnotations(annotationModel, baseEditor);
                            break block26;
                        }
                        List<Annotation> toRemove = this.getOccurrenceAnnotationsInEditor(baseEditor);
                        Thread.yield();
                        Thread thread = Thread.currentThread();
                        int initiaThreadlPriority = thread.getPriority();
                        try {
                            thread.setPriority(5);
                            Object object = this.getLockObject(annotationModel);
                            synchronized (object) {
                                IAnnotationModelExtension ext = (IAnnotationModelExtension)annotationModel;
                                ext.replaceAnnotations(toRemove.toArray(new Annotation[0]), annotationsToAddAsMap);
                            }
                        }
                        finally {
                            thread.setPriority(initiaThreadlPriority);
                        }
                        cache.put(this.getOccurrenceAnnotationsCacheKey(), new ArrayList<Annotation>(annotationsToAddAsMap.keySet()));
                        break block26;
                    }
                    this.removeOccurenceAnnotations(annotationModel, baseEditor);
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (AssertionFailedException e) {
                    String message = e.getMessage();
                    if (message == null || message.indexOf("The file:") == -1 || message.indexOf("does not exist.") == -1) {
                        Log.log((Throwable)e);
                        Log.log((String)("Error while analyzing the file:" + String.valueOf(baseEditor.getIFile())));
                    }
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Status.OK_STATUS;
    }

    protected abstract Map<Annotation, Position> getAnnotationsToAddAsMap(BaseEditor var1, IAnnotationModel var2, MarkOccurrencesRequest var3, IProgressMonitor var4) throws BadLocationException;

    protected Object getLockObject(IAnnotationModel annotationModel) {
        if (annotationModel instanceof ISynchronizable) {
            return ((ISynchronizable)annotationModel).getLockObject();
        }
        return annotationModel;
    }

    protected abstract String getOccurrenceAnnotationsCacheKey();

    protected abstract String getOccurrenceAnnotationsType();

    public final List<Annotation> getOccurrenceAnnotationsInEditor(BaseEditor baseEditor) {
        ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
        Map<String, Object> cache = baseEditor.cache;
        if (cache == null) {
            return toRemove;
        }
        List inEdit = (List)cache.get(this.getOccurrenceAnnotationsCacheKey());
        if (inEdit != null) {
            for (Annotation annotation : inEdit) {
                if (!annotation.getType().equals(this.getOccurrenceAnnotationsType())) continue;
                toRemove.add(annotation);
            }
        }
        return toRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void removeOccurenceAnnotations(IAnnotationModel annotationModel, BaseEditor pyEdit) {
        Map<String, Object> cache = pyEdit.cache;
        if (cache == null) {
            return;
        }
        Thread.yield();
        Thread thread = Thread.currentThread();
        int initiaThreadlPriority = thread.getPriority();
        thread.setPriority(5);
        try {
            Object object = this.getLockObject(annotationModel);
            synchronized (object) {
                List<Annotation> annotationsToRemove = this.getOccurrenceAnnotationsInEditor(pyEdit);
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(annotationsToRemove.toArray(new Annotation[annotationsToRemove.size()]), new HashMap());
                } else {
                    Iterator<Annotation> annotationIterator = annotationsToRemove.iterator();
                    while (annotationIterator.hasNext()) {
                        annotationModel.removeAnnotation(annotationIterator.next());
                    }
                }
                cache.put(this.getOccurrenceAnnotationsCacheKey(), null);
            }
        }
        finally {
            thread.setPriority(initiaThreadlPriority);
        }
    }

    protected static class MarkOccurrencesRequest {
        public final boolean proceedWithMarkOccurrences;

        public MarkOccurrencesRequest(boolean proceedWithMarkOccurrences) {
            this.proceedWithMarkOccurrences = proceedWithMarkOccurrences;
        }
    }
}

